/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.SemType;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantTypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.EffectiveTypePopulator;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public class TypeResolver {
    private static final CompilerContext.Key<TypeResolver> TYPE_RESOLVER_KEY = new CompilerContext.Key();
    private final SymbolTable symTable;
    private final Names names;
    private final SymbolResolver symResolver;
    private final SymbolEnter symEnter;
    private final BLangDiagnosticLog dlog;
    private final Types types;
    private int typePrecedence;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private final ConstantTypeChecker constantTypeChecker;
    private final ConstantTypeChecker.ResolveConstantExpressionType resolveConstantExpressionType;
    private final EffectiveTypePopulator effectiveTypePopulator;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private final BLangMissingNodesHelper missingNodesHelper;
    private final List<BLangTypeDefinition> resolvingTypeDefinitions = new ArrayList<BLangTypeDefinition>();
    private HashMap<BIntersectionType, BLangIntersectionTypeNode> intersectionTypeList;
    public HashSet<BLangConstant> resolvedConstants = new HashSet();
    private final ArrayList<BLangConstant> resolvingConstants = new ArrayList();
    private Deque<String> resolvingModuleDefs;
    private final HashSet<BLangClassDefinition> resolvedClassDef = new HashSet();
    private final Map<String, BLangNode> modTable = new LinkedHashMap<String, BLangNode>();
    private final Map<String, BLangConstantValue> constantMap = new HashMap<String, BLangConstantValue>();
    private HashSet<LocationData> unknownTypeRefs;
    private SymbolEnv pkgEnv;
    private int currentDepth;
    private Deque<BType> resolvingTypes;
    public HashSet<BStructureType> resolvingStructureTypes = new HashSet();

    public TypeResolver(CompilerContext context) {
        context.put(TYPE_RESOLVER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symEnter = SymbolEnter.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.types = Types.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.constantTypeChecker = ConstantTypeChecker.getInstance(context);
        this.resolveConstantExpressionType = ConstantTypeChecker.ResolveConstantExpressionType.getInstance(context);
        this.effectiveTypePopulator = EffectiveTypePopulator.getInstance(context);
        this.unknownTypeRefs = new HashSet();
    }

    public void clearUnknownTypeRefs() {
        this.unknownTypeRefs.clear();
    }

    private void clear() {
        this.modTable.clear();
        this.constantMap.clear();
        this.resolvingTypeDefinitions.clear();
        this.resolvedConstants.clear();
        this.resolvingConstants.clear();
        this.resolvedClassDef.clear();
        this.resolvingStructureTypes.clear();
    }

    public static TypeResolver getInstance(CompilerContext context) {
        TypeResolver typeResolver = context.get(TYPE_RESOLVER_KEY);
        if (typeResolver == null) {
            typeResolver = new TypeResolver(context);
        }
        return typeResolver;
    }

    public HashSet<LocationData> getUnknownTypeRefs() {
        return this.unknownTypeRefs;
    }

    public void setUnknownTypeRefs(HashSet<LocationData> unknownTypeRefs) {
        this.unknownTypeRefs = unknownTypeRefs;
    }

    public void defineBTypes(List<BLangNode> moduleDefs, SymbolEnv pkgEnv) {
        this.pkgEnv = pkgEnv;
        this.typePrecedence = 0;
        for (BLangNode moduleDef : moduleDefs) {
            if (moduleDef.getKind() == NodeKind.XMLNS) continue;
            String typeOrClassName = SymbolEnter.getTypeOrClassName(moduleDef);
            if (this.modTable.containsKey(typeOrClassName)) continue;
            this.modTable.put(typeOrClassName, moduleDef);
        }
        for (BLangNode def : moduleDefs) {
            this.resolvingTypes = new ArrayDeque<BType>();
            this.resolvingModuleDefs = new ArrayDeque<String>();
            switch (def.getKind()) {
                case CLASS_DEFN: {
                    this.intersectionTypeList = new HashMap();
                    this.extracted(pkgEnv, (BLangClassDefinition)def, 0);
                    this.updateEffectiveTypeOfCyclicIntersectionTypes(pkgEnv);
                    break;
                }
                case CONSTANT: {
                    this.resolveConstant(pkgEnv, this.modTable, (BLangConstant)def);
                    break;
                }
                case XMLNS: {
                    this.resolveXMLNS(pkgEnv, (BLangXMLNS)def);
                    break;
                }
                default: {
                    BLangTypeDefinition typeDefinition = (BLangTypeDefinition)def;
                    this.intersectionTypeList = new HashMap();
                    this.resolveTypeDefinition(pkgEnv, this.modTable, typeDefinition, 0);
                    BType type = typeDefinition.typeNode.getBType();
                    if (typeDefinition.hasCyclicReference) {
                        this.updateIsCyclicFlag(type);
                    }
                    this.updateEffectiveTypeOfCyclicIntersectionTypes(pkgEnv);
                }
            }
            this.resolvingTypes.clear();
            this.resolvingModuleDefs.clear();
        }
        this.clear();
    }

    private BType extracted(SymbolEnv pkgEnv, BLangClassDefinition classDefinition, int depth) {
        if (this.resolvedClassDef.contains(classDefinition)) {
            return classDefinition.getBType();
        }
        String currentDefnName = classDefinition.name.value;
        if (depth == classDefinition.cycleDepth) {
            this.logInvalidCyclicReferenceError(currentDefnName, classDefinition.pos);
            return this.symTable.semanticError;
        }
        this.currentDepth = depth;
        classDefinition.cycleDepth = depth;
        this.resolvingModuleDefs.push(currentDefnName);
        if (classDefinition.getBType() != null) {
            return classDefinition.getBType();
        }
        this.defineClassDef(classDefinition, pkgEnv);
        this.symEnter.defineDistinctClassAndObjectDefinitionIndividual(classDefinition);
        this.defineFields(classDefinition, pkgEnv);
        this.resolvedClassDef.add(classDefinition);
        this.resolvingModuleDefs.pop();
        BObjectType classDefType = (BObjectType)classDefinition.getBType();
        this.resolvingStructureTypes.remove(classDefType);
        classDefinition.setPrecedence(this.typePrecedence++);
        return classDefType;
    }

    public void defineFields(BLangNode typeDefNode, SymbolEnv pkgEn) {
        ++this.currentDepth;
        if (typeDefNode.getKind() == NodeKind.CLASS_DEFN) {
            BLangClassDefinition classDefinition = (BLangClassDefinition)typeDefNode;
            if (this.symEnter.isObjectCtor(classDefinition)) {
                return;
            }
            this.defineFieldsOfClassDef(classDefinition, pkgEn);
            this.symEnter.defineReferencedFieldsOfClassDef(classDefinition, pkgEn);
        } else if (typeDefNode.getKind() == NodeKind.TYPE_DEFINITION) {
            this.symEnter.defineFields((BLangTypeDefinition)typeDefNode, pkgEn);
            this.symEnter.defineReferencedFieldsOfRecordTypeDef((BLangTypeDefinition)typeDefNode);
        }
        --this.currentDepth;
    }

    public void defineFieldsOfClassDef(BLangClassDefinition classDefinition, SymbolEnv env) {
        SymbolEnv typeDefEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, env);
        BObjectTypeSymbol tSymbol = (BObjectTypeSymbol)classDefinition.symbol;
        BObjectType objType = (BObjectType)tSymbol.type;
        classDefinition.typeDefEnv = typeDefEnv;
        for (BLangSimpleVariable field : classDefinition.fields) {
            this.symEnter.defineNode(field, typeDefEnv);
            if (field.expr != null) {
                field.symbol.isDefaultable = true;
            }
            if (field.symbol.type == this.symTable.semanticError) continue;
            objType.fields.put(field.name.value, new BField(this.names.fromIdNode(field.name), field.pos, field.symbol));
        }
    }

    private void defineRestFields(BLangTypeDefinition typeDef) {
        BStructureType structureType = (BStructureType)typeDef.symbol.type;
        BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)typeDef.typeNode;
        SymbolEnv typeDefEnv = recordTypeNode.typeDefEnv;
        BRecordType recordType = (BRecordType)structureType;
        recordType.sealed = recordTypeNode.sealed;
        if (recordTypeNode.sealed && recordTypeNode.restFieldType != null) {
            this.dlog.error(recordTypeNode.restFieldType.pos, DiagnosticErrorCode.REST_FIELD_NOT_ALLOWED_IN_CLOSED_RECORDS, new Object[0]);
            return;
        }
        if (recordTypeNode.restFieldType != null) {
            recordType.restFieldType = this.symResolver.resolveTypeNode(recordTypeNode.restFieldType, typeDefEnv);
            return;
        }
        if (!recordTypeNode.sealed) {
            recordType.restFieldType = this.symTable.anydataType;
            return;
        }
        recordType.restFieldType = this.symTable.noType;
    }

    public void defineClassDef(BLangClassDefinition classDefinition, SymbolEnv env) {
        EnumSet<Flag> flags = EnumSet.copyOf(classDefinition.flagSet);
        boolean isPublicType = flags.contains((Object)Flag.PUBLIC);
        Name className = this.names.fromIdNode(classDefinition.name);
        Name classOrigName = this.names.originalNameFromIdNode(classDefinition.name);
        BClassSymbol tSymbol = Symbols.createClassSymbol(Flags.asMask(flags), className, env.enclPkg.symbol.pkgID, null, env.scope.owner, classDefinition.name.pos, this.symEnter.getOrigin(className, flags), classDefinition.isServiceDecl);
        tSymbol.originalName = classOrigName;
        tSymbol.scope = new Scope(tSymbol);
        tSymbol.markdownDocumentation = this.symEnter.getMarkdownDocAttachment(classDefinition.markdownDocumentationAttachment);
        long typeFlags = 0L;
        if (flags.contains((Object)Flag.READONLY)) {
            typeFlags |= 0x20L;
        }
        if (flags.contains((Object)Flag.ISOLATED)) {
            typeFlags |= 0x20000000L;
        }
        if (flags.contains((Object)Flag.SERVICE)) {
            typeFlags |= 0x40000L;
        }
        if (flags.contains((Object)Flag.OBJECT_CTOR)) {
            typeFlags |= 0x100000000L;
        }
        BObjectType objectType = new BObjectType(this.symTable.typeEnv(), (BTypeSymbol)tSymbol, typeFlags);
        this.resolvingStructureTypes.add(objectType);
        if (classDefinition.isObjectContructorDecl || flags.contains((Object)Flag.OBJECT_CTOR)) {
            classDefinition.oceEnvData.objectType = objectType;
            objectType.classDef = classDefinition;
        }
        if (flags.contains((Object)Flag.DISTINCT)) {
            objectType.typeIdSet = BTypeIdSet.from(env.enclPkg.symbol.pkgID, classDefinition.name.value, isPublicType);
        }
        if (flags.contains((Object)Flag.CLIENT)) {
            objectType.addFlags(65536L);
        }
        tSymbol.type = objectType;
        classDefinition.setBType(objectType);
        classDefinition.setDeterminedType(objectType);
        classDefinition.symbol = tSymbol;
        if (this.symEnter.isDeprecated(classDefinition.annAttachments)) {
            tSymbol.flags |= 0x10L;
        }
        for (BLangType typeRef : classDefinition.typeRefs) {
            BType referencedType = this.symResolver.resolveTypeNode(typeRef, env);
            objectType.typeInclusions.add(referencedType);
        }
        if (this.symResolver.checkForUniqueSymbol(classDefinition.pos, env, tSymbol)) {
            env.scope.define(tSymbol.name, tSymbol);
        }
    }

    private void updateEffectiveTypeOfCyclicIntersectionTypes(SymbolEnv symEnv) {
        for (BIntersectionType intersectionType : this.intersectionTypeList.keySet()) {
            BLangIntersectionTypeNode intersectionTypeNode = this.intersectionTypeList.get(intersectionType);
            this.effectiveTypePopulator.updateType(intersectionType, this.symTable.builtinPos, symEnv.enclPkg.packageID, intersectionTypeNode, symEnv);
            this.effectiveTypePopulator.visitedImmutableTypes.clear();
        }
    }

    private BType calculateEffectiveType(BLangType typeNode, BLangType bLangTypeOne, BLangType bLangTypeTwo, BType typeOne, BType typeTwo, BType typeOneReference, BType typeTwoReference) {
        if (typeOneReference.tag != 29 || typeTwoReference.tag != 29) {
            this.dlog.error(typeNode.pos, DiagnosticErrorCode.UNSUPPORTED_TYPE_INTERSECTION, new Object[0]);
            return this.symTable.semanticError;
        }
        BType potentialIntersectionType = this.types.getTypeIntersection(Types.IntersectionContext.from(this.dlog, bLangTypeOne.pos, bLangTypeTwo.pos), typeOne, typeTwo, this.pkgEnv);
        if (potentialIntersectionType.tag == 28) {
            this.dlog.error(typeNode.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, typeNode);
            return this.symTable.semanticError;
        }
        return potentialIntersectionType;
    }

    private void handleDistinctDefinitionOfErrorIntersection(BLangTypeDefinition typeDefinition, BSymbol typeDefSymbol, BType definedType) {
        if (definedType.tag == 22 && ((BIntersectionType)definedType).effectiveType.getKind() == TypeKind.ERROR) {
            boolean distinctFlagPresentInTypeDef = typeDefinition.typeNode.flagSet.contains((Object)Flag.DISTINCT);
            BTypeIdSet typeIdSet = BTypeIdSet.emptySet();
            int numberOfDistinctConstituentTypes = 0;
            BLangIntersectionTypeNode intersectionTypeNode = (BLangIntersectionTypeNode)typeDefinition.typeNode;
            for (BLangType constituentType : intersectionTypeNode.constituentTypeNodes) {
                BType type = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(constituentType.getBType()));
                if (type.getKind() != TypeKind.ERROR) continue;
                if (constituentType.flagSet.contains((Object)Flag.DISTINCT)) {
                    ++numberOfDistinctConstituentTypes;
                    typeIdSet.addSecondarySet(((BErrorType)type).typeIdSet.getAll());
                    continue;
                }
                typeIdSet.add(((BErrorType)type).typeIdSet);
            }
            BErrorType effectiveType = (BErrorType)((BIntersectionType)definedType).effectiveType;
            if (numberOfDistinctConstituentTypes == 1 || numberOfDistinctConstituentTypes == 0 && distinctFlagPresentInTypeDef) {
                effectiveType.typeIdSet = BTypeIdSet.from(this.pkgEnv.enclPkg.packageID, typeDefinition.name.value, true, typeIdSet);
            } else {
                for (BLangType constituentType : intersectionTypeNode.constituentTypeNodes) {
                    if (!constituentType.flagSet.contains((Object)Flag.DISTINCT)) continue;
                    typeIdSet.add(BTypeIdSet.from(this.pkgEnv.enclPkg.packageID, this.anonymousModelHelper.getNextAnonymousTypeId(this.pkgEnv.enclPkg.packageID), true));
                }
                effectiveType.typeIdSet = typeIdSet;
            }
            if (((BTypeDefinitionSymbol)typeDefSymbol).referenceType != null) {
                ((BTypeDefinitionSymbol)typeDefSymbol).referenceType.referredType = definedType;
            }
            if (!effectiveType.typeIdSet.isEmpty()) {
                definedType.addFlags(0x8000000L);
            }
        }
    }

    private BType resolveTypeDefinition(SymbolEnv symEnv, Map<String, BLangNode> mod, BLangTypeDefinition defn, int depth) {
        if (defn.getBType() != null) {
            return defn.getBType();
        }
        String currentDefnName = defn.name.value;
        if (depth == defn.cycleDepth) {
            this.logInvalidCyclicReferenceError(currentDefnName, defn.pos);
            return this.symTable.semanticError;
        }
        this.currentDepth = depth;
        defn.cycleDepth = depth;
        boolean hasAlreadyVisited = false;
        if (this.resolvingTypeDefinitions.contains(defn)) {
            boolean logError = true;
            for (int i = this.resolvingTypeDefinitions.size() - 1; i >= 0; --i) {
                BLangTypeDefinition resolvingTypeDefn = this.resolvingTypeDefinitions.get(i);
                resolvingTypeDefn.hasCyclicReference = true;
                BLangType resolvingTypeNode = resolvingTypeDefn.typeNode;
                if (this.isNotRestrictedCyclicTypeNode(resolvingTypeNode)) {
                    logError = false;
                }
                if (logError) {
                    this.logErrorForRestrictedCyclicTypes(resolvingTypeNode, resolvingTypeDefn.name.value);
                }
                if (resolvingTypeDefn == defn) break;
            }
            hasAlreadyVisited = true;
        } else {
            this.resolvingTypeDefinitions.add(defn);
            this.resolvingModuleDefs.push(currentDefnName);
        }
        ResolverData data = new ResolverData();
        data.modTable = mod;
        BType type = this.resolveTypeDesc(symEnv, defn, depth, defn.typeNode, data, false);
        type = this.defineTypeDefinition(defn, type, symEnv);
        this.symEnter.populateDistinctTypeIdsFromIncludedTypeReferences(defn);
        if (!hasAlreadyVisited) {
            this.resolvingTypeDefinitions.remove(defn);
            this.resolvingModuleDefs.pop();
        }
        if (defn.getBType() == null) {
            defn.setBType(type);
            defn.cycleDepth = -1;
        }
        return type;
    }

    private void updateIsCyclicFlag(BType type) {
        switch (type.getKind()) {
            case TUPLE: {
                ((BTupleType)type).isCyclic = true;
                break;
            }
            case UNION: {
                ((BUnionType)type).isCyclic = true;
                break;
            }
            case INTERSECTION: {
                this.updateIsCyclicFlag(((BIntersectionType)type).effectiveType);
            }
        }
    }

    private void logErrorForRestrictedCyclicTypes(BLangType typeNode, String name) {
        switch (typeNode.getKind()) {
            case ARRAY_TYPE: 
            case CONSTRAINED_TYPE: {
                this.dlog.error(typeNode.pos, DiagnosticErrorCode.CYCLIC_TYPE_REFERENCE_NOT_YET_SUPPORTED, name);
                break;
            }
            case INTERSECTION_TYPE_NODE: {
                ((BLangIntersectionTypeNode)typeNode).constituentTypeNodes.forEach(t -> this.logErrorForRestrictedCyclicTypes((BLangType)t, name));
            }
        }
    }

    private boolean isNotRestrictedCyclicTypeNode(BLangType typeNode) {
        return switch (typeNode.getKind()) {
            case NodeKind.ARRAY_TYPE, NodeKind.CONSTRAINED_TYPE, NodeKind.INTERSECTION_TYPE_NODE, NodeKind.USER_DEFINED_TYPE -> false;
            default -> true;
        };
    }

    private void logInvalidCyclicReferenceError(String currentDefnName, Location pos) {
        ArrayList<String> dependencyList = new ArrayList<String>();
        dependencyList.add(currentDefnName);
        for (String resolvingModuleDef : this.resolvingModuleDefs) {
            dependencyList.add(0, resolvingModuleDef);
            if (!resolvingModuleDef.equals(currentDefnName)) continue;
            break;
        }
        this.dlog.error(pos, DiagnosticErrorCode.CYCLIC_TYPE_REFERENCE, dependencyList);
    }

    public boolean isNotUnknownTypeRef(BLangUserDefinedType td) {
        Location pos = td.pos;
        LocationData locationData = new LocationData(td.typeName.value, pos.lineRange().startLine().line(), pos.lineRange().startLine().offset());
        return this.unknownTypeRefs.add(locationData);
    }

    public BType validateModuleLevelDef(String name, Name pkgAlias, Name typeName, BLangUserDefinedType td) {
        BLangNode moduleLevelDef;
        BLangNode bLangNode = moduleLevelDef = pkgAlias == Names.EMPTY ? this.modTable.get(name) : null;
        if (moduleLevelDef == null) {
            if (this.missingNodesHelper.isMissingNode(pkgAlias) || this.missingNodesHelper.isMissingNode(typeName)) {
                return this.symTable.semanticError;
            }
            if (this.isNotUnknownTypeRef(td)) {
                this.dlog.error(td.pos, DiagnosticErrorCode.UNKNOWN_TYPE, name);
            }
            return this.symTable.semanticError;
        }
        if (moduleLevelDef.getKind() == NodeKind.TYPE_DEFINITION) {
            BSymbol symbol;
            BLangTypeDefinition typeDefinition = (BLangTypeDefinition)moduleLevelDef;
            BType resolvedType = this.resolveTypeDefinition(this.pkgEnv, this.modTable, typeDefinition, this.currentDepth);
            if (resolvedType == this.symTable.semanticError || resolvedType == this.symTable.noType) {
                return resolvedType;
            }
            td.symbol = symbol = typeDefinition.symbol;
            if (symbol.kind == SymbolKind.TYPE_DEF && !Symbols.isFlagOn(symbol.flags, 2048L)) {
                BTypeReferenceType referenceType = ((BTypeDefinitionSymbol)symbol).referenceType;
                referenceType.addFlags(symbol.type.getFlags());
                referenceType.tsymbol.flags |= symbol.type.getFlags();
                return referenceType;
            }
            return resolvedType;
        }
        if (moduleLevelDef.getKind() == NodeKind.CONSTANT) {
            BLangConstant constant = (BLangConstant)moduleLevelDef;
            this.resolveConstant(this.pkgEnv, this.modTable, constant);
            return constant.getBType();
        }
        return this.extracted(this.pkgEnv, (BLangClassDefinition)moduleLevelDef, this.currentDepth);
    }

    public void getFieldsOfStructureType(String name, List<BLangSimpleVariable> includedFields) {
        BLangType typeNode;
        BLangNode moduleLevelDef = this.modTable.get(name);
        if (moduleLevelDef != null && moduleLevelDef.getKind() == NodeKind.TYPE_DEFINITION && ((typeNode = ((BLangTypeDefinition)moduleLevelDef).typeNode).getKind() == NodeKind.RECORD_TYPE || typeNode.getKind() == NodeKind.OBJECT_TYPE)) {
            BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeNode;
            includedFields.addAll(structureTypeNode.fields);
            structureTypeNode.typeRefs.forEach(typeRef -> {
                if (typeRef.getKind() == NodeKind.USER_DEFINED_TYPE) {
                    this.getFieldsOfStructureType(((BLangUserDefinedType)typeRef).typeName.value, includedFields);
                }
            });
        }
    }

    public BLangTypeDefinition getTypeDefinition(String name) {
        BLangNode moduleLevelDef = this.modTable.get(name);
        return moduleLevelDef != null && moduleLevelDef.getKind() == NodeKind.TYPE_DEFINITION ? (BLangTypeDefinition)moduleLevelDef : null;
    }

    private BType resolveTypeDesc(SymbolEnv symEnv, BLangTypeDefinition defn, int depth, BLangType td, ResolverData data) {
        return this.resolveTypeDesc(symEnv, defn, depth, td, data, true);
    }

    public void resolveTypeDesc(BLangType td, SymbolEnv symEnv) {
        ResolverData data = new ResolverData();
        data.modTable = new LinkedHashMap<String, BLangNode>();
        data.env = symEnv;
        BType resultType = switch (td.getKind()) {
            case NodeKind.VALUE_TYPE -> this.resolveTypeDesc((BLangValueType)td, symEnv);
            case NodeKind.CONSTRAINED_TYPE -> this.resolveTypeDesc((BLangConstrainedType)td, data);
            case NodeKind.ARRAY_TYPE -> this.resolveTypeDesc((BLangArrayType)td, data);
            case NodeKind.TUPLE_TYPE_NODE -> this.resolveTypeDesc((BLangTupleTypeNode)td, data);
            case NodeKind.RECORD_TYPE -> this.resolveTypeDesc((BLangRecordTypeNode)td, data);
            case NodeKind.OBJECT_TYPE -> this.resolveTypeDesc((BLangObjectTypeNode)td, data);
            case NodeKind.FUNCTION_TYPE -> this.resolveTypeDesc((BLangFunctionTypeNode)td, data);
            case NodeKind.ERROR_TYPE -> this.resolveTypeDesc((BLangErrorType)td, data);
            case NodeKind.UNION_TYPE_NODE -> this.resolveTypeDesc((BLangUnionTypeNode)td, data);
            case NodeKind.INTERSECTION_TYPE_NODE -> this.resolveTypeDesc((BLangIntersectionTypeNode)td, data, true);
            case NodeKind.USER_DEFINED_TYPE -> this.resolveTypeDesc((BLangUserDefinedType)td, data);
            case NodeKind.BUILT_IN_REF_TYPE -> this.resolveTypeDesc((BLangBuiltInRefTypeNode)td, symEnv);
            case NodeKind.FINITE_TYPE_NODE -> this.resolveSingletonType((BLangFiniteTypeNode)td, symEnv);
            case NodeKind.TABLE_TYPE -> this.resolveTypeDesc((BLangTableTypeNode)td, data);
            case NodeKind.STREAM_TYPE -> this.resolveTypeDesc((BLangStreamType)td, data);
            default -> throw new AssertionError((Object)"Invalid type");
        };
        td.setBType(resultType);
    }

    private BType resolveTypeDesc(SymbolEnv symEnv, BLangTypeDefinition defn, int depth, BLangType td, ResolverData data, boolean anonymous) {
        SymbolEnv prevEnv = data.env;
        BLangTypeDefinition prevDefn = data.typeDefinition;
        int prevDepth = data.depth;
        data.env = symEnv;
        data.typeDefinition = defn;
        data.depth = depth;
        BType resultType = switch (td.getKind()) {
            case NodeKind.VALUE_TYPE -> this.resolveTypeDesc((BLangValueType)td, symEnv);
            case NodeKind.CONSTRAINED_TYPE -> this.resolveTypeDesc((BLangConstrainedType)td, data);
            case NodeKind.ARRAY_TYPE -> this.resolveTypeDesc((BLangArrayType)td, data);
            case NodeKind.TUPLE_TYPE_NODE -> this.resolveTypeDesc((BLangTupleTypeNode)td, data);
            case NodeKind.RECORD_TYPE -> this.resolveTypeDesc((BLangRecordTypeNode)td, data);
            case NodeKind.OBJECT_TYPE -> this.resolveTypeDesc((BLangObjectTypeNode)td, data);
            case NodeKind.FUNCTION_TYPE -> this.resolveTypeDesc((BLangFunctionTypeNode)td, data);
            case NodeKind.ERROR_TYPE -> this.resolveTypeDesc((BLangErrorType)td, data);
            case NodeKind.UNION_TYPE_NODE -> this.resolveTypeDesc((BLangUnionTypeNode)td, data);
            case NodeKind.INTERSECTION_TYPE_NODE -> this.resolveTypeDesc((BLangIntersectionTypeNode)td, data, anonymous);
            case NodeKind.USER_DEFINED_TYPE -> this.resolveTypeDesc((BLangUserDefinedType)td, data);
            case NodeKind.BUILT_IN_REF_TYPE -> this.resolveTypeDesc((BLangBuiltInRefTypeNode)td, symEnv);
            case NodeKind.FINITE_TYPE_NODE -> this.resolveSingletonType((BLangFiniteTypeNode)td, symEnv);
            case NodeKind.TABLE_TYPE -> this.resolveTypeDesc((BLangTableTypeNode)td, data);
            case NodeKind.STREAM_TYPE -> this.resolveTypeDesc((BLangStreamType)td, data);
            default -> throw new AssertionError((Object)"Invalid type");
        };
        BType refType = Types.getImpliedType(resultType);
        if (refType != this.symTable.noType && td.nullable && resultType.tag == 21) {
            BUnionType unionType = (BUnionType)refType;
            unionType.add(this.symTable.nilType);
        }
        this.symResolver.validateDistinctType(td, resultType);
        if (td.getBType() == null) {
            td.setBType(resultType);
        }
        data.env = prevEnv;
        data.typeDefinition = prevDefn;
        data.depth = prevDepth;
        return resultType;
    }

    private BType resolveTypeDesc(BLangValueType td, SymbolEnv symEnv) {
        SymbolResolver.AnalyzerData data = new SymbolResolver.AnalyzerData(symEnv);
        return this.visitBuiltInTypeNode(td, data, td.typeKind);
    }

    private BType resolveTypeDesc(BLangConstrainedType td, ResolverData data) {
        this.currentDepth = data.depth;
        TypeKind typeKind = ((BLangBuiltInRefTypeNode)td.getType()).getTypeKind();
        return switch (typeKind) {
            case TypeKind.MAP -> this.resolveMapTypeDesc(td, data);
            case TypeKind.XML -> this.resolveXmlTypeDesc(td, data);
            case TypeKind.FUTURE -> this.resolveFutureTypeDesc(td, data);
            case TypeKind.TYPEDESC -> this.resolveTypedescTypeDesc(td, data);
            default -> throw new IllegalStateException("unknown constrained type found: " + String.valueOf((Object)typeKind));
        };
    }

    private BType resolveTypedescTypeDesc(BLangConstrainedType td, ResolverData data) {
        BType constraintType;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BType type = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.type, data);
        BTypedescType constrainedType = new BTypedescType(this.symTable.typeEnv(), this.symTable.empty, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        constrainedType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.originalName, symEnv.enclPkg.symbol.pkgID, constrainedType, typeSymbol.owner, td.pos, SymbolOrigin.BUILTIN);
        td.setBType(constrainedType);
        constrainedType.constraint = constraintType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.constraint, data);
        this.symResolver.markParameterizedType((BType)constrainedType, constraintType);
        return constrainedType;
    }

    private BType resolveFutureTypeDesc(BLangConstrainedType td, ResolverData data) {
        BType constraintType;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BType type = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.type, data);
        BFutureType constrainedType = new BFutureType(this.symTable.typeEnv(), this.symTable.empty, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        constrainedType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.originalName, symEnv.enclPkg.symbol.pkgID, constrainedType, typeSymbol.owner, td.pos, SymbolOrigin.BUILTIN);
        td.setBType(constrainedType);
        constrainedType.constraint = constraintType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.constraint, data);
        this.symResolver.markParameterizedType((BType)constrainedType, constraintType);
        return constrainedType;
    }

    private BType resolveXmlTypeDesc(BLangConstrainedType td, ResolverData data) {
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BType type = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.type, data);
        BXMLType constrainedType = new BXMLType(this.symTable.empty, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        constrainedType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.originalName, symEnv.enclPkg.symbol.pkgID, constrainedType, typeSymbol.owner, td.pos, SymbolOrigin.BUILTIN);
        td.setBType(constrainedType);
        this.resolvingTypes.push(constrainedType);
        BType constraintType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.constraint, data);
        if (constraintType.tag == 52) {
            BType typedescType = ((BParameterizedType)constraintType).paramSymbol.type;
            BType typedescConstraint = ((BTypedescType)typedescType).constraint;
            this.symResolver.validateXMLConstraintType(typedescConstraint, td.pos);
        } else {
            this.symResolver.validateXMLConstraintType(constraintType, td.pos);
        }
        constrainedType.constraint = constraintType;
        this.symResolver.markParameterizedType((BType)constrainedType, constraintType);
        this.resolvingTypes.pop();
        return constrainedType;
    }

    private BType resolveMapTypeDesc(BLangConstrainedType td, ResolverData data) {
        BType constraintType;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BType type = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.type, data);
        BTypeSymbol typeSymbol = type.tsymbol;
        BTypeSymbol tSymbol = Symbols.createTypeSymbol(12L, typeSymbol.flags, Names.EMPTY, typeSymbol.originalName, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        BMapType constrainedType = new BMapType(this.symTable.typeEnv(), 16, this.symTable.empty, tSymbol);
        td.setBType(constrainedType);
        tSymbol.type = type;
        this.resolvingTypes.push(constrainedType);
        constrainedType.constraint = constraintType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.constraint, data);
        this.symResolver.markParameterizedType((BType)constrainedType, constraintType);
        this.resolvingTypes.pop();
        return constrainedType;
    }

    private BType resolveTypeDesc(BLangArrayType td, ResolverData data) {
        this.currentDepth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        BType resultType = this.symTable.empty;
        boolean isError = false;
        BArrayType firstDimArrType = null;
        boolean firstDim = true;
        SymbolEnv symEnv = data.env;
        for (int i = 0; i < td.dimensions; ++i) {
            BArrayType arrType;
            BTypeSymbol arrayTypeSymbol = Symbols.createTypeSymbol(8421404L, 1L, Names.EMPTY, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
            if (td.sizes.isEmpty()) {
                arrType = new BArrayType(this.symTable.typeEnv(), resultType, arrayTypeSymbol);
            } else {
                BLangExpression size = td.sizes.get(i);
                if (size.getKind() == NodeKind.LITERAL || size.getKind() == NodeKind.NUMERIC_LITERAL) {
                    Integer sizeIndicator = (Integer)((BLangLiteral)size).getValue();
                    BArrayState arrayState = sizeIndicator == -1 ? BArrayState.OPEN : (sizeIndicator == -2 ? BArrayState.INFERRED : BArrayState.CLOSED);
                    arrType = new BArrayType(this.symTable.typeEnv(), resultType, arrayTypeSymbol, sizeIndicator, arrayState);
                } else {
                    int length;
                    BSymbol sizeSymbol;
                    if (size.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, ((BLangTypedescExpr)size).getTypeNode());
                        isError = true;
                        continue;
                    }
                    BLangSimpleVarRef sizeReference = (BLangSimpleVarRef)size;
                    Name pkgAlias = this.names.fromIdNode(sizeReference.pkgAlias);
                    Name typeName = this.names.fromIdNode(sizeReference.variableName);
                    sizeReference.symbol = sizeSymbol = this.symResolver.lookupMainSpaceSymbolInPackage(size.pos, symEnv, pkgAlias, typeName);
                    if (this.symTable.notFoundSymbol == sizeSymbol) {
                        this.dlog.error(td.pos, DiagnosticErrorCode.UNDEFINED_SYMBOL, size);
                        isError = true;
                        continue;
                    }
                    if (sizeSymbol.tag != 0x100001CL) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INVALID_ARRAY_SIZE_REFERENCE, sizeSymbol);
                        isError = true;
                        continue;
                    }
                    BConstantSymbol sizeConstSymbol = (BConstantSymbol)sizeSymbol;
                    BType lengthLiteralType = sizeConstSymbol.literalType;
                    if (lengthLiteralType.tag != 1) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, sizeConstSymbol.literalType);
                        isError = true;
                        continue;
                    }
                    long lengthCheck = Long.parseLong(sizeConstSymbol.type.toString());
                    if (lengthCheck > 0x7FFFFFF5L) {
                        length = 0;
                        this.dlog.error(size.pos, DiagnosticErrorCode.ARRAY_LENGTH_GREATER_THAT_2147483637_NOT_YET_SUPPORTED, new Object[0]);
                    } else if (lengthCheck < 0L) {
                        length = 0;
                        this.dlog.error(size.pos, DiagnosticErrorCode.INVALID_ARRAY_LENGTH, new Object[0]);
                    } else {
                        length = (int)lengthCheck;
                    }
                    arrType = new BArrayType(this.symTable.typeEnv(), resultType, arrayTypeSymbol, length, BArrayState.CLOSED);
                }
            }
            resultType = arrayTypeSymbol.type = arrType;
            if (firstDim) {
                firstDimArrType = arrType;
                firstDim = false;
                continue;
            }
            this.symResolver.markParameterizedType((BType)arrType, arrType.eType);
        }
        td.setBType(resultType);
        this.resolvingTypes.push(resultType);
        if (isError) {
            return this.symTable.semanticError;
        }
        firstDimArrType.eType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.elemtype, data);
        this.symResolver.markParameterizedType(firstDimArrType, firstDimArrType.eType);
        this.resolvingTypes.pop();
        return resultType;
    }

    private BType resolveTypeDesc(BLangTupleTypeNode td, ResolverData data) {
        this.currentDepth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4227100L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        ArrayList<BTupleMember> memberTypes = new ArrayList<BTupleMember>();
        BTupleType tupleType = new BTupleType(this.symTable.typeEnv(), tupleTypeSymbol, memberTypes);
        tupleTypeSymbol.type = tupleType;
        td.setBType(tupleType);
        this.resolvingTypes.push(tupleType);
        for (BLangSimpleVariable memberNode : td.getMemberNodes()) {
            BType type = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, memberNode.typeNode, data);
            SymbolEnv tupleEnv = SymbolEnv.createTypeEnv(td, new Scope(tupleTypeSymbol), symEnv);
            this.symEnter.defineNode(memberNode, tupleEnv);
            BVarSymbol varSymbol = new BVarSymbol(memberNode.getBType().getFlags(), memberNode.symbol.name, memberNode.symbol.pkgID, memberNode.getBType(), memberNode.symbol.owner, memberNode.pos, SymbolOrigin.SOURCE);
            memberTypes.add(new BTupleMember(type, varSymbol));
        }
        if (td.restParamType != null) {
            BType tupleRestType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.restParamType, data);
            if (tupleRestType.tag == 28) {
                return this.symTable.semanticError;
            }
            tupleType.restType = tupleRestType;
            this.symResolver.markParameterizedType((BType)tupleType, tupleType.restType);
        }
        this.symResolver.markParameterizedType((BType)tupleType, tupleType.getTupleTypes());
        this.resolvingTypes.pop();
        return tupleType;
    }

    private BType resolveTypeDesc(BLangRecordTypeNode td, ResolverData data) {
        int depth;
        this.currentDepth = depth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BLangTypeDefinition typeDefinition = data.typeDefinition;
        EnumSet<Flag> flags = td.isAnonymous ? EnumSet.of(Flag.PUBLIC, Flag.ANONYMOUS) : EnumSet.noneOf(Flag.class);
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(flags), Names.EMPTY, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, td.isAnonymous ? SymbolOrigin.VIRTUAL : SymbolOrigin.BUILTIN);
        BRecordType recordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
        this.resolvingStructureTypes.add(recordType);
        recordSymbol.type = recordType;
        td.symbol = recordSymbol;
        td.setBType(recordType);
        this.resolvingTypes.push(recordType);
        if (symEnv.node.getKind() != NodeKind.PACKAGE) {
            recordSymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(symEnv.enclPkg.packageID));
            this.symEnter.defineSymbol(td.pos, td.symbol, symEnv);
            this.symEnter.defineNode(td, symEnv);
        }
        if (td.getRestFieldType() != null) {
            this.resolveTypeDesc(symEnv, typeDefinition, depth + 1, td.restFieldType, data);
            this.currentDepth = depth;
        }
        boolean errored = false;
        for (BLangType bLangRefType : td.typeRefs) {
            BType refType = this.resolveTypeDesc(symEnv, typeDefinition, depth, bLangRefType, data);
            this.currentDepth = depth;
            if (refType != this.symTable.semanticError) continue;
            errored = true;
        }
        this.defineTypeDefinition(typeDefinition, recordType, symEnv);
        this.symEnter.populateDistinctTypeIdsFromIncludedTypeReferences(typeDefinition);
        this.currentDepth = depth;
        if (errored) {
            typeDefinition.referencedFieldsDefined = true;
            this.defineRestFields(typeDefinition);
        }
        this.defineFields(typeDefinition, symEnv);
        this.resolvingStructureTypes.remove(recordType);
        this.resolvingTypes.pop();
        return recordType;
    }

    private BType resolveTypeDesc(BLangObjectTypeNode td, ResolverData data) {
        this.currentDepth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        EnumSet<Flag> flags = EnumSet.copyOf(td.flagSet);
        if (td.isAnonymous) {
            flags.add(Flag.PUBLIC);
        }
        int typeFlags = 0;
        if (flags.contains((Object)Flag.ISOLATED)) {
            typeFlags = (int)((long)typeFlags | 0x20000000L);
        }
        if (flags.contains((Object)Flag.SERVICE)) {
            typeFlags = (int)((long)typeFlags | 0x40000L);
        }
        SymbolEnv symEnv = data.env;
        BLangTypeDefinition typeDefinition = data.typeDefinition;
        BObjectTypeSymbol objectSymbol = Symbols.createObjectSymbol(Flags.asMask(flags), Names.EMPTY, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        BObjectType objectType = new BObjectType(this.symTable.typeEnv(), (BTypeSymbol)objectSymbol, (long)typeFlags);
        this.resolvingStructureTypes.add(objectType);
        objectSymbol.type = objectType;
        td.symbol = objectSymbol;
        td.setBType(objectType);
        this.resolvingTypes.push(objectType);
        boolean errored = false;
        for (BLangType bLangRefType : td.typeRefs) {
            BType refType = this.resolveTypeDesc(symEnv, typeDefinition, data.depth, bLangRefType, data);
            if (refType != this.symTable.semanticError) continue;
            errored = true;
        }
        if (errored) {
            typeDefinition.referencedFieldsDefined = true;
        }
        this.symResolver.validateDistinctType(td, objectType);
        this.defineTypeDefinition(typeDefinition, objectType, symEnv);
        this.symEnter.defineDistinctClassAndObjectDefinitionIndividual(typeDefinition);
        this.defineFields(typeDefinition, symEnv);
        this.resolvingStructureTypes.remove(objectType);
        this.resolvingTypes.pop();
        return objectType;
    }

    private BType resolveTypeDesc(BLangFunctionTypeNode td, ResolverData data) {
        this.currentDepth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        Location pos = td.pos;
        BInvokableType bInvokableType = new BInvokableType(this.symTable.typeEnv(), List.of(), null, null, null);
        BInvokableTypeSymbol tsymbol = Symbols.createInvokableTypeSymbol(33587228L, Flags.asMask(td.flagSet), symEnv.enclPkg.symbol.pkgID, bInvokableType, symEnv.scope.owner, pos, SymbolOrigin.BUILTIN);
        tsymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(symEnv.enclPkg.packageID));
        this.symEnter.defineSymbol(pos, tsymbol, symEnv);
        bInvokableType.tsymbol = tsymbol;
        td.setBType(bInvokableType);
        this.resolvingTypes.push(bInvokableType);
        List<BLangSimpleVariable> params = td.getParams();
        BLangType returnTypeNode = td.returnTypeNode;
        BType invokableType = this.createInvokableType(params, td.restParam, returnTypeNode, Flags.asMask(td.flagSet), symEnv, data.modTable, data.depth, data.typeDefinition, bInvokableType, data);
        this.resolvingTypes.pop();
        return this.symResolver.validateInferTypedescParams(pos, params, returnTypeNode == null ? null : returnTypeNode.getBType()) ? invokableType : this.symTable.semanticError;
    }

    /*
     * WARNING - void declaration
     */
    public BType createInvokableType(List<? extends BLangVariable> paramVars, BLangVariable restVariable, BLangType retTypeVar, long flags, SymbolEnv env, Map<String, BLangNode> mod, int depth, BLangTypeDefinition typeDefinition, BInvokableType bInvokableType, ResolverData data) {
        void var18_20;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>();
        boolean foundDefaultableParam = false;
        ArrayList<String> paramNames = new ArrayList<String>();
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)bInvokableType.tsymbol;
        if (Symbols.isFlagOn(flags, 0x8000000000L)) {
            bInvokableType.setFlags(flags);
            tsymbol.params = null;
            tsymbol.restParam = null;
            tsymbol.returnType = null;
            return bInvokableType;
        }
        for (BLangVariable bLangVariable : paramVars) {
            BVarSymbol symbol;
            BLangSimpleVariable param2 = (BLangSimpleVariable)bLangVariable;
            Name paramName = this.names.fromIdNode(param2.name);
            Name paramOrigName = this.names.originalNameFromIdNode(param2.name);
            if (paramName != Names.EMPTY) {
                if (paramNames.contains(paramName.value)) {
                    this.dlog.error(param2.name.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, paramName.value);
                } else {
                    paramNames.add(paramName.value);
                }
            }
            BType type = this.resolveTypeDesc(env, typeDefinition, depth + 1, param2.getTypeNode(), data);
            bLangVariable.setBType(type);
            paramTypes.add(type);
            long paramFlags = Flags.asMask(bLangVariable.flagSet);
            param2.symbol = symbol = new BVarSymbol(paramFlags, paramName, paramOrigName, env.enclPkg.symbol.pkgID, type, env.scope.owner, param2.pos, SymbolOrigin.BUILTIN);
            if (param2.expr != null) {
                foundDefaultableParam = true;
                symbol.isDefaultable = true;
                symbol.flags |= 0x1000L;
            } else if (foundDefaultableParam) {
                this.dlog.error(param2.pos, DiagnosticErrorCode.REQUIRED_PARAM_DEFINED_AFTER_DEFAULTABLE_PARAM, new Object[0]);
            }
            params.add(symbol);
        }
        BType retType = this.resolveTypeDesc(env, typeDefinition, depth + 1, retTypeVar, data);
        Object var18_18 = null;
        BType restType = null;
        if (restVariable != null) {
            BVarSymbol bVarSymbol;
            restType = this.resolveTypeDesc(env, typeDefinition, depth + 1, restVariable.typeNode, data);
            BLangIdentifier id = ((BLangSimpleVariable)restVariable).name;
            restVariable.setBType(restType);
            restVariable.symbol = bVarSymbol = new BVarSymbol(Flags.asMask(restVariable.flagSet), this.names.fromIdNode(id), this.names.originalNameFromIdNode(id), env.enclPkg.symbol.pkgID, restType, env.scope.owner, restVariable.pos, SymbolOrigin.BUILTIN);
        }
        bInvokableType.paramTypes = paramTypes;
        bInvokableType.restType = restType;
        bInvokableType.retType = retType;
        bInvokableType.addFlags(flags);
        tsymbol.params = params;
        tsymbol.restParam = var18_20;
        tsymbol.returnType = retType;
        params.forEach(param -> tsymbol.scope.define(param.name, (BSymbol)param));
        ArrayList<BType> allConstituentTypes = new ArrayList<BType>(paramTypes);
        allConstituentTypes.add(restType);
        allConstituentTypes.add(retType);
        this.symResolver.markParameterizedType((BType)bInvokableType, allConstituentTypes);
        return bInvokableType;
    }

    private BType resolveTypeDesc(BLangErrorType td, ResolverData data) {
        this.currentDepth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        if (td.detailType == null) {
            BErrorType errorType = new BErrorType(this.symTable.typeEnv(), null, this.symTable.detailType);
            errorType.tsymbol = new BErrorTypeSymbol(294940L, 1L, Names.ERROR, this.symTable.rootPkgSymbol.pkgID, errorType, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.BUILTIN);
            return errorType;
        }
        BErrorTypeSymbol errorTypeSymbol = Symbols.createErrorSymbol(Flags.asMask(td.flagSet), Names.EMPTY, data.env.enclPkg.packageID, null, data.env.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        BErrorType errorType = new BErrorType(this.symTable.typeEnv(), (BTypeSymbol)errorTypeSymbol, this.symTable.empty);
        td.setBType(errorType);
        this.resolvingTypes.push(errorType);
        BType detailType = Optional.ofNullable(td.detailType).map(bLangType -> this.resolveTypeDesc(data.env, data.typeDefinition, data.depth, (BLangType)bLangType, data)).orElse(this.symTable.detailType);
        if (td.isAnonymous) {
            td.flagSet.add(Flag.PUBLIC);
            td.flagSet.add(Flag.ANONYMOUS);
        }
        BErrorType bErrorType = this.symTable.errorType;
        boolean distinctErrorDef = td.flagSet.contains((Object)Flag.DISTINCT);
        if (detailType == this.symTable.detailType && !distinctErrorDef && !data.env.enclPkg.packageID.equals(PackageID.ANNOTATIONS)) {
            return bErrorType;
        }
        errorType.detailType = detailType;
        PackageID packageID = data.env.enclPkg.packageID;
        if (data.env.node.getKind() != NodeKind.PACKAGE) {
            errorTypeSymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(packageID));
            this.symEnter.defineSymbol(td.pos, errorTypeSymbol, data.env);
        }
        errorType.addFlags(errorTypeSymbol.flags);
        errorTypeSymbol.type = errorType;
        this.symResolver.markParameterizedType((BType)errorType, detailType);
        errorType.typeIdSet = BTypeIdSet.emptySet();
        if (td.isAnonymous && td.flagSet.contains((Object)Flag.DISTINCT)) {
            errorType.typeIdSet.add(BTypeIdSet.from(packageID, this.anonymousModelHelper.getNextAnonymousTypeId(packageID), true));
        }
        this.resolvingTypes.pop();
        return errorType;
    }

    private BType resolveTypeDesc(BLangUnionTypeNode td, ResolverData data) {
        this.currentDepth = data.depth;
        SymbolEnv symEnv = data.env;
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        BTypeSymbol unionTypeSymbol = Symbols.createTypeSymbol(1081372L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        BUnionType unionType = new BUnionType(this.types.typeEnv(), unionTypeSymbol, memberTypes, false);
        unionTypeSymbol.type = unionType;
        td.setBType(unionType);
        this.resolvingTypes.push(unionType);
        for (BLangType langType : td.memberTypeNodes) {
            BType resolvedType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth, langType, data);
            if (resolvedType == this.symTable.semanticError) {
                memberTypes.add(this.symTable.semanticError);
                continue;
            }
            memberTypes.add(resolvedType);
        }
        this.updateReadOnlyFlag(unionType);
        this.symResolver.markParameterizedType((BType)unionType, memberTypes);
        this.resolvingTypes.pop();
        return unionType;
    }

    private void updateReadOnlyFlag(BUnionType type) {
        Set memberTypes = type.getMemberTypes();
        LinkedHashSet<BType> flattenMemberTypes = new LinkedHashSet<BType>(((HashSet)memberTypes).size());
        boolean isImmutable = true;
        for (BType memBType : BUnionType.toFlatTypeSet((LinkedHashSet<BType>)memberTypes)) {
            if (Types.getImpliedType((BType)memBType).tag != 50) {
                flattenMemberTypes.add(memBType);
            }
            if (!isImmutable || Symbols.isFlagOn(memBType.getFlags(), 32L)) continue;
            isImmutable = false;
        }
        if (isImmutable) {
            type.addFlags(32L);
            if (type.tsymbol != null) {
                type.tsymbol.flags |= 0x20L;
            }
        }
        type.setOriginalMemberTypes((LinkedHashSet<BType>)memberTypes);
        ((HashSet)memberTypes).clear();
        ((AbstractCollection)((Object)memberTypes)).addAll(flattenMemberTypes);
    }

    private BType resolveTypeDesc(BLangIntersectionTypeNode td, ResolverData data, boolean anonymous) {
        this.currentDepth = data.depth;
        List<BLangType> constituentTypeNodes = td.constituentTypeNodes;
        LinkedHashSet<BType> constituentTypes = new LinkedHashSet<BType>();
        SymbolEnv symEnv = data.env;
        boolean errored = false;
        boolean hasReadonly = false;
        int numOfNonReadOnlyConstituents = 0;
        BLangTypeDefinition typeDefinition = data.typeDefinition;
        for (BLangType typeNode : constituentTypeNodes) {
            BType constituentType = this.resolveTypeDesc(symEnv, typeDefinition, data.depth, typeNode, data);
            if (constituentType == this.symTable.semanticError) {
                errored = true;
                continue;
            }
            if (constituentType.tag == 38) {
                hasReadonly = true;
            } else {
                ++numOfNonReadOnlyConstituents;
            }
            constituentTypes.add(constituentType);
        }
        if (errored) {
            return this.symTable.semanticError;
        }
        Name name = anonymous ? Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(data.env.enclPkg.packageID)) : Names.fromString(typeDefinition.name.value);
        BTypeSymbol intersectionSymbol = Symbols.createTypeSymbol(8421404L, 1L, name, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        BIntersectionType intersectionType = new BIntersectionType(intersectionSymbol);
        intersectionSymbol.type = intersectionType;
        intersectionType.setConstituentTypes(constituentTypes);
        if (hasReadonly) {
            intersectionType.addFlags(32L);
        }
        if (numOfNonReadOnlyConstituents > 1) {
            for (BType constituentType : constituentTypes) {
                if (constituentType.tag == 38 || !this.resolvingTypes.contains(Types.getImpliedType(constituentType))) continue;
                this.dlog.error(td.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, td);
                return this.symTable.semanticError;
            }
        }
        this.fillEffectiveType(intersectionType, td, symEnv);
        return intersectionType;
    }

    private void fillEffectiveType(BIntersectionType intersectionType, BLangIntersectionTypeNode td, SymbolEnv env) {
        List<BLangType> constituentTypeNodes = td.constituentTypeNodes;
        Iterator<BLangType> bLangTypeItr = constituentTypeNodes.iterator();
        Iterator<BType> iterator = intersectionType.getConstituentTypes().iterator();
        BType effectiveType = iterator.next();
        BLangType bLangEffectiveType = bLangTypeItr.next();
        while (iterator.hasNext()) {
            BType bLangEffectiveImpliedType = Types.getImpliedType(effectiveType);
            if (bLangEffectiveImpliedType.tag == 38) {
                intersectionType.addFlags(38L);
                effectiveType = iterator.next();
                bLangEffectiveType = bLangTypeItr.next();
                continue;
            }
            BType type = iterator.next();
            BLangType bLangType = bLangTypeItr.next();
            BType typeReferenceType = Types.getImpliedType(type);
            if (typeReferenceType.tag == 38) {
                intersectionType.addFlags(38L);
                continue;
            }
            effectiveType = this.calculateEffectiveType(td, bLangEffectiveType, bLangType, effectiveType, type, bLangEffectiveImpliedType, typeReferenceType);
            if (effectiveType.tag != 28) continue;
            intersectionType.effectiveType = this.symTable.semanticError;
            return;
        }
        intersectionType.effectiveType = effectiveType;
        intersectionType.addFlags(effectiveType.getFlags());
        if ((intersectionType.getFlags() & 0x20L) == 32L) {
            if (this.types.isInherentlyImmutableType(effectiveType)) {
                return;
            }
            if (!this.resolvingTypes.isEmpty()) {
                this.intersectionTypeList.put(intersectionType, td);
            }
            if (!(Types.getImpliedType(effectiveType) instanceof SelectivelyImmutableReferenceType)) {
                intersectionType.effectiveType = this.symTable.semanticError;
                return;
            }
            BIntersectionType immutableIntersectionType = ImmutableTypeCloner.getImmutableIntersectionType(intersectionType.tsymbol.pos, this.types, intersectionType.effectiveType, env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>());
            intersectionType.effectiveType = immutableIntersectionType.effectiveType;
        }
    }

    private BType resolveTypeDesc(BLangUserDefinedType td, ResolverData data) {
        BLangNode moduleLevelDef;
        this.currentDepth = data.depth;
        String name = td.typeName.value;
        SymbolEnv symEnv = data.env;
        SymbolResolver.AnalyzerData analyzerData = new SymbolResolver.AnalyzerData(symEnv);
        Name pkgAlias = this.names.fromIdNode(td.pkgAlias);
        Name typeName = this.names.fromIdNode(td.typeName);
        BSymbol symbol = this.symTable.notFoundSymbol;
        if (symEnv.scope.owner.tag == 2L) {
            symbol = this.symResolver.lookupAnnotationSpaceSymbolInPackage(td.pos, symEnv, pkgAlias, typeName);
        }
        if (symbol == this.symTable.notFoundSymbol) {
            BSymbol refSymbol;
            BSymbol tempSymbol = this.symResolver.lookupMainSpaceSymbolInPackage(td.pos, symEnv, pkgAlias, typeName);
            BSymbol bSymbol = refSymbol = tempSymbol.tag == 32796L ? Types.getImpliedType((BType)tempSymbol.type).tsymbol : tempSymbol;
            if (refSymbol == null) {
                refSymbol = tempSymbol;
            }
            if ((refSymbol.tag & 0xCL) == 12L) {
                symbol = tempSymbol;
            } else if (Symbols.isTagOn(refSymbol, 52L) && symEnv.node.getKind() == NodeKind.FUNCTION) {
                BType paramValType;
                BLangFunction func = (BLangFunction)symEnv.node;
                boolean errored = false;
                if (func.returnTypeNode == null || func.hasBody() && func.body.getKind() != NodeKind.EXTERN_FUNCTION_BODY) {
                    this.dlog.error(td.pos, DiagnosticErrorCode.INVALID_NON_EXTERNAL_DEPENDENTLY_TYPED_FUNCTION, new Object[0]);
                    errored = true;
                }
                if (tempSymbol.type != null && Types.getImpliedType((BType)tempSymbol.type).tag != 13) {
                    this.dlog.error(td.pos, DiagnosticErrorCode.INVALID_PARAM_TYPE_FOR_RETURN_TYPE, tempSymbol.type);
                    errored = true;
                }
                if (errored) {
                    return this.symTable.semanticError;
                }
                SymbolResolver.ParameterizedTypeInfo parameterizedTypeInfo = this.symResolver.getTypedescParamValueType(func.requiredParams, analyzerData, refSymbol);
                BType bType = paramValType = parameterizedTypeInfo == null ? null : parameterizedTypeInfo.paramValueType;
                if (paramValType == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
                if (paramValType != null) {
                    BTypeSymbol tSymbol = new BTypeSymbol(12L, 0x4000000L | tempSymbol.flags, tempSymbol.name, tempSymbol.originalName, tempSymbol.pkgID, null, func.symbol, tempSymbol.pos, SymbolOrigin.VIRTUAL);
                    tSymbol.type = new BParameterizedType(paramValType, (BVarSymbol)tempSymbol, tSymbol, tempSymbol.name, parameterizedTypeInfo.index);
                    tSymbol.type.addFlags(0x4000000L);
                    td.symbol = tSymbol;
                    return tSymbol.type;
                }
            }
        }
        if (symbol == this.symTable.notFoundSymbol) {
            symbol = this.symResolver.lookupMemberSymbol(td.pos, this.symTable.rootScope, symEnv, typeName, 20L);
        }
        if (symEnv.logErrors && symbol == this.symTable.notFoundSymbol) {
            if (!(this.missingNodesHelper.isMissingNode(pkgAlias) || this.missingNodesHelper.isMissingNode(typeName) || this.symEnter.isUnknownTypeRef(td))) {
                this.dlog.error(td.pos, analyzerData.diagCode, typeName);
            }
            return this.symTable.semanticError;
        }
        td.symbol = symbol;
        if (symbol.kind == SymbolKind.TYPE_DEF && !Symbols.isFlagOn(symbol.flags, 2048L)) {
            BTypeReferenceType referenceType = ((BTypeDefinitionSymbol)symbol).referenceType;
            referenceType.addFlags(symbol.type.getFlags());
            referenceType.tsymbol.flags |= symbol.type.getFlags();
            return referenceType;
        }
        BType type = symbol.type;
        if (symbol != this.symTable.notFoundSymbol) {
            return type;
        }
        BLangNode bLangNode = moduleLevelDef = pkgAlias == Names.EMPTY ? data.modTable.get(name) : null;
        if (moduleLevelDef == null) {
            if (this.missingNodesHelper.isMissingNode(pkgAlias) || this.missingNodesHelper.isMissingNode(typeName)) {
                return this.symTable.semanticError;
            }
            LocationData locationData = new LocationData(name, td.pos.lineRange().startLine().line(), td.pos.lineRange().startLine().offset());
            if (this.unknownTypeRefs.add(locationData)) {
                this.dlog.error(td.pos, DiagnosticErrorCode.UNKNOWN_TYPE, td.typeName);
            }
            return this.symTable.semanticError;
        }
        if (moduleLevelDef.getKind() == NodeKind.TYPE_DEFINITION) {
            BLangTypeDefinition typeDefinition = (BLangTypeDefinition)moduleLevelDef;
            BType resolvedType = this.resolveTypeDefinition(symEnv, data.modTable, typeDefinition, data.depth);
            if (resolvedType == this.symTable.semanticError || resolvedType == this.symTable.noType) {
                return resolvedType;
            }
            td.symbol = symbol = typeDefinition.symbol;
            if (symbol.kind == SymbolKind.TYPE_DEF && !Symbols.isFlagOn(symbol.flags, 2048L)) {
                BTypeReferenceType referenceType = ((BTypeDefinitionSymbol)symbol).referenceType;
                referenceType.addFlags(symbol.type.getFlags());
                referenceType.tsymbol.flags |= symbol.type.getFlags();
                return referenceType;
            }
            return resolvedType;
        }
        if (moduleLevelDef.getKind() == NodeKind.CONSTANT) {
            BLangConstant constant = (BLangConstant)moduleLevelDef;
            this.resolveConstant(symEnv, data.modTable, constant);
            return constant.getBType();
        }
        return this.extracted(symEnv, (BLangClassDefinition)moduleLevelDef, data.depth);
    }

    private BType resolveTypeDesc(BLangBuiltInRefTypeNode td, SymbolEnv symEnv) {
        SymbolResolver.AnalyzerData data = new SymbolResolver.AnalyzerData(symEnv);
        return this.visitBuiltInTypeNode(td, data, td.typeKind);
    }

    protected BType resolveSingletonType(BLangFiniteTypeNode td, SymbolEnv symEnv) {
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(557084L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, symEnv.enclPkg.symbol.pkgID, null, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        List<BLangExpression> vs = td.valueSpace;
        SemNamedType[] valueSpace = new SemNamedType[vs.size()];
        for (int i = 0; i < vs.size(); ++i) {
            BLangExpression exprOrLiteral = vs.get(i);
            BType type = this.blangTypeUpdate(exprOrLiteral);
            if (type != null && type.tag == 28) {
                return type;
            }
            if (type != null) {
                exprOrLiteral.setBType(this.symTable.getTypeFromTag(type.tag));
            }
            if (SemTypeHelper.isSimpleOrString(exprOrLiteral.getBType().getKind())) {
                if (exprOrLiteral.getKind() == NodeKind.UNARY_EXPR) {
                    exprOrLiteral = Types.constructNumericLiteralFromUnaryExpr((BLangUnaryExpr)exprOrLiteral);
                    td.valueSpace.set(i, exprOrLiteral);
                }
            } else {
                throw new IllegalStateException("non-sem value found in BLangFiniteType!");
            }
            SemType s = SemTypeHelper.resolveSingletonType((BLangLiteral)exprOrLiteral);
            valueSpace[i] = new SemNamedType(s, Optional.ofNullable(exprOrLiteral.toString()));
        }
        BFiniteType finiteType = new BFiniteType(finiteTypeSymbol, valueSpace);
        finiteTypeSymbol.type = finiteType;
        td.setBType(finiteType);
        return finiteType;
    }

    private BType blangTypeUpdate(BLangExpression expression) {
        switch (expression.getKind()) {
            case UNARY_EXPR: {
                BType type = this.blangTypeUpdate(((BLangUnaryExpr)expression).expr);
                expression.setBType(type);
                return type;
            }
            case GROUP_EXPR: {
                BType type = this.blangTypeUpdate(((BLangGroupExpr)expression).expression);
                expression.setBType(type);
                return type;
            }
            case LITERAL: {
                return expression.getBType();
            }
            case BINARY_EXPR: {
                BType type = this.blangTypeUpdate(((BLangBinaryExpr)expression).lhsExpr);
                expression.setBType(type);
                return type;
            }
            case NUMERIC_LITERAL: {
                BLangNumericLiteral expr = (BLangNumericLiteral)expression;
                if (expr.getBType().tag == 1 && !(expr.value instanceof Long)) {
                    this.dlog.error(expression.pos, DiagnosticErrorCode.OUT_OF_RANGE, expr.originalValue, expression.getBType());
                    return this.symTable.semanticError;
                }
                return expr.getBType();
            }
        }
        return null;
    }

    private BType resolveTypeDesc(BLangTableTypeNode td, ResolverData data) {
        BType constraintType;
        this.currentDepth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BType type = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.type, data);
        BTableType tableType = new BTableType(this.symTable.typeEnv(), this.symTable.empty, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        tableType.tsymbol = Symbols.createTypeSymbol(12L, Flags.asMask(EnumSet.noneOf(Flag.class)), typeSymbol.name, typeSymbol.originalName, symEnv.enclPkg.symbol.pkgID, tableType, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        tableType.tsymbol.flags = typeSymbol.flags;
        tableType.constraintPos = td.constraint.pos;
        tableType.isTypeInlineDefined = td.isTypeInlineDefined;
        td.setBType(tableType);
        this.resolvingTypes.push(tableType);
        tableType.constraint = constraintType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.constraint, data);
        if (td.tableKeyTypeConstraint != null) {
            tableType.keyTypeConstraint = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.tableKeyTypeConstraint.keyType, data);
            tableType.keyPos = td.tableKeyTypeConstraint.pos;
        } else if (td.tableKeySpecifier != null) {
            BLangTableKeySpecifier tableKeySpecifier = td.tableKeySpecifier;
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (IdentifierNode identifier : tableKeySpecifier.fieldNameIdentifierList) {
                fieldNameList.add(((BLangIdentifier)identifier).value);
            }
            tableType.fieldNameList = fieldNameList;
            tableType.keyPos = tableKeySpecifier.pos;
        }
        if (!(Types.getImpliedType((BType)constraintType).tag != 16 || tableType.fieldNameList.isEmpty() && tableType.keyTypeConstraint == null || tableType.tsymbol.owner.getFlags().contains((Object)Flag.LANG_LIB))) {
            this.dlog.error(tableType.keyPos, DiagnosticErrorCode.KEY_CONSTRAINT_NOT_SUPPORTED_FOR_TABLE_WITH_MAP_CONSTRAINT, new Object[0]);
            return this.symTable.semanticError;
        }
        this.resolvingTypes.pop();
        this.symResolver.markParameterizedType((BType)tableType, constraintType);
        td.tableType = tableType;
        return tableType;
    }

    private BType resolveTypeDesc(BLangStreamType td, ResolverData data) {
        BType constraintType;
        this.currentDepth = data.depth;
        if (td.getBType() != null) {
            return td.getBType();
        }
        SymbolEnv symEnv = data.env;
        BType type = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.type, data);
        BType error = td.error != null ? this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.error, data) : this.symTable.nilType;
        BStreamType streamType = new BStreamType(this.symTable.typeEnv(), 15, this.symTable.empty, error, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        streamType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.originalName, symEnv.enclPkg.symbol.pkgID, streamType, symEnv.scope.owner, td.pos, SymbolOrigin.BUILTIN);
        td.setBType(streamType);
        this.resolvingTypes.push(streamType);
        streamType.constraint = constraintType = this.resolveTypeDesc(symEnv, data.typeDefinition, data.depth + 1, td.constraint, data);
        this.symResolver.markParameterizedType((BType)streamType, constraintType);
        if (error != null) {
            this.symResolver.markParameterizedType((BType)streamType, error);
        }
        this.resolvingTypes.pop();
        return streamType;
    }

    public BType visitBuiltInTypeNode(BLangType typeNode, SymbolResolver.AnalyzerData data, TypeKind typeKind) {
        Name typeName = this.names.fromTypeKind(typeKind);
        BSymbol typeSymbol = this.symResolver.lookupMemberSymbol(typeNode.pos, this.symTable.rootScope, data.env, typeName, 12L);
        if (typeSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(typeNode.pos, data.diagCode, typeName);
        }
        typeNode.setBType(typeSymbol.type);
        return typeSymbol.type;
    }

    public BType defineTypeDefinition(BLangTypeDefinition typeDefinition, BType resolvedType, SymbolEnv env) {
        if (resolvedType == null || resolvedType == this.symTable.noType || typeDefinition.symbol != null) {
            return resolvedType;
        }
        NodeKind typeNodeKind = typeDefinition.typeNode.getKind();
        if ((typeNodeKind == NodeKind.OBJECT_TYPE || typeNodeKind == NodeKind.RECORD_TYPE) && resolvedType.tsymbol.scope == null) {
            resolvedType.tsymbol.scope = new Scope(resolvedType.tsymbol);
        }
        if (typeDefinition.flagSet.contains((Object)Flag.ENUM)) {
            resolvedType.tsymbol = this.createEnumSymbol(typeDefinition, resolvedType, env);
        }
        typeDefinition.setPrecedence(this.typePrecedence++);
        BSymbol typeDefSymbol = Symbols.createTypeDefinitionSymbol(Flags.asMask(typeDefinition.flagSet), this.names.fromIdNode(typeDefinition.name), env.enclPkg.packageID, resolvedType, env.scope.owner, typeDefinition.name.pos, this.symEnter.getOrigin(typeDefinition.name.value));
        typeDefSymbol.markdownDocumentation = this.symEnter.getMarkdownDocAttachment(typeDefinition.markdownDocumentationAttachment);
        BTypeSymbol typeSymbol = new BTypeSymbol(0x20000000L, typeDefSymbol.flags, typeDefSymbol.name, typeDefSymbol.pkgID, typeDefSymbol.type, typeDefSymbol.owner, typeDefSymbol.pos, typeDefSymbol.origin);
        typeSymbol.markdownDocumentation = typeDefSymbol.markdownDocumentation;
        typeDefSymbol.referenceType = new BTypeReferenceType(resolvedType, typeSymbol, typeDefSymbol.type.getFlags());
        if (resolvedType == this.symTable.semanticError && resolvedType.tsymbol == null) {
            typeDefinition.symbol = typeDefSymbol;
            return resolvedType;
        }
        if (resolvedType.tsymbol.name == Names.EMPTY) {
            resolvedType.tsymbol.name = this.names.fromIdNode(typeDefinition.name);
            resolvedType.tsymbol.originalName = this.names.originalNameFromIdNode(typeDefinition.name);
            resolvedType.tsymbol.flags |= typeDefSymbol.flags;
            resolvedType.tsymbol.markdownDocumentation = typeDefSymbol.markdownDocumentation;
            resolvedType.tsymbol.pkgID = env.enclPkg.packageID;
            if (resolvedType.tsymbol.tag == 294940L) {
                resolvedType.tsymbol.owner = env.scope.owner;
            }
        }
        if ((resolvedType.tsymbol.kind == SymbolKind.OBJECT && !Symbols.isFlagOn(resolvedType.tsymbol.flags, 0x10000000L) || resolvedType.tsymbol.kind == SymbolKind.RECORD) && ((BStructureTypeSymbol)resolvedType.tsymbol).typeDefinitionSymbol == null) {
            ((BStructureTypeSymbol)resolvedType.tsymbol).typeDefinitionSymbol = typeDefSymbol;
        }
        if (typeDefinition.flagSet.contains((Object)Flag.ENUM)) {
            typeDefSymbol = resolvedType.tsymbol;
            typeDefSymbol.pos = typeDefinition.name.pos;
        }
        BType referenceConstraintType = Types.getReferredType(resolvedType);
        boolean isIntersectionType = referenceConstraintType.tag == 22;
        BType effectiveDefinedType = isIntersectionType ? ((BIntersectionType)referenceConstraintType).effectiveType : referenceConstraintType;
        BTypeSymbol effectiveTypeSymbol = effectiveDefinedType.tsymbol;
        if (isIntersectionType && effectiveTypeSymbol != null && effectiveTypeSymbol.name == Names.EMPTY) {
            effectiveTypeSymbol.name = typeDefSymbol.name;
            effectiveTypeSymbol.pkgID = typeDefSymbol.pkgID;
        }
        this.symEnter.handleDistinctDefinition(typeDefinition, typeDefSymbol, resolvedType, effectiveDefinedType);
        this.handleDistinctDefinitionOfErrorIntersection(typeDefinition, typeDefSymbol, resolvedType);
        typeDefSymbol.flags |= Flags.asMask(typeDefinition.flagSet);
        typeDefSymbol.flags &= this.symEnter.getPublicFlagResetingMask(typeDefinition.flagSet, typeDefinition.typeNode);
        if (this.symEnter.isDeprecated(typeDefinition.annAttachments)) {
            typeDefSymbol.flags |= 0x10L;
        }
        if (Symbols.isFlagOn(typeDefSymbol.flags, 2048L)) {
            typeDefSymbol.origin = SymbolOrigin.VIRTUAL;
        }
        if (typeDefinition.annAttachments.stream().anyMatch(attachment -> attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value))) {
            if (PackageID.isLangLibPackageID(env.enclPkg.packageID)) {
                typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol);
                typeDefSymbol.flags |= 0x200000L;
                typeDefinition.typeNode.setBType(typeDefSymbol.type);
                resolvedType = typeDefSymbol.type;
            } else {
                this.dlog.error(typeDefinition.pos, DiagnosticErrorCode.TYPE_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
            }
        }
        resolvedType.addFlags(typeDefSymbol.flags);
        typeDefinition.symbol = typeDefSymbol;
        boolean isLanglibModule = PackageID.isLangLibPackageID(env.enclPkg.packageID);
        if (isLanglibModule) {
            this.symEnter.handleLangLibTypes(typeDefinition, env);
            return resolvedType;
        }
        this.symEnter.defineSymbol(typeDefinition.name.pos, typeDefSymbol, env);
        return resolvedType;
    }

    private BEnumSymbol createEnumSymbol(BLangTypeDefinition typeDefinition, BType definedType, SymbolEnv env) {
        ArrayList<BConstantSymbol> enumMembers = new ArrayList<BConstantSymbol>();
        List<BLangType> members = ((BLangUnionTypeNode)typeDefinition.typeNode).memberTypeNodes;
        for (BLangType member : members) {
            enumMembers.add((BConstantSymbol)((BLangUserDefinedType)member).symbol);
        }
        BEnumSymbol enumSymbol = new BEnumSymbol(enumMembers, Flags.asMask(typeDefinition.flagSet), this.names.fromIdNode(typeDefinition.name), this.names.fromIdNode(typeDefinition.name), env.enclPkg.symbol.pkgID, definedType, env.scope.owner, typeDefinition.pos, SymbolOrigin.SOURCE);
        enumSymbol.name = this.names.fromIdNode(typeDefinition.name);
        enumSymbol.originalName = this.names.fromIdNode(typeDefinition.name);
        enumSymbol.flags |= Flags.asMask(typeDefinition.flagSet);
        enumSymbol.markdownDocumentation = this.symEnter.getMarkdownDocAttachment(typeDefinition.markdownDocumentationAttachment);
        enumSymbol.pkgID = env.enclPkg.packageID;
        return enumSymbol;
    }

    public void resolveConstant(SymbolEnv symEnv, Map<String, BLangNode> modTable, BLangConstant constant) {
        if (this.resolvingConstants.contains(constant)) {
            this.dlog.error(constant.pos, DiagnosticErrorCode.CONSTANT_CYCLIC_REFERENCE, this.resolvingConstants.stream().map(constNode -> constNode.symbol).toList());
            constant.setBType(this.symTable.semanticError);
            return;
        }
        this.resolvingConstants.add(constant);
        if (this.resolvedConstants.contains(constant)) {
            this.resolvingConstants.remove(constant);
            return;
        }
        this.defineConstant(symEnv, modTable, constant);
        this.resolvingConstants.remove(constant);
        this.resolvedConstants.add(constant);
        this.checkUniqueness(constant);
    }

    public void resolveXMLNS(SymbolEnv symEnv, BLangXMLNS xmlnsNode) {
        if (xmlnsNode.namespaceURI.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)xmlnsNode.namespaceURI;
            varRef.symbol = this.getSymbolOfVarRef(varRef.pos, symEnv, this.names.fromIdNode(varRef.pkgAlias), this.names.fromIdNode(varRef.variableName));
        }
        this.symEnter.defineXMLNS(symEnv, xmlnsNode);
    }

    public BSymbol getSymbolOfVarRef(Location pos, SymbolEnv env, Name pkgAlias, Name varName) {
        if (pkgAlias == Names.EMPTY && this.modTable.containsKey(varName.value)) {
            BLangNode node = this.modTable.get(varName.value);
            if (node.getKind() == NodeKind.CONSTANT) {
                if (!this.resolvedConstants.contains((BLangConstant)node)) {
                    this.resolveConstant(env, this.modTable, (BLangConstant)node);
                }
            } else {
                this.dlog.error(pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
                return this.symTable.notFoundSymbol;
            }
        }
        return this.symResolver.lookupMainSpaceSymbolInPackage(pos, env, pkgAlias, varName);
    }

    private void checkUniqueness(BLangConstant constant) {
        if (constant.symbol.kind != SymbolKind.CONSTANT) {
            return;
        }
        String nameString = constant.name.value;
        BLangConstantValue value = constant.symbol.value;
        if (!this.constantMap.containsKey(nameString)) {
            this.constantMap.put(nameString, value);
            return;
        }
        if (value == null) {
            this.dlog.error(constant.name.pos, DiagnosticErrorCode.ALREADY_INITIALIZED_SYMBOL, nameString);
            return;
        }
        BLangConstantValue lastValue = this.constantMap.get(nameString);
        if (!value.equals(lastValue)) {
            if (lastValue == null) {
                this.dlog.error(constant.name.pos, DiagnosticErrorCode.ALREADY_INITIALIZED_SYMBOL, nameString);
                return;
            }
            this.dlog.error(constant.name.pos, DiagnosticErrorCode.ALREADY_INITIALIZED_SYMBOL_WITH_ANOTHER, nameString, lastValue);
        }
    }

    private void defineConstant(SymbolEnv symEnv, Map<String, BLangNode> modTable, BLangConstant constant) {
        boolean isLiteral;
        BType staticType;
        Object data;
        BConstantSymbol constantSymbol;
        constant.symbol = constantSymbol = this.symEnter.getConstantSymbol(constant);
        BLangTypeDefinition typeDef = constant.associatedTypeDefinition;
        if (constant.typeNode != null) {
            data = new ResolverData();
            ((ResolverData)data).modTable = modTable;
            staticType = this.resolveTypeDesc(symEnv, typeDef, 0, constant.typeNode, (ResolverData)data);
        } else {
            staticType = this.symTable.noType;
        }
        data = new ConstantTypeChecker.AnalyzerData();
        ((ConstantTypeChecker.AnalyzerData)data).constantSymbol = constantSymbol;
        ((ConstantTypeChecker.AnalyzerData)data).env = symEnv;
        ((ConstantTypeChecker.AnalyzerData)data).modTable = modTable;
        ((ConstantTypeChecker.AnalyzerData)data).expType = staticType;
        ((ConstantTypeChecker.AnalyzerData)data).anonTypeNameSuffixes.push(constant.name.value);
        BType resolvedType = this.constantTypeChecker.checkConstExpr(constant.expr, staticType, (ConstantTypeChecker.AnalyzerData)data);
        ((ConstantTypeChecker.AnalyzerData)data).anonTypeNameSuffixes.pop();
        NodeKind nodeKind = constant.expr.getKind();
        boolean bl = isLiteral = nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL || nodeKind == NodeKind.UNARY_EXPR;
        if (typeDef != null && isLiteral) {
            typeDef.typeNode.setBType(resolvedType);
            resolvedType = this.defineTypeDefinition(typeDef, resolvedType, symEnv);
            typeDef.setBType(resolvedType);
            typeDef.cycleDepth = -1;
        }
        if (resolvedType == this.symTable.semanticError) {
            constant.setBType(this.symTable.semanticError);
            constantSymbol.type = this.symTable.semanticError;
            symEnv.scope.define(constantSymbol.name, constantSymbol);
            return;
        }
        if (resolvedType.tag == 33) {
            resolvedType.tsymbol.originalName = this.names.originalNameFromIdNode(constant.name);
        }
        BType intersectionType = ImmutableTypeCloner.getImmutableType(constant.pos, this.types, resolvedType, symEnv, symEnv.scope.owner.pkgID, symEnv.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
        this.resolveConstantExpressionType.resolveConstExpr(constant.expr, intersectionType, (ConstantTypeChecker.AnalyzerData)data);
        constantSymbol.type = intersectionType;
        constantSymbol.literalType = intersectionType.tag == 33 ? SemTypeHelper.singleShapeBroadType(intersectionType.semType(), this.symTable).get() : intersectionType;
        constant.setBType(intersectionType);
        constantSymbol.value = this.constantTypeChecker.getConstantValue(intersectionType);
        if (isLiteral && constantSymbol.type.tag != 14 && typeDef != null) {
            constantSymbol.type.tsymbol.flags |= typeDef.symbol.flags;
        }
        constantSymbol.markdownDocumentation = this.symEnter.getMarkdownDocAttachment(constant.markdownDocumentationAttachment);
        if (this.symEnter.isDeprecated(constant.annAttachments)) {
            constantSymbol.flags |= 0x10L;
        }
        if (!this.symResolver.checkForUniqueSymbol(constant.name.pos, symEnv, constantSymbol)) {
            return;
        }
        if (constant.symbol.name == Names.IGNORE) {
            return;
        }
        this.addAssociatedTypeDefinition(constant, intersectionType, symEnv);
        constant.setDeterminedType(null);
        symEnv.scope.define(constantSymbol.name, constantSymbol);
    }

    public BLangTypeDefinition findTypeDefinition(List<BLangTypeDefinition> typeDefinitionArrayList, String name) {
        for (int i = typeDefinitionArrayList.size() - 1; i >= 0; --i) {
            BLangTypeDefinition typeDefinition = typeDefinitionArrayList.get(i);
            if (!typeDefinition.name.value.equals(name)) continue;
            return typeDefinition;
        }
        return null;
    }

    private void addAssociatedTypeDefinition(BLangConstant constant, BType type, SymbolEnv symEnv) {
        if (type.tag == 22) {
            BIntersectionType immutableType = (BIntersectionType)type;
            if (immutableType.effectiveType.tag == 12) {
                constant.associatedTypeDefinition = this.findTypeDefinition(symEnv.enclPkg.typeDefinitions, immutableType.effectiveType.tsymbol.name.value);
            }
        }
    }

    private static class ResolverData {
        SymbolEnv env;
        Map<String, BLangNode> modTable;
        int depth;
        BLangTypeDefinition typeDefinition;

        private ResolverData() {
        }
    }

    protected static class LocationData {
        private final String name;
        private final int row;
        private final int column;

        LocationData(String name, int row, int column) {
            this.name = name;
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocationData that = (LocationData)o;
            return this.row == that.row && this.column == that.column && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.row, this.column);
        }
    }
}

