/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Atom;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellSemType;
import io.ballerina.types.CombinedRange;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.ListMemberTypes;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypePair;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.Range;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangMappingBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangInputClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMappingMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class Types {
    private static final CompilerContext.Key<Types> TYPES_KEY = new CompilerContext.Key();
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final BLangDiagnosticLog dlog;
    private final Names names;
    private int finiteTypeCount = 0;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private SymbolEnv env;
    protected final Context semTypeCtx;
    private static final String BASE_16 = "base16";
    private static final BigDecimal DECIMAL_MAX = new BigDecimal("9.999999999999999999999999999999999e6144", MathContext.DECIMAL128);
    private static final BigDecimal DECIMAL_MIN = new BigDecimal("-9.999999999999999999999999999999999e6144", MathContext.DECIMAL128);
    private static final BigDecimal MIN_DECIMAL_MAGNITUDE = new BigDecimal("1.000000000000000000000000000000000e-6143", MathContext.DECIMAL128);
    public static final String AND_READONLY_SUFFIX = " & readonly";

    public static Types getInstance(CompilerContext context) {
        Types types = context.get(TYPES_KEY);
        if (types == null) {
            types = new Types(context);
        }
        return types;
    }

    public Types(CompilerContext context) {
        this(context, new Env());
    }

    public Types(CompilerContext context, Env typeEnv) {
        context.put(TYPES_KEY, this);
        this.semTypeCtx = Context.from((Env)typeEnv);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.names = Names.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
    }

    public BType checkType(BLangExpression node, BType actualType, BType expType) {
        return this.checkType(node, actualType, expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
    }

    public BType addNilForNillableAccessType(BType actualType) {
        if (actualType.isNullable()) {
            return actualType;
        }
        return BUnionType.create(this.typeEnv(), null, actualType, this.symTable.nilType);
    }

    public BType checkType(BLangExpression expr, BType actualType, BType expType, DiagnosticCode diagCode) {
        expr.setDeterminedType(actualType);
        expr.setTypeCheckedType(this.checkType(expr.pos, actualType, expType, diagCode));
        if (expr.getBType().tag == 28) {
            return expr.getBType();
        }
        this.setImplicitCastExpr(expr, actualType, expType);
        return expr.getBType();
    }

    public boolean typeIncompatible(Location pos, BType actualType, BType expType) {
        return this.checkType(pos, actualType, expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES) == this.symTable.semanticError;
    }

    public SemType getErrorIntersection(SemType t) {
        return SemTypes.intersect((SemType)t, (SemType)PredefinedType.ERROR);
    }

    public BType getErrorTypes(BType bType) {
        if ((bType = Types.getImpliedType(bType)) == null) {
            return this.symTable.semanticError;
        }
        BType errorType = this.symTable.semanticError;
        int tag = bType.tag;
        if (tag == 29) {
            return bType;
        }
        if (tag == 38) {
            return this.symTable.errorType;
        }
        if (tag != 21) {
            return errorType;
        }
        LinkedHashSet<BType> errTypes = new LinkedHashSet<BType>();
        Set memTypes = ((BUnionType)bType).getMemberTypes();
        for (BType memType : memTypes) {
            BType memErrType = this.getErrorTypes(memType);
            if (memErrType == this.symTable.semanticError) continue;
            errTypes.add(memErrType);
        }
        if (errTypes.isEmpty()) {
            return errorType;
        }
        return errTypes.size() == 1 ? (BType)errTypes.iterator().next() : BUnionType.create(this.typeEnv(), null, errTypes);
    }

    public BType checkType(Location pos, BType actualType, BType expType, DiagnosticCode diagCode) {
        if (expType.tag == 28) {
            return expType;
        }
        if (expType.tag == 24) {
            return actualType;
        }
        if (actualType.tag == 28) {
            return actualType;
        }
        if (this.isAssignable(actualType, expType)) {
            return actualType;
        }
        this.dlog.error(pos, diagCode, expType, actualType);
        return this.symTable.semanticError;
    }

    public boolean isLaxFieldAccessAllowed(BType type) {
        if (type.tag == 28) {
            return false;
        }
        return this.isLaxFieldAccessAllowed(type.semType());
    }

    public boolean isLaxFieldAccessAllowed(SemType t) {
        if (Core.isNever((SemType)t)) {
            return false;
        }
        return Core.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.XML) || this.isLaxType(t);
    }

    private boolean isLaxType(SemType t) {
        SemType json = Core.createJson((Context)this.semTypeCtx);
        if (SemTypes.isSameType((Context)this.semTypeCtx, (SemType)t, (SemType)json) || SemTypes.isSameType((Context)this.semTypeCtx, (SemType)t, (SemType)SemTypes.intersect((SemType)json, (SemType)PredefinedType.VAL_READONLY))) {
            return true;
        }
        Optional optMatList = Core.mappingAtomicTypesInUnion((Context)this.semTypeCtx, (SemType)t);
        if (optMatList.isEmpty()) {
            return false;
        }
        List matList = (List)optMatList.get();
        return matList.stream().allMatch(mat -> mat.names().length == 0 && this.isLaxType(Core.cellInnerVal((CellSemType)mat.rest())));
    }

    boolean isUniqueType(Iterable<BType> typeList, BType type) {
        type = Types.getImpliedType(type);
        boolean isRecord = type.tag == 12;
        for (BType bType : typeList) {
            bType = Types.getImpliedType(bType);
            if (!(isRecord ? type == bType : this.isSameType(type, bType))) continue;
            return false;
        }
        return true;
    }

    public boolean isSameType(BType source, BType target) {
        return this.isSameType(source.semType(), target.semType());
    }

    public boolean isSameTypeIncludingTags(BType source, BType target) {
        boolean notSameType;
        if (source.tag != target.tag) {
            return false;
        }
        if (source.tag == 21 && (notSameType = ((BUnionType)source).getMemberTypes().stream().map(sT -> ((BUnionType)target).getMemberTypes().stream().anyMatch(it -> Types.getReferredType((BType)it).tag == Types.getReferredType((BType)sT).tag)).anyMatch(foundSameType -> foundSameType == false))) {
            return false;
        }
        return this.isSameType(source.semType(), target.semType());
    }

    public boolean isSameType(SemType source, SemType target) {
        return SemTypes.isSameType((Context)this.semTypeCtx, (SemType)source, (SemType)target);
    }

    public SemType anydata() {
        return Core.createAnydata((Context)this.semTypeCtx);
    }

    public boolean isAnydata(SemType t) {
        return this.isSubtype(t, this.anydata());
    }

    public boolean isValueType(BType type) {
        return switch (Types.getImpliedType((BType)type).tag) {
            case 1, 2, 3, 4, 5, 6, 39, 40, 41, 42, 43, 44, 45 -> true;
            default -> false;
        };
    }

    boolean isBasicNumericType(BType bType) {
        BType type = Types.getImpliedType(bType);
        return type.tag < 5 || TypeTags.isIntegerTypeTag(type.tag);
    }

    public boolean containsErrorType(BType bType) {
        return SemTypeHelper.containsBasicType(bType, PredefinedType.ERROR);
    }

    public boolean containsNilType(BType bType) {
        return SemTypeHelper.containsBasicType(bType, PredefinedType.NIL);
    }

    public boolean isSubTypeOfList(BType bType) {
        return SemTypeHelper.isSubtypeSimpleNotNever(bType, PredefinedType.LIST);
    }

    BType resolvePatternTypeFromMatchExpr(BLangErrorBindingPattern errorBindingPattern, BLangExpression matchExpr, SymbolEnv env) {
        if (matchExpr == null) {
            return errorBindingPattern.getBType();
        }
        BType intersectionType = this.getTypeIntersection(IntersectionContext.compilerInternalIntersectionContext(), matchExpr.getBType(), errorBindingPattern.getBType(), env);
        if (intersectionType == this.symTable.semanticError) {
            return this.symTable.noType;
        }
        return intersectionType;
    }

    public BType resolvePatternTypeFromMatchExpr(BLangListBindingPattern listBindingPattern, BLangVarBindingPatternMatchPattern varBindingPatternMatchPattern, SymbolEnv env) {
        BTupleType listBindingPatternType = (BTupleType)listBindingPattern.getBType();
        if (varBindingPatternMatchPattern.matchExpr == null) {
            return listBindingPatternType;
        }
        BType matchExprType = varBindingPatternMatchPattern.matchExpr.getBType();
        BType intersectionType = this.getTypeIntersection(IntersectionContext.compilerInternalIntersectionContext(), matchExprType, listBindingPatternType, env);
        if (intersectionType != this.symTable.semanticError) {
            return intersectionType;
        }
        return this.symTable.noType;
    }

    public BType resolvePatternTypeFromMatchExpr(BLangListMatchPattern listMatchPattern, BTupleType listMatchPatternType, SymbolEnv env) {
        if (listMatchPattern.matchExpr == null) {
            return listMatchPatternType;
        }
        BType matchExprType = listMatchPattern.matchExpr.getBType();
        BType intersectionType = this.getTypeIntersection(IntersectionContext.compilerInternalIntersectionContext(listMatchPattern.pos), matchExprType, listMatchPatternType, env);
        if (intersectionType != this.symTable.semanticError) {
            return intersectionType;
        }
        return this.symTable.noType;
    }

    BType resolvePatternTypeFromMatchExpr(BLangErrorMatchPattern errorMatchPattern, BLangExpression matchExpr) {
        BType patternType;
        if (matchExpr == null) {
            return errorMatchPattern.getBType();
        }
        BType matchExprType = matchExpr.getBType();
        if (this.isAssignable(matchExprType, patternType = errorMatchPattern.getBType())) {
            return matchExprType;
        }
        if (this.isAssignable(patternType, matchExprType)) {
            return patternType;
        }
        return this.symTable.noType;
    }

    public boolean isExpressionInUnaryValid(BLangExpression expr) {
        if (expr.getKind() == NodeKind.GROUP_EXPR) {
            return ((BLangGroupExpr)expr).expression.getKind() == NodeKind.NUMERIC_LITERAL;
        }
        return expr.getKind() == NodeKind.NUMERIC_LITERAL;
    }

    static BLangExpression checkAndReturnExpressionInUnary(BLangExpression expr) {
        if (expr.getKind() == NodeKind.GROUP_EXPR) {
            return ((BLangGroupExpr)expr).expression;
        }
        return expr;
    }

    public static void setValueOfNumericLiteral(BLangNumericLiteral newNumericLiteral, BLangUnaryExpr unaryExpr) {
        Object objectValueInUnary = ((BLangNumericLiteral)Types.checkAndReturnExpressionInUnary((BLangExpression)unaryExpr.expr)).value;
        Object strValueInUnary = String.valueOf(objectValueInUnary);
        OperatorKind unaryOperatorKind = unaryExpr.operator;
        if (OperatorKind.ADD.equals((Object)unaryOperatorKind)) {
            strValueInUnary = "+" + (String)strValueInUnary;
        } else if (OperatorKind.SUB.equals((Object)unaryOperatorKind)) {
            strValueInUnary = "-" + (String)strValueInUnary;
        }
        objectValueInUnary = objectValueInUnary instanceof Long ? Long.valueOf(Long.parseLong((String)strValueInUnary)) : (objectValueInUnary instanceof Double ? Double.valueOf(Double.parseDouble((String)strValueInUnary)) : strValueInUnary);
        newNumericLiteral.value = objectValueInUnary;
        newNumericLiteral.originalValue = strValueInUnary;
    }

    public boolean isOperatorKindInUnaryValid(OperatorKind unaryOperator) {
        return OperatorKind.SUB.equals((Object)unaryOperator) || OperatorKind.ADD.equals((Object)unaryOperator);
    }

    public boolean isLiteralInUnaryAllowed(BLangUnaryExpr unaryExpr) {
        return this.isExpressionInUnaryValid(unaryExpr.expr) && this.isOperatorKindInUnaryValid(unaryExpr.operator);
    }

    public boolean isExpressionAnAllowedUnaryType(BLangExpression expr, NodeKind nodeKind) {
        if (nodeKind != NodeKind.UNARY_EXPR) {
            return false;
        }
        return this.isLiteralInUnaryAllowed((BLangUnaryExpr)expr);
    }

    public static BLangNumericLiteral constructNumericLiteralFromUnaryExpr(BLangUnaryExpr unaryExpr) {
        BLangExpression exprInUnary = Types.checkAndReturnExpressionInUnary(unaryExpr.expr);
        BLangNumericLiteral newNumericLiteral = (BLangNumericLiteral)TreeBuilder.createNumericLiteralExpression();
        Types.setValueOfNumericLiteral(newNumericLiteral, unaryExpr);
        newNumericLiteral.kind = ((BLangNumericLiteral)exprInUnary).kind;
        newNumericLiteral.pos = unaryExpr.pos;
        newNumericLiteral.setDeterminedType(exprInUnary.getBType());
        newNumericLiteral.setBType(exprInUnary.getBType());
        newNumericLiteral.expectedType = exprInUnary.getBType();
        newNumericLiteral.typeChecked = unaryExpr.typeChecked;
        newNumericLiteral.constantPropagated = unaryExpr.constantPropagated;
        if (unaryExpr.expectedType != null && Types.getImpliedType((BType)unaryExpr.expectedType).tag == 33) {
            newNumericLiteral.isFiniteContext = true;
        }
        return newNumericLiteral;
    }

    BType resolvePatternTypeFromMatchExpr(BLangConstPattern constPattern, BLangExpression constPatternExpr) {
        if (constPattern.matchExpr == null) {
            if (constPatternExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                return ((BLangSimpleVarRef)constPatternExpr).symbol.type;
            }
            return constPatternExpr.getBType();
        }
        BType matchExprType = constPattern.matchExpr.getBType();
        BType constMatchPatternExprType = constPatternExpr.getBType();
        if (constPatternExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef constVarRef = (BLangSimpleVarRef)constPatternExpr;
            BType constVarRefSymbolType = constVarRef.symbol.type;
            if (this.isAssignable(constVarRefSymbolType, matchExprType)) {
                return constVarRefSymbolType;
            }
            return this.symTable.noType;
        }
        BLangLiteral constPatternLiteral = constPatternExpr.getKind() == NodeKind.UNARY_EXPR ? Types.constructNumericLiteralFromUnaryExpr((BLangUnaryExpr)constPatternExpr) : (BLangLiteral)constPatternExpr;
        if (this.containsAnyType(constMatchPatternExprType)) {
            return matchExprType;
        }
        if (this.containsAnyType(matchExprType)) {
            return constMatchPatternExprType;
        }
        BType matchExprReferredType = Types.getImpliedType(matchExprType);
        if (this.isValidLiteral(constPatternLiteral, matchExprReferredType)) {
            return matchExprType;
        }
        if (this.isAssignable(constMatchPatternExprType, matchExprType)) {
            return constMatchPatternExprType;
        }
        if (matchExprReferredType.tag == 21) {
            for (BType memberType : ((BUnionType)matchExprReferredType).getMemberTypes()) {
                if (Types.getImpliedType((BType)memberType).tag == 33) {
                    if (!this.isAssignableToFiniteType(memberType, constPatternLiteral)) continue;
                    return memberType;
                }
                if (!this.isAssignable(constMatchPatternExprType, matchExprType)) continue;
                return constMatchPatternExprType;
            }
        } else if (matchExprReferredType.tag == 33 && this.isAssignableToFiniteType(matchExprType, constPatternLiteral)) {
            return matchExprType;
        }
        return this.symTable.noType;
    }

    BType resolvePatternTypeFromMatchExpr(BLangMappingMatchPattern mappingMatchPattern, BType patternType, SymbolEnv env) {
        if (mappingMatchPattern.matchExpr == null) {
            return patternType;
        }
        BType intersectionType = this.getTypeIntersection(IntersectionContext.matchClauseIntersectionContextForMapping(), mappingMatchPattern.matchExpr.getBType(), patternType, env);
        if (intersectionType == this.symTable.semanticError) {
            return this.symTable.noType;
        }
        return intersectionType;
    }

    public BType resolvePatternTypeFromMatchExpr(BLangMappingBindingPattern mappingBindingPattern, BLangVarBindingPatternMatchPattern varBindingPatternMatchPattern, SymbolEnv env) {
        BRecordType mappingBindingPatternType = (BRecordType)mappingBindingPattern.getBType();
        if (varBindingPatternMatchPattern.matchExpr == null) {
            return mappingBindingPatternType;
        }
        BType intersectionType = this.getTypeIntersection(IntersectionContext.matchClauseIntersectionContextForMapping(), varBindingPatternMatchPattern.matchExpr.getBType(), mappingBindingPatternType, env);
        if (intersectionType == this.symTable.semanticError) {
            return this.symTable.noType;
        }
        return intersectionType;
    }

    private boolean containsAnyType(BType type) {
        return SemTypeHelper.containsType(this.semTypeCtx, type, (SemType)PredefinedType.ANY);
    }

    private boolean containsAnyDataType(BType type) {
        return SemTypeHelper.containsType(this.semTypeCtx, type, Core.createAnydata((Context)this.semTypeCtx));
    }

    BType mergeTypes(BType typeFirst, BType typeSecond) {
        if (this.containsAnyType(typeFirst) && !this.containsErrorType(typeSecond)) {
            return typeSecond;
        }
        if (this.containsAnyType(typeSecond) && !this.containsErrorType(typeFirst)) {
            return typeFirst;
        }
        if (this.containsAnyDataType(typeFirst) && !this.containsErrorType(typeSecond)) {
            return typeSecond;
        }
        if (this.containsAnyDataType(typeSecond) && !this.containsErrorType(typeFirst)) {
            return typeFirst;
        }
        if (this.isSameBasicType(typeFirst, typeSecond)) {
            return typeFirst;
        }
        return BUnionType.create(this.typeEnv(), null, typeFirst, typeSecond);
    }

    public boolean isSubTypeOfMapping(SemType s) {
        return SemTypes.isSubtypeSimpleNotNever((SemType)s, (BasicTypeBitSet)PredefinedType.MAPPING);
    }

    public boolean isSubTypeOfBaseType(BType bType, BasicTypeBitSet bbs) {
        return SemTypeHelper.isSubtypeSimpleNotNever(bType, bbs);
    }

    @Deprecated
    public boolean isSubTypeOfBaseType(BType bType, int baseTypeTag) {
        BType type = Types.getImpliedType(bType);
        if (type.tag != 21) {
            if ((TypeTags.isIntegerTypeTag(type.tag) || type.tag == 2) && 1 == baseTypeTag) {
                return true;
            }
            if (TypeTags.isStringTypeTag(type.tag) && 5 == baseTypeTag) {
                return true;
            }
            if (TypeTags.isXMLTypeTag(type.tag) && 8 == baseTypeTag) {
                return true;
            }
            return type.tag == baseTypeTag || baseTypeTag == 31 && type.tag == 20 || baseTypeTag == 20 && type.tag == 31;
        }
        if (TypeTags.isXMLTypeTag(baseTypeTag)) {
            return true;
        }
        return this.isUnionMemberTypesSubTypeOfBaseType((LinkedHashSet<BType>)((BUnionType)type).getMemberTypes(), baseTypeTag);
    }

    private boolean isUnionMemberTypesSubTypeOfBaseType(LinkedHashSet<BType> memberTypes, int baseTypeTag) {
        for (BType type : memberTypes) {
            if (this.isSubTypeOfBaseType(type, baseTypeTag)) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isAssignable(BType source, BType target) {
        return this.isSubtype(source.semType(), target.semType());
    }

    public boolean isAssignableIgnoreObjectTypeIds(BType source, BType target) {
        SemType s = this.typeIgnoringObjectTypeIds(source.semType());
        SemType t = this.typeIgnoringObjectTypeIds(target.semType());
        return this.isSubtype(s, t);
    }

    public SemType typeIgnoringObjectTypeIds(SemType t) {
        SubtypeData objSubTypeData = Core.subtypeData((SemType)t, (BasicTypeCode)BasicTypeCode.BT_OBJECT);
        if (!(objSubTypeData instanceof Bdd)) {
            return t;
        }
        Bdd b = (Bdd)objSubTypeData;
        Bdd bdd = this.replaceObjectDistinctAtoms(b);
        SemType newObjSemType = Core.createBasicSemType((BasicTypeCode)BasicTypeCode.BT_OBJECT, (SubtypeData)bdd);
        SemType diff = Core.diff((SemType)t, (SemType)PredefinedType.OBJECT);
        return Core.union((SemType)diff, (SemType)newObjSemType);
    }

    private Bdd replaceObjectDistinctAtoms(Bdd b) {
        if (b instanceof BddAllOrNothing) {
            return b;
        }
        BddNode bn = (BddNode)b;
        Atom atom = bn.atom();
        if (bn.atom().kind() == Atom.Kind.DISTINCT_ATOM) {
            atom = PredefinedType.ATOM_MAPPING_OBJECT;
        }
        Bdd left = this.replaceObjectDistinctAtoms(bn.left());
        Bdd middle = this.replaceObjectDistinctAtoms(bn.middle());
        Bdd right = this.replaceObjectDistinctAtoms(bn.right());
        return BddNode.create((Atom)atom, (Bdd)left, (Bdd)middle, (Bdd)right);
    }

    public boolean isSubtype(SemType t1, SemType t2) {
        return SemTypes.isSubtype((Context)this.semTypeCtx, (SemType)t1, (SemType)t2);
    }

    public boolean isSubtype(BType t1, SemType t2) {
        return SemTypeHelper.isSubtype(this.semTypeCtx, t1, t2);
    }

    BField getTableConstraintField(BType constraintType, String fieldName) {
        constraintType = Types.getImpliedType(constraintType);
        switch (constraintType.tag) {
            case 12: {
                LinkedHashMap<String, BField> fieldList = ((BRecordType)constraintType).getFields();
                return (BField)fieldList.get(fieldName);
            }
            case 21: {
                BUnionType unionType = (BUnionType)constraintType;
                Set memTypes = unionType.getMemberTypes();
                List<BField> fields = memTypes.stream().map(type -> this.getTableConstraintField((BType)type, fieldName)).filter(Objects::nonNull).toList();
                if (fields.size() != memTypes.size()) {
                    return null;
                }
                if (!fields.stream().allMatch(field -> this.isAssignable(field.type, ((BField)fields.get((int)0)).type) && this.isAssignable(((BField)fields.get((int)0)).type, field.type))) break;
                return fields.get(0);
            }
        }
        return null;
    }

    public boolean isInherentlyImmutableType(BType type) {
        if (this.isValueType(type = Types.getImpliedType(type))) {
            return true;
        }
        return switch (type.tag) {
            case 10, 13, 17, 29, 33, 37, 38, 49, 50, 53 -> true;
            case 8 -> {
                if (Types.getImpliedType((BType)((BXMLType)type).constraint).tag == 50) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static BType getImpliedType(BType type) {
        if ((type = Types.getReferredType(type)) != null && type.tag == 22) {
            return Types.getImpliedType(((BIntersectionType)type).effectiveType);
        }
        return type;
    }

    public static BType getReferredType(BType type) {
        if (type != null && type.tag == 14) {
            return Types.getReferredType(((BTypeReferenceType)type).referredType);
        }
        return type;
    }

    public BLangExpression addConversionExprIfRequired(BLangExpression expr, BType lhsType) {
        if (lhsType.tag == 24) {
            return expr;
        }
        BType rhsType = expr.getBType();
        if (lhsType.tag == 14 && rhsType.tag != 14) {
            return this.addConversionExprIfRequired(expr, Types.getReferredType(lhsType));
        }
        if (rhsType.tag == lhsType.tag && this.isSameType(rhsType, lhsType)) {
            return expr;
        }
        this.setImplicitCastExpr(expr, rhsType, lhsType);
        if (expr.impConversionExpr != null) {
            BLangTypeConversionExpr impConversionExpr = expr.impConversionExpr;
            expr.impConversionExpr = null;
            return impConversionExpr;
        }
        if (lhsType.tag == 7 && rhsType.tag == 10) {
            return expr;
        }
        if (lhsType.tag == 10 && rhsType.isNullable()) {
            return expr;
        }
        if (lhsType.tag == 20 && rhsType.tag == 31) {
            return expr;
        }
        BLangTypeConversionExpr conversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        conversionExpr.expr = expr;
        conversionExpr.targetType = lhsType;
        conversionExpr.setBType(lhsType);
        conversionExpr.pos = expr.pos;
        conversionExpr.checkTypes = false;
        conversionExpr.internal = true;
        return conversionExpr;
    }

    boolean isSelectivelyImmutableType(BType type, PackageID packageID) {
        return this.isSelectivelyImmutableType(type, new HashSet<BType>(), false, packageID);
    }

    boolean isSelectivelyImmutableType(BType type, boolean forceCheck, PackageID packageID) {
        return this.isSelectivelyImmutableType(type, new HashSet<BType>(), forceCheck, packageID);
    }

    public boolean isSelectivelyImmutableType(BType type, Set<BType> unresolvedTypes, PackageID packageID) {
        return this.isSelectivelyImmutableType(type, unresolvedTypes, false, packageID);
    }

    private boolean isSelectivelyImmutableType(BType input, Set<BType> unresolvedTypes, boolean forceCheck, PackageID packageID) {
        BType type = Types.getImpliedType(input);
        if (this.isInherentlyImmutableType(type) || !(type instanceof SelectivelyImmutableReferenceType)) {
            return false;
        }
        if (!unresolvedTypes.add(type)) {
            return true;
        }
        if (!forceCheck && Types.getImmutableType(this.symTable, packageID, (SelectivelyImmutableReferenceType)((Object)type)).isPresent()) {
            return true;
        }
        switch (type.tag) {
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 35: 
            case 46: 
            case 47: 
            case 48: {
                return true;
            }
            case 20: {
                BArrayType arrayType = (BArrayType)type;
                BType elementType = arrayType.eType;
                if (elementType == this.symTable.semanticError && arrayType.mutableType != null) {
                    elementType = arrayType.mutableType.eType;
                }
                return this.isInherentlyImmutableType(elementType) || this.isSelectivelyImmutableType(elementType, unresolvedTypes, forceCheck, packageID);
            }
            case 31: {
                BTupleType tupleType = (BTupleType)type;
                List<BType> tupleMemberTypes = tupleType.getTupleTypes();
                if (tupleMemberTypes.isEmpty() && tupleType.mutableType != null) {
                    tupleMemberTypes = tupleType.mutableType.getTupleTypes();
                }
                for (BType memberType : tupleMemberTypes) {
                    if (this.isInherentlyImmutableType(memberType) || this.isSelectivelyImmutableType(memberType, unresolvedTypes, forceCheck, packageID)) continue;
                    return false;
                }
                BType tupRestType = tupleType.restType;
                if (tupRestType == null) {
                    return true;
                }
                return this.isInherentlyImmutableType(tupRestType) || this.isSelectivelyImmutableType(tupRestType, unresolvedTypes, forceCheck, packageID);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                LinkedHashMap recordFields = recordType.fields;
                if (recordFields.isEmpty() && recordType.mutableType != null) {
                    recordFields = recordType.mutableType.fields;
                }
                for (BField field : recordFields.values()) {
                    BType fieldType = field.type;
                    if (Symbols.isFlagOn(field.symbol.flags, 4096L) || this.isInherentlyImmutableType(fieldType) || this.isSelectivelyImmutableType(fieldType, unresolvedTypes, forceCheck, packageID)) continue;
                    return false;
                }
                return true;
            }
            case 16: {
                BMapType mapType = (BMapType)type;
                BType constraintType = mapType.constraint;
                if (constraintType == this.symTable.semanticError && mapType.mutableType != null) {
                    constraintType = mapType.mutableType.constraint;
                }
                return this.isInherentlyImmutableType(constraintType) || this.isSelectivelyImmutableType(constraintType, unresolvedTypes, forceCheck, packageID);
            }
            case 34: {
                BObjectType objectType = (BObjectType)type;
                LinkedHashMap objectFields = objectType.fields;
                if (objectFields.isEmpty() && objectType.mutableType != null) {
                    objectFields = objectType.mutableType.fields;
                }
                for (BField field : objectFields.values()) {
                    BType fieldType = field.type;
                    if (this.isInherentlyImmutableType(fieldType) || this.isSelectivelyImmutableType(fieldType, unresolvedTypes, forceCheck, packageID)) continue;
                    return false;
                }
                return true;
            }
            case 9: {
                BTableType tableType = (BTableType)type;
                BType tableConstraintType = tableType.constraint;
                if (tableConstraintType == this.symTable.semanticError && tableType.mutableType != null) {
                    tableConstraintType = tableType.mutableType.constraint;
                }
                return this.isInherentlyImmutableType(tableConstraintType) || this.isSelectivelyImmutableType(tableConstraintType, unresolvedTypes, forceCheck, packageID);
            }
            case 21: {
                boolean readonlyIntersectionExists = false;
                BUnionType unionType = (BUnionType)type;
                Set memberTypes = unionType.getMemberTypes();
                for (BType memberType : memberTypes) {
                    if (!this.isInherentlyImmutableType(memberType) && !this.isSelectivelyImmutableType(memberType, unresolvedTypes, forceCheck, packageID)) continue;
                    readonlyIntersectionExists = true;
                }
                return readonlyIntersectionExists;
            }
        }
        return false;
    }

    public static boolean containsTypeParams(BInvokableType type) {
        boolean hasParameterizedTypes = type.paramTypes.stream().anyMatch(t -> {
            t = Types.getImpliedType(t);
            if (t.tag == 36) {
                return Types.containsTypeParams((BInvokableType)t);
            }
            return TypeParamAnalyzer.isTypeParam(t);
        });
        if (hasParameterizedTypes) {
            return true;
        }
        BType retType = Types.getImpliedType(type.retType);
        if (retType.tag == 36) {
            return Types.containsTypeParams((BInvokableType)retType);
        }
        return TypeParamAnalyzer.isTypeParam(type.retType);
    }

    public void setForeachTypedBindingPatternType(BLangForeach foreachNode) {
        BType varType;
        BType collectionType = Types.getImpliedType(foreachNode.collection.getBType());
        switch (collectionType.tag) {
            case 5: {
                varType = this.symTable.charStringType;
                break;
            }
            case 20: {
                BArrayType arrayType = (BArrayType)collectionType;
                varType = arrayType.eType;
                break;
            }
            case 31: {
                varType = this.getTupleMemberType((BTupleType)collectionType);
                break;
            }
            case 16: {
                BMapType bMapType = (BMapType)collectionType;
                varType = bMapType.constraint;
                break;
            }
            case 12: {
                BRecordType recordType = (BRecordType)collectionType;
                varType = this.inferRecordFieldType(recordType);
                break;
            }
            case 8: {
                BType typedBindingPatternType = this.getTypedBindingPatternTypeForXmlCollection(collectionType);
                if (typedBindingPatternType == null) {
                    foreachNode.varType = this.symTable.semanticError;
                    foreachNode.resultType = this.symTable.semanticError;
                    foreachNode.nillableResultType = this.symTable.semanticError;
                    return;
                }
                varType = typedBindingPatternType;
                break;
            }
            case 49: {
                varType = this.symTable.xmlTextType;
                break;
            }
            case 9: {
                BTableType tableType = (BTableType)collectionType;
                varType = tableType.constraint;
                break;
            }
            case 15: {
                BStreamType streamType = (BStreamType)collectionType;
                if (streamType.constraint.tag == 24) {
                    varType = this.symTable.anydataType;
                    break;
                }
                varType = streamType.constraint;
                List<BType> completionType = this.getAllTypes(streamType.completionType, true);
                if (!completionType.stream().anyMatch(type -> Types.getImpliedType((BType)type).tag != 10)) break;
                BUnionType actualType = BUnionType.create(this.typeEnv(), null, varType, streamType.completionType);
                this.dlog.error(foreachNode.collection.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, varType, actualType);
                break;
            }
            case 34: {
                BUnionType nextMethodReturnType = this.getVarTypeFromIterableObject((BObjectType)collectionType);
                if (nextMethodReturnType != null) {
                    foreachNode.resultType = this.getRecordType(nextMethodReturnType);
                    BType valueType = foreachNode.resultType != null ? ((BField)((BRecordType)foreachNode.resultType).fields.get((Object)"value")).type : null;
                    BErrorType errorType = this.getErrorType(nextMethodReturnType);
                    if (errorType != null) {
                        BUnionType actualType = BUnionType.create(this.typeEnv(), null, valueType, errorType);
                        this.dlog.error(foreachNode.collection.pos, DiagnosticErrorCode.INVALID_ITERABLE_COMPLETION_TYPE_IN_FOREACH_NEXT_FUNCTION, actualType, errorType);
                    }
                    foreachNode.nillableResultType = nextMethodReturnType;
                    foreachNode.varType = valueType;
                    return;
                }
            }
            case 28: {
                foreachNode.varType = this.symTable.semanticError;
                foreachNode.resultType = this.symTable.semanticError;
                foreachNode.nillableResultType = this.symTable.semanticError;
                return;
            }
            default: {
                foreachNode.varType = this.symTable.semanticError;
                foreachNode.resultType = this.symTable.semanticError;
                foreachNode.nillableResultType = this.symTable.semanticError;
                this.dlog.error(foreachNode.collection.pos, DiagnosticErrorCode.ITERABLE_NOT_SUPPORTED_COLLECTION, collectionType);
                return;
            }
        }
        BInvokableSymbol iteratorSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionType, Names.fromString("iterator"), this.env);
        BObjectType objectType = (BObjectType)Types.getImpliedType(iteratorSymbol.retType);
        BUnionType nextMethodReturnType = (BUnionType)this.getResultTypeOfNextInvocation(objectType);
        foreachNode.varType = varType;
        foreachNode.resultType = this.getRecordType(nextMethodReturnType);
        foreachNode.nillableResultType = nextMethodReturnType;
    }

    public void setInputClauseTypedBindingPatternType(BLangInputClause bLangInputClause) {
        if (bLangInputClause.collection == null) {
            return;
        }
        BType collectionType = bLangInputClause.collection.getBType();
        bLangInputClause.varType = this.visitCollectionType(bLangInputClause, collectionType);
        if (bLangInputClause.varType.tag == 28 || Types.getImpliedType((BType)collectionType).tag == 34) {
            return;
        }
        BInvokableSymbol iteratorSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionType, Names.fromString("iterator"), this.env);
        BUnionType nextMethodReturnType = (BUnionType)this.getResultTypeOfNextInvocation((BObjectType)Types.getImpliedType(iteratorSymbol.retType));
        bLangInputClause.resultType = this.getRecordType(nextMethodReturnType);
        bLangInputClause.nillableResultType = nextMethodReturnType;
    }

    private BType getTypedBindingPatternTypeForXmlCollection(BType collectionType) {
        BType constraint = Types.getImpliedType(((BXMLType)collectionType).constraint);
        while (constraint.tag == 8) {
            collectionType = constraint;
            constraint = Types.getImpliedType(((BXMLType)collectionType).constraint);
        }
        switch (constraint.tag) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return constraint;
            }
            case 21: {
                Set<BType> collectionTypes = this.getEffectiveMemberTypes((BUnionType)constraint);
                Set<BType> builtinXMLConstraintTypes = this.getEffectiveMemberTypes((BUnionType)((BXMLType)this.symTable.xmlType).constraint);
                return collectionTypes.size() == 4 && builtinXMLConstraintTypes.equals(collectionTypes) ? collectionType : BUnionType.create(this.typeEnv(), null, (LinkedHashSet)collectionTypes);
            }
        }
        return null;
    }

    private BType visitCollectionType(BLangInputClause bLangInputClause, BType collectionType) {
        collectionType = Types.getImpliedType(collectionType);
        switch (collectionType.tag) {
            case 5: {
                return this.symTable.stringType;
            }
            case 20: {
                BArrayType arrayType = (BArrayType)collectionType;
                return arrayType.eType;
            }
            case 31: {
                return this.getTupleMemberType((BTupleType)collectionType);
            }
            case 16: {
                BMapType bMapType = (BMapType)collectionType;
                return bMapType.constraint;
            }
            case 12: {
                BRecordType recordType = (BRecordType)collectionType;
                return this.inferRecordFieldType(recordType);
            }
            case 8: {
                BType bindingPatternType = this.getTypedBindingPatternTypeForXmlCollection(collectionType);
                return bindingPatternType == null ? this.symTable.semanticError : bindingPatternType;
            }
            case 49: {
                return this.symTable.xmlTextType;
            }
            case 9: {
                BTableType tableType = (BTableType)collectionType;
                return tableType.constraint;
            }
            case 15: {
                BStreamType streamType = (BStreamType)collectionType;
                if (streamType.constraint.tag == 24) {
                    return this.symTable.anydataType;
                }
                return streamType.constraint;
            }
            case 34: {
                if (!this.isAssignable(collectionType, this.symTable.iterableType)) {
                    this.dlog.error(bLangInputClause.collection.pos, DiagnosticErrorCode.INVALID_ITERABLE_OBJECT_TYPE, bLangInputClause.collection.getBType(), this.symTable.iterableType);
                    bLangInputClause.varType = this.symTable.semanticError;
                    bLangInputClause.resultType = this.symTable.semanticError;
                    bLangInputClause.nillableResultType = this.symTable.semanticError;
                    break;
                }
                BUnionType nextMethodReturnType = this.getVarTypeFromIterableObject((BObjectType)collectionType);
                if (nextMethodReturnType != null) {
                    bLangInputClause.resultType = this.getRecordType(nextMethodReturnType);
                    bLangInputClause.nillableResultType = nextMethodReturnType;
                    bLangInputClause.varType = ((BField)((BRecordType)bLangInputClause.resultType).fields.get((Object)"value")).type;
                    return bLangInputClause.varType;
                }
            }
            case 28: {
                bLangInputClause.varType = this.symTable.semanticError;
                bLangInputClause.resultType = this.symTable.semanticError;
                bLangInputClause.nillableResultType = this.symTable.semanticError;
                break;
            }
            default: {
                bLangInputClause.varType = this.symTable.semanticError;
                bLangInputClause.resultType = this.symTable.semanticError;
                bLangInputClause.nillableResultType = this.symTable.semanticError;
                this.dlog.error(bLangInputClause.collection.pos, DiagnosticErrorCode.ITERABLE_NOT_SUPPORTED_COLLECTION, collectionType);
            }
        }
        return this.symTable.semanticError;
    }

    private BType getTupleMemberType(BTupleType tupleType) {
        int tupleTypesSize;
        LinkedHashSet<BType> tupleTypes = new LinkedHashSet<BType>(tupleType.getTupleTypes());
        if (tupleType.restType != null) {
            tupleTypes.add(tupleType.restType);
        }
        if ((tupleTypesSize = tupleTypes.size()) == 0) {
            return this.symTable.neverType;
        }
        return tupleTypesSize == 1 ? (BType)tupleTypes.iterator().next() : BUnionType.create(this.typeEnv(), null, tupleTypes);
    }

    public BUnionType getVarTypeFromIterableObject(BObjectType collectionType) {
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)collectionType.tsymbol;
        for (BAttachedFunction func : objectTypeSymbol.attachedFuncs) {
            if (!func.funcName.value.equals("iterator")) continue;
            return this.getVarTypeFromIteratorFunc(func);
        }
        return null;
    }

    private BUnionType getVarTypeFromIteratorFunc(BAttachedFunction candidateIteratorFunc) {
        if (!candidateIteratorFunc.type.paramTypes.isEmpty()) {
            return null;
        }
        BType returnType = candidateIteratorFunc.type.retType;
        return this.getVarTypeFromIteratorFuncReturnType(returnType);
    }

    public BUnionType getVarTypeFromIteratorFuncReturnType(BType type) {
        BType returnType = Types.getImpliedType(type);
        if (returnType.tag != 34) {
            return null;
        }
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)returnType.tsymbol;
        for (BAttachedFunction func : objectTypeSymbol.attachedFuncs) {
            if (!func.funcName.value.equals("next")) continue;
            return this.getVarTypeFromNextFunc(func);
        }
        return null;
    }

    private BUnionType getVarTypeFromNextFunc(BAttachedFunction nextFunc) {
        if (!nextFunc.type.paramTypes.isEmpty()) {
            return null;
        }
        BType returnType = nextFunc.type.retType;
        if (this.checkNextFuncReturnType(returnType)) {
            return (BUnionType)returnType;
        }
        return null;
    }

    private boolean checkNextFuncReturnType(BType returnType) {
        if (Types.getImpliedType((BType)returnType).tag != 21) {
            return false;
        }
        List<BType> types = this.getAllTypes(returnType, true);
        boolean containsCompletionType = types.removeIf(type -> type.tag == 10);
        boolean bl = containsCompletionType = types.removeIf(type -> type.tag == 29) || containsCompletionType;
        if (!containsCompletionType) {
            return false;
        }
        if (types.size() != 1) {
            return false;
        }
        if (types.get((int)0).tag != 12) {
            return false;
        }
        BRecordType recordType = (BRecordType)types.get(0);
        return this.checkRecordTypeInNextFuncReturnType(recordType);
    }

    private boolean checkRecordTypeInNextFuncReturnType(BRecordType recordType) {
        if (!recordType.sealed) {
            return false;
        }
        if (recordType.fields.size() != 1) {
            return false;
        }
        return recordType.fields.containsKey("value");
    }

    private BRecordType getRecordType(BUnionType type) {
        for (BType member : type.getMemberTypes()) {
            BType referredRecordType = Types.getImpliedType(member);
            if (referredRecordType.tag != 12) continue;
            return (BRecordType)referredRecordType;
        }
        return null;
    }

    public BErrorType getErrorType(BUnionType type) {
        for (BType member : type.getMemberTypes()) {
            BErrorType e;
            member = Types.getImpliedType(member);
            if (member.tag == 29) {
                return (BErrorType)member;
            }
            if (member.tag != 21 || (e = this.getErrorType((BUnionType)member)) == null) continue;
            return e;
        }
        return null;
    }

    public BType getResultTypeOfNextInvocation(BObjectType iteratorType) {
        BAttachedFunction nextFunc = this.getAttachedFuncFromObject(iteratorType, "next");
        return Objects.requireNonNull(nextFunc).type.retType;
    }

    public BAttachedFunction getAttachedFuncFromObject(BObjectType objectType, String funcName) {
        BObjectTypeSymbol iteratorSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        for (BAttachedFunction bAttachedFunction : iteratorSymbol.attachedFuncs) {
            if (!funcName.equals(bAttachedFunction.funcName.value)) continue;
            return bAttachedFunction;
        }
        return null;
    }

    public BType inferRecordFieldType(BRecordType recordType) {
        LinkedHashMap fields = recordType.fields;
        BUnionType unionType = BUnionType.create(this.typeEnv(), null, new BType[0]);
        if (!recordType.sealed) {
            unionType.add(recordType.restFieldType);
        } else if (fields.isEmpty()) {
            unionType.add(this.symTable.neverType);
        }
        for (BField field : fields.values()) {
            if (this.isAssignable(field.type, unionType)) continue;
            if (this.isAssignable(unionType, field.type)) {
                unionType = BUnionType.create(this.typeEnv(), null, new BType[0]);
            }
            unionType.add(field.type);
        }
        if (((HashSet)unionType.getMemberTypes()).size() > 1) {
            unionType.tsymbol = Symbols.createTypeSymbol(1081372L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, recordType.tsymbol.pkgID, null, recordType.tsymbol.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            return unionType;
        }
        return (BType)((HashSet)unionType.getMemberTypes()).iterator().next();
    }

    public BType getTypeWithEffectiveIntersectionTypes(BType bType) {
        BType type = Types.getReferredType(bType);
        BType effectiveType = null;
        if (type.tag == 22) {
            type = effectiveType = ((BIntersectionType)type).effectiveType;
        }
        if (type.tag != 21) {
            return Objects.requireNonNullElse(effectiveType, bType);
        }
        LinkedHashSet<BType> members = new LinkedHashSet<BType>();
        boolean hasDifferentMember = false;
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            effectiveType = this.getTypeWithEffectiveIntersectionTypes(memberType);
            if ((effectiveType = Types.getImpliedType(effectiveType)) != memberType) {
                hasDifferentMember = true;
            }
            members.add(effectiveType);
        }
        if (hasDifferentMember) {
            return BUnionType.create(this.typeEnv(), null, members);
        }
        return bType;
    }

    TypeTestResult isBuiltInTypeWidenPossible(BType actualType, BType targetType) {
        int targetTag = Types.getImpliedType((BType)targetType).tag;
        int actualTag = Types.getImpliedType((BType)actualType).tag;
        if (actualTag < 7 && targetTag < 7) {
            switch (actualTag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (targetTag != 6 && targetTag != 5) break;
                    return TypeTestResult.FALSE;
                }
                case 6: {
                    if (targetTag != 1 && targetTag != 2 && targetTag != 3 && targetTag != 4 && targetTag != 5) break;
                    return TypeTestResult.FALSE;
                }
                case 5: {
                    if (targetTag != 1 && targetTag != 2 && targetTag != 3 && targetTag != 4 && targetTag != 6) break;
                    return TypeTestResult.FALSE;
                }
            }
        }
        switch (actualTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (targetTag != 7 && targetTag != 11 && targetTag != 18 && targetTag != 38) break;
                return TypeTestResult.TRUE;
            }
            case 11: 
            case 13: {
                if (targetTag != 18) break;
                return TypeTestResult.TRUE;
            }
        }
        if (TypeTags.isIntegerTypeTag(targetTag) && actualTag == targetTag) {
            return TypeTestResult.FALSE;
        }
        if ((TypeTags.isIntegerTypeTag(actualTag) || actualTag == 2) && (TypeTags.isIntegerTypeTag(targetTag) || targetTag == 2)) {
            return this.checkBuiltInIntSubtypeWidenPossible(actualType, targetType);
        }
        if (actualTag == 45 && 5 == targetTag) {
            return TypeTestResult.TRUE;
        }
        return TypeTestResult.NOT_FOUND;
    }

    private TypeTestResult checkBuiltInIntSubtypeWidenPossible(BType actualType, BType targetType) {
        int actualTag = Types.getImpliedType((BType)actualType).tag;
        targetType = Types.getImpliedType(targetType);
        switch (targetType.tag) {
            case 1: {
                if (actualTag != 2 && !TypeTags.isIntegerTypeTag(actualTag)) break;
                return TypeTestResult.TRUE;
            }
            case 39: {
                if (actualTag != 40 && actualTag != 41 && actualTag != 43 && actualTag != 44 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 40: {
                if (actualTag != 41 && actualTag != 44 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 42: {
                if (actualTag != 43 && actualTag != 44 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 43: {
                if (actualTag != 44 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 2: {
                if (actualTag != 44) break;
                return TypeTestResult.TRUE;
            }
            case 44: {
                if (actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
        }
        return TypeTestResult.NOT_FOUND;
    }

    public boolean isImplicitlyCastable(BType actual, BType target) {
        TypeTestResult result;
        BType targetType = Types.getImpliedType(target);
        BType actualType = Types.getImpliedType(actual);
        BType newTargetType = targetType;
        int targetTypeTag = targetType.tag;
        if ((targetTypeTag == 21 || targetTypeTag == 33) && this.isValueType(actualType)) {
            newTargetType = this.symTable.anyType;
        }
        if ((result = this.isBuiltInTypeWidenPossible(actualType, newTargetType)) != TypeTestResult.NOT_FOUND) {
            return result == TypeTestResult.TRUE;
        }
        if (this.isValueType(targetType) && (actualType.tag == 33 || actualType.tag == 21 && ((BUnionType)actualType).getMemberTypes().stream().anyMatch(type -> Types.getImpliedType((BType)type).tag == 33 && this.isAssignable((BType)type, targetType)))) {
            return TypeTags.isIntegerTypeTag(targetTypeTag) || targetType.tag == 2 || targetTypeTag == 3 || targetTypeTag == 4 || TypeTags.isStringTypeTag(targetTypeTag) || targetTypeTag == 6;
        }
        if (this.isValueType(targetType) && actualType.tag == 21 && ((BUnionType)actualType).getMemberTypes().stream().allMatch(type -> this.isAssignable((BType)type, targetType))) {
            return true;
        }
        return targetTypeTag == 29 && actualType.tag == 21 && this.isAllErrorMembers((BUnionType)actualType);
    }

    public boolean isTypeCastable(BType source, BType target) {
        BType sourceType = Types.getImpliedType(source);
        BType targetType = Types.getImpliedType(target);
        if (sourceType.tag == 28 || targetType.tag == 28 || sourceType == targetType) {
            return true;
        }
        SemType sourceSemType = sourceType.semType();
        SemType targetSemType = targetType.semType();
        if (this.containsErrorType(sourceSemType) && !this.containsErrorType(targetSemType)) {
            return false;
        }
        if (this.isNumericConversionPossible(sourceType, targetType)) {
            return true;
        }
        return this.intersectionExists(sourceSemType, targetSemType);
    }

    public boolean containsErrorType(SemType t) {
        return SemTypes.containsBasicType((SemType)t, (BasicTypeBitSet)PredefinedType.ERROR);
    }

    boolean isNumericConversionPossible(BType sourceType, BType targetType) {
        Optional targetNumericType = Core.singleNumericType((SemType)targetType.semType());
        if (targetNumericType.isEmpty()) {
            return false;
        }
        return !Core.isEmpty((Context)this.semTypeCtx, (SemType)SemTypes.intersect((SemType)sourceType.semType(), (SemType)PredefinedType.NUMBER));
    }

    public boolean isAllErrorMembers(BUnionType actualType) {
        return this.isSubtype(actualType, (SemType)PredefinedType.ERROR);
    }

    public void setImplicitCastExpr(BLangExpression expr, BType actualType, BType targetType) {
        BType expType = Types.getImpliedType(targetType);
        if (!this.isImplicitlyCastable(actualType, expType)) {
            return;
        }
        BLangTypeConversionExpr implicitConversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        implicitConversionExpr.pos = expr.pos;
        implicitConversionExpr.expr = expr.impConversionExpr == null ? expr : expr.impConversionExpr;
        implicitConversionExpr.setBType(expType);
        implicitConversionExpr.targetType = expType;
        implicitConversionExpr.internal = true;
        expr.impConversionExpr = implicitConversionExpr;
    }

    public boolean checkListenerCompatibilityAtServiceDecl(BType type) {
        if (Types.getImpliedType((BType)type).tag == 21) {
            int listenerCompatibleTypeCount = 0;
            for (BType memberType : this.getAllTypes(type, true)) {
                if (memberType.tag == 29) continue;
                if (!this.checkListenerCompatibility(memberType)) {
                    return false;
                }
                ++listenerCompatibleTypeCount;
            }
            return listenerCompatibleTypeCount > 0;
        }
        return this.checkListenerCompatibility(type);
    }

    public boolean checkListenerCompatibility(BType bType) {
        BType type = Types.getImpliedType(bType);
        if (type.tag == 21) {
            BUnionType unionType = (BUnionType)type;
            for (BType memberType : unionType.getMemberTypes()) {
                if (this.checkListenerCompatibility(memberType)) continue;
                return false;
            }
            return true;
        }
        if (type.tag != 34) {
            return false;
        }
        BObjectType rhsType = (BObjectType)type;
        List<BAttachedFunction> rhsFuncs = ((BStructureTypeSymbol)rhsType.tsymbol).attachedFuncs;
        ListenerValidationModel listenerValidationModel = new ListenerValidationModel(this, this.symTable);
        return listenerValidationModel.checkMethods(rhsFuncs);
    }

    public boolean isValidErrorDetailType(BType detailType) {
        return switch (Types.getImpliedType((BType)detailType).tag) {
            case 12, 16 -> this.isAssignable(detailType, this.symTable.detailType);
            default -> false;
        };
    }

    private Set<BType> getEffectiveMemberTypes(BUnionType unionType) {
        LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>();
        block4: for (BType memberType : unionType.getMemberTypes()) {
            switch (memberType.tag) {
                case 21: {
                    memTypes.addAll(this.getEffectiveMemberTypes((BUnionType)memberType));
                    continue block4;
                }
                case 14: 
                case 22: {
                    BType constraint = Types.getImpliedType(memberType);
                    if (constraint.tag == 21) {
                        memTypes.addAll(this.getEffectiveMemberTypes((BUnionType)constraint));
                        continue block4;
                    }
                    memTypes.add(constraint);
                    continue block4;
                }
            }
            memTypes.add(memberType);
        }
        return memTypes;
    }

    boolean isAssignableToFiniteType(BType type, BLangLiteral literalExpr) {
        type = Types.getImpliedType(type);
        if (type.tag != 33) {
            return false;
        }
        BFiniteType expType = (BFiniteType)type;
        return this.checkLiteralAssignabilityBasedOnType(literalExpr, expType, literalExpr.getBType().tag);
    }

    boolean checkLiteralAssignabilityBasedOnType(BLangLiteral literal, BFiniteType finiteType, int targetTypeTag) {
        Object value = literal.value;
        int literalTypeTag = literal.getBType().tag;
        SemType t = finiteType.semType();
        switch (targetTypeTag) {
            case 1: {
                if (literalTypeTag != 1) break;
                if (value instanceof String) {
                    return false;
                }
                return Core.containsConstInt((SemType)t, (long)((Number)value).longValue());
            }
            case 3: {
                if (literalTypeTag == 1 && !literal.isConstant) {
                    double doubleValue = literal.value instanceof Double ? Double.parseDouble(String.valueOf(value)) : ((Long)value).doubleValue();
                    return Core.containsConstFloat((SemType)t, (double)doubleValue);
                }
                if (literalTypeTag != 3) break;
                try {
                    double doubleValue = Double.parseDouble(String.valueOf(value));
                    return Core.containsConstFloat((SemType)t, (double)doubleValue);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 4: {
                if (literalTypeTag == 1 && !literal.isConstant) {
                    BigDecimal decimalValue = literal.value instanceof String ? NumericLiteralSupport.parseBigDecimal(value) : (literal.value instanceof Double ? new BigDecimal((Double)value, MathContext.DECIMAL128) : new BigDecimal((Long)value, MathContext.DECIMAL128));
                    return Core.containsConstDecimal((SemType)t, (BigDecimal)decimalValue);
                }
                if ((literalTypeTag != 3 || literal.isConstant) && literalTypeTag != 4) break;
                if (NumericLiteralSupport.isFloatDiscriminated(String.valueOf(value))) {
                    return false;
                }
                try {
                    BigDecimal decimalValue = NumericLiteralSupport.parseBigDecimal(value);
                    return Core.containsConstDecimal((SemType)t, (BigDecimal)decimalValue);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            default: {
                return Core.containsConst((SemType)t, (Object)value);
            }
        }
        return false;
    }

    boolean validateFloatLiteral(Location pos, String numericLiteral) {
        char character;
        double value;
        try {
            value = Double.parseDouble(numericLiteral);
        }
        catch (Exception e) {
            return false;
        }
        if (Double.isInfinite(value)) {
            this.dlog.error(pos, DiagnosticErrorCode.OUT_OF_RANGE, numericLiteral, "float");
            return false;
        }
        if (value != 0.0) {
            return true;
        }
        List<Character> exponentIndicator = List.of(Character.valueOf('e'), Character.valueOf('E'), Character.valueOf('p'), Character.valueOf('P'));
        for (int i = 0; i < numericLiteral.length() && !exponentIndicator.contains(Character.valueOf(character = numericLiteral.charAt(i))); ++i) {
            if (numericLiteral.charAt(i) < '1' || numericLiteral.charAt(i) > '9') continue;
            this.dlog.error(pos, DiagnosticErrorCode.OUT_OF_RANGE, numericLiteral, "float");
            return false;
        }
        return true;
    }

    boolean isValidDecimalNumber(Location pos, String decimalLiteral) {
        BigDecimal bd;
        try {
            bd = new BigDecimal(decimalLiteral, MathContext.DECIMAL128);
        }
        catch (NumberFormatException e) {
            if (this.dlog.errorCount() == 0) {
                this.dlog.error(pos, DiagnosticErrorCode.OUT_OF_RANGE, decimalLiteral, this.symTable.decimalType);
            }
            return false;
        }
        if (bd.compareTo(DECIMAL_MAX) > 0 || bd.compareTo(DECIMAL_MIN) < 0) {
            this.dlog.error(pos, DiagnosticErrorCode.OUT_OF_RANGE, decimalLiteral, this.symTable.decimalType);
            return false;
        }
        return true;
    }

    boolean isByteLiteralValue(Long longObject) {
        return longObject >= (long)SymbolTable.BBYTE_MIN_VALUE.intValue() && longObject <= (long)SymbolTable.BBYTE_MAX_VALUE.intValue();
    }

    boolean isSigned32LiteralValue(Long longObject) {
        return longObject >= (long)SymbolTable.SIGNED32_MIN_VALUE.intValue() && longObject <= (long)SymbolTable.SIGNED32_MAX_VALUE.intValue();
    }

    BigDecimal getValidDecimalNumber(Location pos, BigDecimal bd) {
        if (bd.compareTo(DECIMAL_MAX) > 0 || bd.compareTo(DECIMAL_MIN) < 0) {
            this.dlog.error(pos, DiagnosticErrorCode.OUT_OF_RANGE, bd.toString(), this.symTable.decimalType);
            return null;
        }
        if (bd.abs(MathContext.DECIMAL128).compareTo(MIN_DECIMAL_MAGNITUDE) < 0 && bd.abs(MathContext.DECIMAL128).compareTo(BigDecimal.ZERO) > 0) {
            return BigDecimal.ZERO;
        }
        return bd;
    }

    boolean isSigned16LiteralValue(Long longObject) {
        return longObject >= (long)SymbolTable.SIGNED16_MIN_VALUE.intValue() && longObject <= (long)SymbolTable.SIGNED16_MAX_VALUE.intValue();
    }

    boolean isSigned8LiteralValue(Long longObject) {
        return longObject >= (long)SymbolTable.SIGNED8_MIN_VALUE.intValue() && longObject <= (long)SymbolTable.SIGNED8_MAX_VALUE.intValue();
    }

    boolean isUnsigned32LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= SymbolTable.UNSIGNED32_MAX_VALUE;
    }

    boolean isUnsigned16LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= (long)SymbolTable.UNSIGNED16_MAX_VALUE.intValue();
    }

    boolean isUnsigned8LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= (long)SymbolTable.UNSIGNED8_MAX_VALUE.intValue();
    }

    boolean isCharLiteralValue(String literal) {
        return literal.codePoints().count() == 1L;
    }

    private Optional<BType> getFiniteTypeForAssignableValues(BType finiteType, BType targetType) {
        BFiniteType bFiniteType = (BFiniteType)finiteType;
        ArrayList<SemNamedType> newValueSpace = new ArrayList<SemNamedType>(bFiniteType.valueSpace.length);
        for (SemNamedType semNamedType : bFiniteType.valueSpace) {
            if (!SemTypes.isSubtype((Context)this.semTypeCtx, (SemType)semNamedType.semType(), (SemType)targetType.semType())) continue;
            newValueSpace.add(semNamedType);
        }
        if (newValueSpace.isEmpty()) {
            return Optional.empty();
        }
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(557084L, finiteType.tsymbol.flags, Names.fromString("$anonType$_" + this.finiteTypeCount++), finiteType.tsymbol.pkgID, null, finiteType.tsymbol.owner, finiteType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        BFiniteType ft = new BFiniteType(finiteTypeSymbol, (SemNamedType[])newValueSpace.toArray(SemNamedType[]::new));
        finiteTypeSymbol.type = ft;
        return Optional.of(ft);
    }

    BType getTypeForUnionTypeMembersAssignableToType(BUnionType unionType, BType targetType, SymbolEnv env, IntersectionContext intersectionContext, LinkedHashSet<BType> visitedTypes) {
        LinkedList intersection = new LinkedList();
        if (!visitedTypes.add(unionType)) {
            return unionType;
        }
        unionType.getMemberTypes().forEach(memType -> {
            BType memberIntersectionType = this.getTypeIntersection(intersectionContext, (BType)memType, targetType, env, visitedTypes);
            if (memberIntersectionType != this.symTable.semanticError) {
                intersection.add(memberIntersectionType);
            }
        });
        if (intersection.isEmpty()) {
            return this.symTable.semanticError;
        }
        if (intersection.size() == 1) {
            return (BType)intersection.get(0);
        }
        return BUnionType.create(this.typeEnv(), null, new LinkedHashSet<BType>(intersection));
    }

    boolean validEqualityIntersectionExists(BType lhsType, BType rhsType) {
        SemType intersect = Core.intersect((SemType)lhsType.semType(), (SemType)rhsType.semType());
        if (Core.isEmpty((Context)this.semTypeCtx, (SemType)intersect)) {
            return false;
        }
        return this.isAnydata(intersect);
    }

    boolean validStringOrXmlTypeExists(BType type) {
        return this.isStringSubtype(type) || this.isXmlSubType(type);
    }

    boolean isXmlSubType(BType type) {
        return SemTypeHelper.isSubtypeSimple(type, PredefinedType.XML);
    }

    boolean isStringSubtype(BType type) {
        return SemTypeHelper.isSubtypeSimple(type, PredefinedType.STRING);
    }

    boolean validNumericTypeExists(BType type) {
        SemType tButNil = Core.diff((SemType)type.semType(), (SemType)PredefinedType.NIL);
        BasicTypeBitSet basicTypeBitSet = Core.widenToBasicTypes((SemType)tButNil);
        return basicTypeBitSet.equals((Object)PredefinedType.INT) || basicTypeBitSet.equals((Object)PredefinedType.FLOAT) || basicTypeBitSet.equals((Object)PredefinedType.DECIMAL);
    }

    boolean validIntegerTypeExists(BType bType) {
        SemType s = bType.semType();
        s = Core.diff((SemType)s, (SemType)PredefinedType.NIL);
        return SemTypes.isSubtypeSimpleNotNever((SemType)s, (BasicTypeBitSet)PredefinedType.INT);
    }

    public boolean isStringSubType(BType type) {
        return SemTypeHelper.isSubtypeSimpleNotNever(type, PredefinedType.STRING);
    }

    public Set<BType> expandAndGetMemberTypesRecursive(BType bType) {
        HashSet<BType> visited = new HashSet<BType>();
        return this.expandAndGetMemberTypesRecursiveHelper(bType, visited);
    }

    private Set<BType> expandAndGetMemberTypesRecursiveHelper(BType bType, HashSet<BType> visited) {
        BType referredType = Types.getImpliedType(bType);
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        switch (referredType.tag) {
            case 1: 
            case 2: {
                memberTypes.add(this.symTable.intType);
                memberTypes.add(this.symTable.byteType);
                break;
            }
            case 33: {
                Set<BType> broadTypes = SemTypeHelper.broadTypes((BFiniteType)referredType, this.symTable);
                memberTypes.addAll(broadTypes);
                break;
            }
            case 21: {
                BUnionType unionType = (BUnionType)referredType;
                if (!visited.add(unionType)) {
                    return memberTypes;
                }
                unionType.getMemberTypes().forEach(member -> memberTypes.addAll(this.expandAndGetMemberTypesRecursiveHelper((BType)member, visited)));
                break;
            }
            case 20: {
                BType arrayElementType = ((BArrayType)referredType).getElementType();
                if (((BArrayType)referredType).getSize() != -1) {
                    memberTypes.add(new BArrayType(this.typeEnv(), arrayElementType));
                }
                if (Types.getImpliedType((BType)arrayElementType).tag == 21) {
                    Set<BType> elementUnionTypes = this.expandAndGetMemberTypesRecursiveHelper(arrayElementType, visited);
                    elementUnionTypes.forEach(elementUnionType -> memberTypes.add(new BArrayType(this.typeEnv(), (BType)elementUnionType)));
                }
                memberTypes.add(bType);
                break;
            }
            case 16: {
                BType mapConstraintType = ((BMapType)referredType).getConstraint();
                if (Types.getImpliedType((BType)mapConstraintType).tag == 21) {
                    Set<BType> constraintUnionTypes = this.expandAndGetMemberTypesRecursiveHelper(mapConstraintType, visited);
                    constraintUnionTypes.forEach(constraintUnionType -> memberTypes.add(new BMapType(this.symTable.typeEnv(), 16, (BType)constraintUnionType, this.symTable.mapType.tsymbol)));
                }
                memberTypes.add(bType);
                break;
            }
            default: {
                memberTypes.add(bType);
            }
        }
        return memberTypes;
    }

    public BType getRemainingMatchExprType(BType originalType, BType typeToRemove, SymbolEnv env) {
        originalType = Types.getImpliedType(originalType);
        return switch (originalType.tag) {
            case 21 -> this.getRemainingType((BUnionType)originalType, this.getAllTypes(typeToRemove, true));
            case 33 -> this.getRemainingType((BFiniteType)originalType, this.getAllTypes(typeToRemove, true));
            case 31 -> this.getRemainingType((BTupleType)originalType, typeToRemove, env);
            default -> originalType;
        };
    }

    private BType getRemainingType(BTupleType originalType, BType typeToRemove, SymbolEnv env) {
        typeToRemove = Types.getImpliedType(typeToRemove);
        return switch (typeToRemove.tag) {
            case 31 -> this.getRemainingType(originalType, (BTupleType)typeToRemove, env);
            case 20 -> this.getRemainingType(originalType, (BArrayType)typeToRemove, env);
            default -> originalType;
        };
    }

    private BType getRemainingType(BTupleType originalType, BTupleType typeToRemove, SymbolEnv env) {
        BVarSymbol varSymbol;
        BType type;
        int i;
        if (originalType.restType != null) {
            return originalType;
        }
        ArrayList<BType> originalTupleTypes = new ArrayList<BType>(originalType.getTupleTypes());
        ArrayList<BType> typesToRemove = new ArrayList<BType>(typeToRemove.getTupleTypes());
        if (originalTupleTypes.size() < typesToRemove.size()) {
            return originalType;
        }
        ArrayList<BTupleMember> tupleTypes = new ArrayList<BTupleMember>();
        for (i = 0; i < originalTupleTypes.size(); ++i) {
            type = this.getRemainingMatchExprType((BType)originalTupleTypes.get(i), (BType)typesToRemove.get(i), env);
            varSymbol = new BVarSymbol(type.getFlags(), null, null, type, null, null, null);
            tupleTypes.add(new BTupleMember(type, varSymbol));
        }
        if (typeToRemove.restType == null) {
            return new BTupleType(this.typeEnv(), tupleTypes);
        }
        if (originalTupleTypes.size() == typesToRemove.size()) {
            return originalType;
        }
        for (i = typesToRemove.size(); i < originalTupleTypes.size(); ++i) {
            type = this.getRemainingMatchExprType((BType)originalTupleTypes.get(i), typeToRemove.restType, env);
            varSymbol = Symbols.createVarSymbolForTupleMember(type);
            tupleTypes.add(new BTupleMember(type, varSymbol));
        }
        return new BTupleType(this.typeEnv(), tupleTypes);
    }

    private BType getRemainingType(BTupleType originalType, BArrayType typeToRemove, SymbolEnv env) {
        BType eType = typeToRemove.eType;
        ArrayList<BTupleMember> tupleTypes = new ArrayList<BTupleMember>();
        for (BType tupleMemberType : originalType.getTupleTypes()) {
            BType type = this.getRemainingMatchExprType(tupleMemberType, eType, env);
            BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(type);
            tupleTypes.add(new BTupleMember(type, varSymbol));
        }
        BTupleType remainingType = new BTupleType(this.typeEnv(), tupleTypes);
        if (originalType.restType != null) {
            remainingType.restType = this.getRemainingMatchExprType(originalType.restType, eType, env);
        }
        return remainingType;
    }

    public BType getRemainingType(BType originalType, BType typeToRemove, SymbolEnv env) {
        BType remainingType = originalType;
        if (originalType.tag == 22) {
            originalType = ((BIntersectionType)originalType).effectiveType;
        }
        boolean unionOriginalType = false;
        switch (originalType.tag) {
            case 21: {
                unionOriginalType = true;
                remainingType = this.getRemainingType((BUnionType)originalType, this.getAllTypes(typeToRemove, true));
                BType typeRemovedFromOriginalUnionType = Types.getImpliedType(this.getRemainingType((BUnionType)originalType, this.getAllTypes(remainingType, true)));
                if (typeRemovedFromOriginalUnionType != this.symTable.nullSet && !this.isSubTypeOfReadOnly(typeRemovedFromOriginalUnionType) && !this.isSubTypeOfReadOnly(remainingType) && !this.narrowsToUnionOfImmutableTypesOrDistinctBasicTypes(remainingType, typeToRemove, env)) break;
                return remainingType;
            }
            case 33: {
                return this.getRemainingType((BFiniteType)originalType, this.getAllTypes(typeToRemove, true));
            }
            case 38: {
                remainingType = this.getRemainingType((BReadonlyType)originalType, typeToRemove);
                break;
            }
            case 14: {
                BType refType = Types.getImpliedType(originalType);
                if (refType.tag != 21 && refType.tag != 33) {
                    return originalType;
                }
                return this.getRemainingType(refType, typeToRemove, env);
            }
        }
        if (Symbols.isFlagOn(Types.getImpliedType(originalType).getFlags(), 32L)) {
            return remainingType;
        }
        BType referredTypeToRemove = Types.getImpliedType(typeToRemove);
        if (this.isClosedRecordTypes(referredTypeToRemove) && this.removesDistinctRecords(typeToRemove, remainingType)) {
            return remainingType;
        }
        if (this.removesDistinctBasicTypes(typeToRemove, remainingType)) {
            return remainingType;
        }
        if (unionOriginalType && referredTypeToRemove.tag == 21) {
            BType typeToRemoveFrom = originalType;
            for (BType memberTypeToRemove : ((BUnionType)referredTypeToRemove).getMemberTypes()) {
                typeToRemoveFrom = remainingType = this.getRemainingType(typeToRemoveFrom, memberTypeToRemove, env);
            }
            return remainingType;
        }
        return originalType;
    }

    public boolean isSubTypeOfReadOnly(SemType t) {
        return this.isSubtype(t, PredefinedType.VAL_READONLY);
    }

    public boolean isSubTypeOfReadOnly(BType type) {
        return this.isSubTypeOfReadOnly(type.semType());
    }

    private boolean isClosedRecordTypes(BType type) {
        type = Types.getImpliedType(type);
        return switch (type.tag) {
            case 12 -> {
                BRecordType recordType = (BRecordType)type;
                if (recordType.sealed || recordType.restFieldType == this.symTable.neverType) {
                    yield true;
                }
                yield false;
            }
            case 21 -> {
                for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                    if (this.isClosedRecordTypes(Types.getImpliedType(memberType))) continue;
                    yield false;
                }
                yield true;
            }
            default -> false;
        };
    }

    private boolean removesDistinctRecords(BType typeToRemove, BType remainingType) {
        ArrayList fieldsInRemainingTypes = new ArrayList();
        remainingType = Types.getImpliedType(remainingType);
        switch (remainingType.tag) {
            case 7: 
            case 11: 
            case 16: 
            case 18: {
                return false;
            }
            case 12: {
                BRecordType recordType = (BRecordType)remainingType;
                if (!recordType.sealed && recordType.restFieldType != this.symTable.neverType) {
                    return false;
                }
                fieldsInRemainingTypes.add(recordType.fields.keySet());
                break;
            }
            case 21: {
                for (BType bType : ((BUnionType)remainingType).getMemberTypes()) {
                    BType referredMemberType = Types.getImpliedType(bType);
                    int tag = referredMemberType.tag;
                    if (tag == 12) {
                        BRecordType memberRecordType = (BRecordType)referredMemberType;
                        if (!memberRecordType.sealed && memberRecordType.restFieldType != this.symTable.neverType) {
                            return false;
                        }
                        fieldsInRemainingTypes.add(memberRecordType.fields.keySet());
                        continue;
                    }
                    if (tag != 16 && tag != 7 && tag != 11 && tag != 18) continue;
                    return false;
                }
                break;
            }
        }
        ArrayList fieldsInRemovingTypes = new ArrayList();
        typeToRemove = Types.getImpliedType(typeToRemove);
        switch (typeToRemove.tag) {
            case 12: {
                fieldsInRemovingTypes.add(((BRecordType)typeToRemove).fields.keySet());
                break;
            }
            case 21: {
                for (BType bType : ((BUnionType)typeToRemove).getMemberTypes()) {
                    BType referredType = Types.getImpliedType(bType);
                    if (referredType.tag != 12) continue;
                    fieldsInRemovingTypes.add(((BRecordType)referredType).fields.keySet());
                }
                break;
            }
        }
        for (Set set : fieldsInRemovingTypes) {
            if (!fieldsInRemainingTypes.contains(set)) continue;
            return false;
        }
        return true;
    }

    private boolean removesDistinctBasicTypes(BType typeToRemove, BType remainingType) {
        HashSet<BasicTypes> removedBasicTypes = new HashSet<BasicTypes>();
        HashSet<BasicTypes> remainingBasicTypes = new HashSet<BasicTypes>();
        this.populateBasicTypes(typeToRemove, removedBasicTypes);
        this.populateBasicTypes(remainingType, remainingBasicTypes);
        if (remainingBasicTypes.contains((Object)BasicTypes.ANY)) {
            for (BasicTypes removedBasicType : removedBasicTypes) {
                if (removedBasicType == BasicTypes.ERROR) continue;
                return false;
            }
        }
        for (BasicTypes remainingBasicType : remainingBasicTypes) {
            if (!removedBasicTypes.contains((Object)remainingBasicType)) continue;
            return false;
        }
        return true;
    }

    private boolean narrowsToUnionOfImmutableTypesOrDistinctBasicTypes(BType remainingType, BType typeToRemove, SymbolEnv env) {
        LinkedHashSet<BType> mutableTypesToRemove;
        BType referredRemainingType = Types.getImpliedType(remainingType);
        if (referredRemainingType.tag != 21) {
            return false;
        }
        LinkedHashSet<BType> mutableRemainingTypes = this.filterMutableMembers((LinkedHashSet<BType>)((BUnionType)referredRemainingType).getMemberTypes(), env);
        remainingType = mutableRemainingTypes.size() == 1 ? (BType)mutableRemainingTypes.iterator().next() : BUnionType.create(this.typeEnv(), null, mutableRemainingTypes);
        BType referredTypeToRemove = Types.getImpliedType(typeToRemove);
        typeToRemove = referredTypeToRemove.tag == 21 ? ((mutableTypesToRemove = this.filterMutableMembers((LinkedHashSet<BType>)((BUnionType)referredTypeToRemove).getMemberTypes(), env)).size() == 1 ? (BType)mutableTypesToRemove.iterator().next() : BUnionType.create(this.typeEnv(), null, mutableTypesToRemove)) : referredTypeToRemove;
        return this.removesDistinctBasicTypes(typeToRemove, remainingType);
    }

    private LinkedHashSet<BType> filterMutableMembers(LinkedHashSet<BType> types, SymbolEnv env) {
        LinkedHashSet<BType> remainingMemberTypes = new LinkedHashSet<BType>();
        for (BType type : types) {
            BType referredType = Types.getImpliedType(type);
            if (this.isSubTypeOfReadOnly(referredType)) continue;
            remainingMemberTypes.add(referredType);
        }
        return remainingMemberTypes;
    }

    private BType getRemainingType(BReadonlyType originalType, BType removeType) {
        if (Types.getImpliedType((BType)removeType).tag == 29) {
            return this.symTable.anyAndReadonly;
        }
        return originalType;
    }

    public boolean intersectionExists(SemType t1, SemType t2) {
        return !Core.isEmpty((Context)this.semTypeCtx, (SemType)Core.intersect((SemType)t1, (SemType)t2));
    }

    public BType getTypeIntersection(IntersectionContext intersectionContext, BType lhsType, BType rhsType, SymbolEnv env) {
        return this.getTypeIntersection(intersectionContext, lhsType, rhsType, env, new LinkedHashSet<BType>());
    }

    private BType getTypeIntersection(IntersectionContext intersectionContext, BType lhsType, BType rhsType, SymbolEnv env, LinkedHashSet<BType> visitedTypes) {
        List<BType> rhsTypeComponents = this.getAllTypes(rhsType, true);
        LinkedHashSet<BType> intersection = new LinkedHashSet<BType>(rhsTypeComponents.size());
        for (BType rhsComponent : rhsTypeComponents) {
            BType it = this.getIntersection(intersectionContext, lhsType, env, rhsComponent, new LinkedHashSet<BType>(visitedTypes));
            if (it == null) continue;
            intersection.add(it);
        }
        if (intersection.isEmpty()) {
            if (Types.getImpliedType((BType)lhsType).tag == 51) {
                return lhsType;
            }
            return this.symTable.semanticError;
        }
        if (intersection.size() == 1) {
            return intersection.toArray(new BType[0])[0];
        }
        return BUnionType.create(this.typeEnv(), null, intersection);
    }

    private BType getIntersection(IntersectionContext intersectionContext, BType lhsType, SymbolEnv env, BType type, LinkedHashSet<BType> visitedTypes) {
        Object intersectionType;
        BType referredType = Types.getImpliedType(type);
        BType referredLhsType = Types.getReferredType(lhsType);
        if (intersectionContext.preferNonGenerativeIntersection) {
            if (this.isAssignable(referredType, referredLhsType)) {
                return type;
            }
            if (this.isAssignable(referredLhsType, referredType)) {
                return lhsType;
            }
        }
        if (Symbols.isFlagOn(referredLhsType.getFlags(), 32L) && referredLhsType.tag == 22 && Types.getImpliedType((BType)((BIntersectionType)referredLhsType).effectiveType).tag == 21) {
            intersectionType = (BIntersectionType)referredLhsType;
            BType finalType = type;
            List<BType> types = ((BIntersectionType)intersectionType).getConstituentTypes().stream().filter(t -> Types.getImpliedType((BType)t).tag != 38).map(t -> this.getIntersection(intersectionContext, (BType)t, env, finalType, visitedTypes)).filter(Objects::nonNull).toList();
            if (types.size() == 1) {
                BType bType = types.get(0);
                if (this.isInherentlyImmutableType(bType) || Symbols.isFlagOn(bType.getFlags(), 32L)) {
                    return bType;
                }
                if (!this.isSelectivelyImmutableType(bType, new HashSet<BType>(), env.enclPkg.packageID)) {
                    return this.symTable.semanticError;
                }
                return ImmutableTypeCloner.getEffectiveImmutableType(intersectionContext.pos, this, bType, env, this.symTable, this.anonymousModelHelper, this.names);
            }
        }
        referredLhsType = Types.getImpliedType(lhsType);
        if (referredType.tag == 29 && referredLhsType.tag == 29) {
            intersectionType = this.getIntersectionForErrorTypes(intersectionContext, referredLhsType, referredType, env, visitedTypes);
            if (intersectionType != this.symTable.semanticError) {
                return intersectionType;
            }
        } else if (referredType.tag == 12 && referredLhsType.tag == 12) {
            intersectionType = this.createRecordIntersection(intersectionContext, (BRecordType)referredLhsType, (BRecordType)referredType, env, visitedTypes);
            if (intersectionType != this.symTable.semanticError) {
                return intersectionType;
            }
        } else if (referredType.tag == 16 && referredLhsType.tag == 12) {
            intersectionType = this.createRecordIntersection(intersectionContext, (BRecordType)referredLhsType, this.getEquivalentRecordType((BMapType)referredType), env, visitedTypes);
            if (intersectionType != this.symTable.semanticError) {
                return intersectionType;
            }
        } else if (referredType.tag == 12 && referredLhsType.tag == 16) {
            intersectionType = this.createRecordIntersection(intersectionContext, this.getEquivalentRecordType((BMapType)referredLhsType), (BRecordType)referredType, env, visitedTypes);
            if (intersectionType != this.symTable.semanticError) {
                return intersectionType;
            }
        } else {
            if (!intersectionContext.preferNonGenerativeIntersection && this.isAssignable(referredType, referredLhsType)) {
                return type;
            }
            if (!intersectionContext.preferNonGenerativeIntersection && this.isAssignable(referredLhsType, referredType)) {
                return lhsType;
            }
            if (referredLhsType.tag == 33) {
                intersectionType = this.getFiniteTypeForAssignableValues(referredLhsType, type);
                if (((Optional)intersectionType).isPresent()) {
                    return ((Optional)intersectionType).get();
                }
            } else if (referredType.tag == 33) {
                intersectionType = this.getFiniteTypeForAssignableValues(referredType, lhsType);
                if (((Optional)intersectionType).isPresent()) {
                    return ((Optional)intersectionType).get();
                }
            } else if (referredLhsType.tag == 21) {
                intersectionType = this.getTypeForUnionTypeMembersAssignableToType((BUnionType)referredLhsType, type, env, intersectionContext, visitedTypes);
                if (intersectionType != this.symTable.semanticError) {
                    return intersectionType;
                }
            } else if (referredType.tag == 21) {
                intersectionType = this.getTypeForUnionTypeMembersAssignableToType((BUnionType)referredType, lhsType, env, intersectionContext, visitedTypes);
                if (intersectionType != this.symTable.semanticError) {
                    return intersectionType;
                }
            } else {
                if (referredType.tag == 16 && referredLhsType.tag == 16) {
                    BType intersectionConstraintTypeType = this.getIntersection(intersectionContext, ((BMapType)referredLhsType).constraint, env, ((BMapType)referredType).constraint, visitedTypes);
                    if (intersectionConstraintTypeType == null || intersectionConstraintTypeType == this.symTable.semanticError) {
                        return null;
                    }
                    return new BMapType(this.symTable.typeEnv(), 16, intersectionConstraintTypeType, null);
                }
                if (referredType.tag == 20 && referredLhsType.tag == 31) {
                    intersectionType = this.createArrayAndTupleIntersection(intersectionContext, (BArrayType)referredType, (BTupleType)referredLhsType, env, visitedTypes);
                    if (intersectionType != this.symTable.semanticError) {
                        return intersectionType;
                    }
                } else if (referredType.tag == 31 && referredLhsType.tag == 20) {
                    intersectionType = this.createArrayAndTupleIntersection(intersectionContext, (BArrayType)referredLhsType, (BTupleType)referredType, env, visitedTypes);
                    if (intersectionType != this.symTable.semanticError) {
                        return intersectionType;
                    }
                } else if (referredType.tag == 31 && referredLhsType.tag == 31) {
                    intersectionType = this.createTupleAndTupleIntersection(intersectionContext, (BTupleType)referredLhsType, (BTupleType)referredType, env, visitedTypes);
                    if (intersectionType != this.symTable.semanticError) {
                        return intersectionType;
                    }
                } else if (this.isAnydataOrJson(referredType) && referredLhsType.tag == 12) {
                    intersectionType = this.createRecordIntersection(intersectionContext, (BRecordType)referredLhsType, this.getEquivalentRecordType(this.getMapTypeForAnydataOrJson(referredType, env)), env, visitedTypes);
                    if (intersectionType != this.symTable.semanticError) {
                        return intersectionType;
                    }
                } else if (referredType.tag == 12 && this.isAnydataOrJson(referredLhsType)) {
                    intersectionType = this.createRecordIntersection(intersectionContext, this.getEquivalentRecordType(this.getMapTypeForAnydataOrJson(referredLhsType, env)), (BRecordType)referredType, env, visitedTypes);
                    if (intersectionType != this.symTable.semanticError) {
                        return intersectionType;
                    }
                } else {
                    if (this.isAnydataOrJson(referredType) && referredLhsType.tag == 16) {
                        return this.getIntersection(intersectionContext, lhsType, env, this.getMapTypeForAnydataOrJson(referredType, env), visitedTypes);
                    }
                    if (referredType.tag == 16 && this.isAnydataOrJson(referredLhsType)) {
                        return this.getIntersection(intersectionContext, this.getMapTypeForAnydataOrJson(referredLhsType, env), env, referredType, visitedTypes);
                    }
                    if (this.isAnydataOrJson(referredType) && referredLhsType.tag == 31) {
                        intersectionType = this.createArrayAndTupleIntersection(intersectionContext, this.getArrayTypeForAnydataOrJson(referredType, env), (BTupleType)referredLhsType, env, visitedTypes);
                        if (intersectionType != this.symTable.semanticError) {
                            return intersectionType;
                        }
                    } else if (referredType.tag == 31 && this.isAnydataOrJson(referredLhsType)) {
                        intersectionType = this.createArrayAndTupleIntersection(intersectionContext, this.getArrayTypeForAnydataOrJson(referredLhsType, env), (BTupleType)referredType, env, visitedTypes);
                        if (intersectionType != this.symTable.semanticError) {
                            return intersectionType;
                        }
                    } else {
                        BType elementIntersection;
                        if (this.isAnydataOrJson(referredType) && referredLhsType.tag == 20) {
                            elementIntersection = this.getIntersection(intersectionContext, ((BArrayType)referredLhsType).eType, env, type, visitedTypes);
                            if (elementIntersection == null) {
                                return null;
                            }
                            return new BArrayType(this.typeEnv(), elementIntersection);
                        }
                        if (referredType.tag == 20 && this.isAnydataOrJson(referredLhsType)) {
                            elementIntersection = this.getIntersection(intersectionContext, lhsType, env, ((BArrayType)referredType).eType, visitedTypes);
                            if (elementIntersection == null) {
                                return null;
                            }
                            return new BArrayType(this.typeEnv(), elementIntersection);
                        }
                        if (referredType.tag == 51) {
                            return type;
                        }
                    }
                }
            }
        }
        return null;
    }

    private boolean isAnydataOrJson(BType type) {
        return switch (Types.getImpliedType((BType)type).tag) {
            case 7, 11 -> true;
            default -> false;
        };
    }

    private BMapType getMapTypeForAnydataOrJson(BType type, SymbolEnv env) {
        BMapType mapType;
        BMapType bMapType = mapType = Types.getImpliedType((BType)type).tag == 11 ? this.symTable.mapAnydataType : this.symTable.mapJsonType;
        if (this.isImmutable(type)) {
            return (BMapType)ImmutableTypeCloner.getEffectiveImmutableType(null, this, mapType, env, this.symTable, this.anonymousModelHelper, this.names);
        }
        return mapType;
    }

    private BArrayType getArrayTypeForAnydataOrJson(BType type, SymbolEnv env) {
        BArrayType arrayType;
        BArrayType bArrayType = arrayType = Types.getImpliedType((BType)type).tag == 11 ? this.symTable.arrayAnydataType : this.symTable.arrayJsonType;
        if (this.isImmutable(type)) {
            return (BArrayType)ImmutableTypeCloner.getEffectiveImmutableType(null, this, arrayType, env, this.symTable, this.anonymousModelHelper, this.names);
        }
        return arrayType;
    }

    private BType createArrayAndTupleIntersection(IntersectionContext intersectionContext, BArrayType arrayType, BTupleType tupleType, SymbolEnv env, LinkedHashSet<BType> visitedTypes) {
        if (!visitedTypes.add(tupleType)) {
            return tupleType;
        }
        List<BType> tupleTypes = tupleType.getTupleTypes();
        if (arrayType.state == BArrayState.CLOSED && tupleTypes.size() != arrayType.getSize()) {
            if (tupleTypes.size() > arrayType.getSize()) {
                return this.symTable.semanticError;
            }
            if (tupleType.restType == null) {
                return this.symTable.semanticError;
            }
        }
        ArrayList<BTupleMember> tupleMemberTypes = new ArrayList<BTupleMember>(tupleTypes.size());
        BType eType = arrayType.eType;
        for (BType memberType : tupleTypes) {
            BType intersectionType = this.getTypeIntersection(intersectionContext, memberType, eType, env, visitedTypes);
            if (intersectionType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(intersectionType);
            tupleMemberTypes.add(new BTupleMember(intersectionType, varSymbol));
        }
        if (tupleType.restType == null) {
            return new BTupleType(this.typeEnv(), tupleMemberTypes);
        }
        BType restIntersectionType = this.getTypeIntersection(intersectionContext, tupleType.restType, eType, env, visitedTypes);
        if (restIntersectionType == this.symTable.semanticError) {
            return new BTupleType(this.typeEnv(), tupleMemberTypes);
        }
        return new BTupleType(this.typeEnv(), null, tupleMemberTypes, restIntersectionType, 0L);
    }

    private BType createTupleAndTupleIntersection(IntersectionContext intersectionContext, BTupleType lhsTupleType, BTupleType tupleType, SymbolEnv env, LinkedHashSet<BType> visitedTypes) {
        if (lhsTupleType.restType == null && tupleType.restType != null) {
            return this.symTable.semanticError;
        }
        if (lhsTupleType.restType == null && lhsTupleType.getMembers().size() != tupleType.getMembers().size()) {
            return this.symTable.semanticError;
        }
        List<BType> lhsTupleTypes = lhsTupleType.getTupleTypes();
        List<BType> tupleTypes = tupleType.getTupleTypes();
        if (lhsTupleTypes.size() > tupleTypes.size()) {
            return this.symTable.semanticError;
        }
        ArrayList<BTupleMember> tupleMemberTypes = new ArrayList<BTupleMember>(tupleTypes.size());
        for (int i = 0; i < tupleTypes.size(); ++i) {
            BType lhsType = lhsTupleTypes.size() > i ? lhsTupleTypes.get(i) : lhsTupleType.restType;
            BType intersectionType = this.getTypeIntersection(intersectionContext, tupleTypes.get(i), lhsType, env, visitedTypes);
            if (intersectionType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            BVarSymbol varSymbol = new BVarSymbol(intersectionType.getFlags(), null, null, intersectionType, null, null, null);
            tupleMemberTypes.add(new BTupleMember(intersectionType, varSymbol));
        }
        if (lhsTupleType.restType != null && tupleType.restType != null) {
            BType restIntersectionType = this.getTypeIntersection(intersectionContext, tupleType.restType, lhsTupleType.restType, env, visitedTypes);
            if (restIntersectionType == this.symTable.semanticError) {
                return new BTupleType(this.typeEnv(), tupleMemberTypes);
            }
            return new BTupleType(this.typeEnv(), null, tupleMemberTypes, restIntersectionType, 0L);
        }
        return new BTupleType(this.typeEnv(), tupleMemberTypes);
    }

    private BType getIntersectionForErrorTypes(IntersectionContext intersectionContext, BType lhsType, BType rhsType, SymbolEnv env, LinkedHashSet<BType> visitedTypes) {
        BType detailIntersectionType = this.getTypeIntersection(intersectionContext, ((BErrorType)lhsType).detailType, ((BErrorType)rhsType).detailType, env, visitedTypes);
        if (detailIntersectionType == this.symTable.semanticError) {
            return this.symTable.semanticError;
        }
        BErrorType intersectionErrorType = this.createErrorType(lhsType, rhsType, detailIntersectionType, env);
        if (intersectionContext.createTypeDefs) {
            BTypeSymbol errorTSymbol = intersectionErrorType.tsymbol;
            BLangErrorType bLangErrorType = TypeDefBuilderHelper.createBLangErrorType(this.symTable.builtinPos, intersectionErrorType, env, this.anonymousModelHelper);
            BLangTypeDefinition errorTypeDefinition = TypeDefBuilderHelper.addTypeDefinition(intersectionErrorType, errorTSymbol, bLangErrorType, env);
            errorTypeDefinition.pos = this.symTable.builtinPos;
        }
        return intersectionErrorType;
    }

    private BType createRecordIntersection(IntersectionContext intersectionContext, BRecordType recordTypeOne, BRecordType recordTypeTwo, SymbolEnv env, LinkedHashSet<BType> visitedTypes) {
        if (!visitedTypes.add(recordTypeOne)) {
            return recordTypeOne;
        }
        LinkedHashMap recordOneFields = recordTypeOne.fields;
        LinkedHashMap recordTwoFields = recordTypeTwo.fields;
        Set<String> recordOneKeys = recordOneFields.keySet();
        Set<String> recordTwoKeys = recordTwoFields.keySet();
        boolean isRecordOneClosed = recordTypeOne.sealed;
        boolean isRecordTwoClosed = recordTypeTwo.sealed;
        BType effectiveRecordOneRestFieldType = this.getConstraint(recordTypeOne);
        BType effectiveRecordTwoRestFieldType = this.getConstraint(recordTypeTwo);
        BRecordType newType = this.createAnonymousRecord(env);
        BTypeSymbol newTypeSymbol = newType.tsymbol;
        HashSet<String> addedKeys = new HashSet<String>();
        LinkedHashMap newTypeFields = newType.fields;
        if (!this.populateFields(intersectionContext.switchLeft(), recordTypeOne, env, recordOneFields, recordTwoFields, recordOneKeys, recordTwoKeys, isRecordTwoClosed, effectiveRecordTwoRestFieldType, newTypeSymbol, addedKeys, newTypeFields, visitedTypes)) {
            return this.symTable.semanticError;
        }
        if (!this.populateFields(intersectionContext.switchRight(), recordTypeTwo, env, recordTwoFields, recordOneFields, recordTwoKeys, recordOneKeys, isRecordOneClosed, effectiveRecordOneRestFieldType, newTypeSymbol, addedKeys, newTypeFields, visitedTypes)) {
            return this.symTable.semanticError;
        }
        BType restFieldType = this.getTypeIntersection(intersectionContext, effectiveRecordOneRestFieldType, effectiveRecordTwoRestFieldType, env, visitedTypes);
        if (this.setRestType(newType, restFieldType) == this.symTable.semanticError) {
            return this.symTable.semanticError;
        }
        if ((newType.sealed || newType.restFieldType == this.symTable.neverType) && (newTypeFields.isEmpty() || this.allReadOnlyFields(newTypeFields))) {
            newType.addFlags(32L);
            newTypeSymbol.flags |= 0x20L;
        }
        if (intersectionContext.createTypeDefs) {
            BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(newType, env.enclPkg.packageID, this.symTable, this.symTable.builtinPos);
            BLangTypeDefinition recordTypeDef = TypeDefBuilderHelper.addTypeDefinition(newType, newType.tsymbol, recordTypeNode, env);
            env.enclPkg.symbol.scope.define(newType.tsymbol.name, newType.tsymbol);
            recordTypeDef.pos = this.symTable.builtinPos;
        }
        return newType;
    }

    private boolean populateFields(IntersectionContext intersectionContext, BRecordType lhsRecord, SymbolEnv env, LinkedHashMap<String, BField> lhsRecordFields, LinkedHashMap<String, BField> rhsRecordFields, Set<String> lhsRecordKeys, Set<String> rhsRecordKeys, boolean isRhsRecordClosed, BType effectiveRhsRecordRestFieldType, BTypeSymbol newTypeSymbol, Set<String> addedKeys, LinkedHashMap<String, BField> newTypeFields, LinkedHashSet<BType> visitedTypes) {
        for (String key : lhsRecordKeys) {
            BVarSymbol recordFieldSymbol;
            BType intersectionFieldType;
            BField lhsRecordField = lhsRecordFields.get(key);
            if (!this.validateRecordFieldDefaultValueForIntersection(intersectionContext, lhsRecordField, lhsRecord)) {
                return false;
            }
            if (!addedKeys.add(key)) continue;
            long intersectionFlags = lhsRecordField.symbol.flags;
            BType recordOneFieldType = lhsRecordField.type;
            if (!rhsRecordKeys.contains(key)) {
                if (isRhsRecordClosed) {
                    if (Symbols.isFlagOn(lhsRecordField.symbol.flags, 4096L)) continue;
                    return false;
                }
                if (this.isNeverTypeOrStructureTypeWithARequiredNeverMember(effectiveRhsRecordRestFieldType) && !this.isNeverTypeOrStructureTypeWithARequiredNeverMember(recordOneFieldType)) {
                    return false;
                }
                intersectionFieldType = this.getIntersection(intersectionContext, recordOneFieldType, env, effectiveRhsRecordRestFieldType, visitedTypes);
                if (intersectionFieldType == null || intersectionFieldType == this.symTable.semanticError) {
                    if (Symbols.isFlagOn(lhsRecordField.symbol.flags, 4096L)) continue;
                    return false;
                }
            } else {
                BField rhsRecordField = rhsRecordFields.get(key);
                intersectionFieldType = this.getIntersection(intersectionContext, recordOneFieldType, env, rhsRecordField.type, visitedTypes);
                long rhsFieldFlags = rhsRecordField.symbol.flags;
                if (Symbols.isFlagOn(rhsFieldFlags, 32L)) {
                    intersectionFlags |= 0x20L;
                }
                if (!Symbols.isFlagOn(rhsFieldFlags, 4096L) && Symbols.isFlagOn(intersectionFlags, 4096L)) {
                    intersectionFlags &= 0xFFFFFFFFFFFFEFFFL;
                }
                if (Symbols.isFlagOn(rhsFieldFlags, 256L) && !Symbols.isFlagOn(intersectionFlags, 256L)) {
                    intersectionFlags |= 0x100L;
                }
            }
            if (intersectionFieldType == null || intersectionFieldType == this.symTable.semanticError) {
                return false;
            }
            Name name = lhsRecordField.name;
            if (Types.getImpliedType((BType)intersectionFieldType).tag == 17 && intersectionFieldType.tsymbol != null) {
                recordFieldSymbol = new BInvokableSymbol(lhsRecordField.symbol.tag, intersectionFlags, name, env.enclPkg.packageID, intersectionFieldType, (BSymbol)newTypeSymbol, lhsRecordField.pos, SymbolOrigin.SOURCE);
                BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)intersectionFieldType.tsymbol;
                BInvokableSymbol invokableSymbol = (BInvokableSymbol)recordFieldSymbol;
                invokableSymbol.params = tsymbol == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
                invokableSymbol.restParam = tsymbol.restParam;
                invokableSymbol.retType = tsymbol.returnType;
                invokableSymbol.flags = tsymbol.flags;
            } else {
                recordFieldSymbol = new BVarSymbol(intersectionFlags, name, env.enclPkg.packageID, intersectionFieldType, newTypeSymbol, lhsRecordField.symbol.pos, SymbolOrigin.SOURCE);
            }
            newTypeFields.put(key, new BField(name, recordFieldSymbol.pos, recordFieldSymbol));
            newTypeSymbol.scope.define(name, recordFieldSymbol);
        }
        return true;
    }

    private boolean allReadOnlyFields(LinkedHashMap<String, BField> fields) {
        for (BField field : fields.values()) {
            if (Symbols.isFlagOn(field.symbol.flags, 32L)) continue;
            return false;
        }
        return true;
    }

    private BType setRestType(BRecordType recordType, BType restType) {
        if (restType == this.symTable.semanticError) {
            recordType.restFieldType = this.symTable.semanticError;
            return this.symTable.semanticError;
        }
        if (restType == this.symTable.neverType) {
            recordType.sealed = true;
            recordType.restFieldType = this.symTable.noType;
            return this.symTable.noType;
        }
        recordType.restFieldType = restType;
        return restType;
    }

    private BType getConstraint(BRecordType recordType) {
        if (recordType.sealed) {
            return this.symTable.neverType;
        }
        return recordType.restFieldType;
    }

    private BRecordType createAnonymousRecord(SymbolEnv env) {
        EnumSet<Flag> flags = EnumSet.of(Flag.PUBLIC, Flag.ANONYMOUS);
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(flags), Names.EMPTY, env.enclPkg.packageID, null, env.scope.owner, null, SymbolOrigin.VIRTUAL);
        recordSymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(env.enclPkg.packageID));
        BInvokableType bInvokableType = new BInvokableType(this.typeEnv(), List.of(), this.symTable.nilType, null);
        BInvokableSymbol initFuncSymbol = Symbols.createFunctionSymbol(1L, Names.EMPTY, Names.EMPTY, env.enclPkg.symbol.pkgID, bInvokableType, env.scope.owner, false, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        initFuncSymbol.retType = this.symTable.nilType;
        recordSymbol.scope = new Scope(recordSymbol);
        BRecordType recordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
        recordType.tsymbol = recordSymbol;
        recordSymbol.type = recordType;
        return recordType;
    }

    private BRecordType getEquivalentRecordType(BMapType mapType) {
        BRecordType equivalentRecordType = new BRecordType(this.symTable.typeEnv(), null);
        equivalentRecordType.sealed = false;
        equivalentRecordType.restFieldType = mapType.constraint;
        return equivalentRecordType;
    }

    private BErrorType createErrorType(BType lhsType, BType rhsType, BType detailType, SymbolEnv env) {
        BErrorType lhsErrorType = (BErrorType)lhsType;
        BErrorType rhsErrorType = (BErrorType)rhsType;
        BErrorType errorType = this.createErrorType(detailType, lhsType.getFlags() | rhsType.getFlags() | 1L, env);
        lhsErrorType.setDistinctId();
        rhsErrorType.setDistinctId();
        if (lhsErrorType.distinctId != -1) {
            errorType.distinctId = lhsErrorType.distinctId;
        } else if (rhsErrorType.distinctId != -1) {
            errorType.distinctId = rhsErrorType.distinctId;
        }
        errorType.typeIdSet = BTypeIdSet.getIntersection(lhsErrorType.typeIdSet, rhsErrorType.typeIdSet);
        return errorType;
    }

    public BErrorType createErrorType(BType detailType, long flags, SymbolEnv env) {
        String name = this.anonymousModelHelper.getNextAnonymousIntersectionErrorTypeName(env.enclPkg.packageID);
        BErrorTypeSymbol errorTypeSymbol = Symbols.createErrorSymbol(flags | 0x800L, Names.fromString(name), env.enclPkg.symbol.pkgID, null, env.scope.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        errorTypeSymbol.scope = new Scope(errorTypeSymbol);
        BErrorType errorType = new BErrorType(this.symTable.typeEnv(), (BTypeSymbol)errorTypeSymbol, detailType);
        errorType.addFlags(errorTypeSymbol.flags);
        errorTypeSymbol.type = errorType;
        errorType.typeIdSet = BTypeIdSet.emptySet();
        return errorType;
    }

    private boolean validateRecordFieldDefaultValueForIntersection(IntersectionContext diagnosticContext, BField field, BRecordType recordType) {
        if (field.symbol != null && field.symbol.isDefaultable && !diagnosticContext.ignoreDefaultValues) {
            diagnosticContext.logError(DiagnosticErrorCode.INTERSECTION_NOT_ALLOWED_WITH_TYPE, recordType, field.name);
            return false;
        }
        return true;
    }

    private void removeErrorFromReadonlyType(List<BType> remainingTypes) {
        ListIterator<BType> remainingIterator = remainingTypes.listIterator();
        boolean addAnyAndReadOnly = false;
        while (remainingIterator.hasNext()) {
            BType remainingType = (BType)remainingIterator.next();
            if (Types.getImpliedType((BType)remainingType).tag != 38) continue;
            remainingIterator.remove();
            addAnyAndReadOnly = true;
        }
        if (addAnyAndReadOnly) {
            remainingTypes.add(this.symTable.anyAndReadonly);
        }
    }

    private BType getRemainingType(BUnionType originalType, List<BType> removeTypes) {
        List<BType> remainingTypes = this.getAllTypes(originalType, true);
        boolean hasErrorToRemove = false;
        for (BType removeType : removeTypes) {
            remainingTypes.removeIf(type -> this.isAssignable((BType)type, removeType));
            if (hasErrorToRemove || Types.getImpliedType((BType)removeType).tag != 29) continue;
            hasErrorToRemove = true;
        }
        if (hasErrorToRemove) {
            this.removeErrorFromReadonlyType(remainingTypes);
        }
        ArrayList<BFiniteType> finiteTypesToRemove = new ArrayList<BFiniteType>();
        ArrayList<BType> finiteTypesToAdd = new ArrayList<BType>();
        for (BType remainingType : remainingTypes) {
            if (remainingType.tag != 33) continue;
            BFiniteType finiteType = (BFiniteType)remainingType;
            finiteTypesToRemove.add(finiteType);
            BType remainingTypeWithMatchesRemoved = this.getRemainingType(finiteType, removeTypes);
            if (remainingTypeWithMatchesRemoved == this.symTable.semanticError) continue;
            finiteTypesToAdd.add(remainingTypeWithMatchesRemoved);
        }
        remainingTypes.removeAll(finiteTypesToRemove);
        remainingTypes.addAll(finiteTypesToAdd);
        if (remainingTypes.size() == 1) {
            return remainingTypes.get(0);
        }
        if (remainingTypes.isEmpty()) {
            return this.symTable.nullSet;
        }
        return BUnionType.create(this.typeEnv(), null, new LinkedHashSet<BType>(remainingTypes));
    }

    private BType getRemainingType(BFiniteType originalType, List<BType> removeTypes) {
        BasicTypeBitSet removeSemType = PredefinedType.NEVER;
        for (BType bType : removeTypes) {
            removeSemType = SemTypes.union((SemType)removeSemType, (SemType)bType.semType());
        }
        ArrayList<SemNamedType> newValueSpace = new ArrayList<SemNamedType>();
        for (SemNamedType semNamedType : originalType.valueSpace) {
            if (SemTypes.isSubtype((Context)this.semTypeCtx, (SemType)semNamedType.semType(), (SemType)removeSemType)) continue;
            newValueSpace.add(semNamedType);
        }
        if (newValueSpace.isEmpty()) {
            return this.symTable.semanticError;
        }
        BTypeSymbol bTypeSymbol = Symbols.createTypeSymbol(557084L, originalType.tsymbol.flags, Names.fromString("$anonType$_" + this.finiteTypeCount++), originalType.tsymbol.pkgID, null, originalType.tsymbol.owner, originalType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        BFiniteType ft = new BFiniteType(bTypeSymbol, (SemNamedType[])newValueSpace.toArray(SemNamedType[]::new));
        bTypeSymbol.type = ft;
        return ft;
    }

    public SemType getNilLiftType(SemType t) {
        return Core.diff((SemType)t, (SemType)PredefinedType.NIL);
    }

    public SemType getErrorLiftType(SemType t) {
        return Core.diff((SemType)t, (SemType)PredefinedType.ERROR);
    }

    public SemType getNilAndErrorLiftType(SemType t) {
        return Core.diff((SemType)t, (SemType)Core.union((SemType)PredefinedType.NIL, (SemType)PredefinedType.ERROR));
    }

    public BType getSafeType(BType bType, boolean liftNil, boolean liftError) {
        BType type = Types.getImpliedType(bType);
        if (liftNil) {
            switch (type.tag) {
                case 7: {
                    return BJSONType.newNilLiftedBJSONType((BJSONType)type);
                }
                case 18: {
                    return BAnyType.newNilLiftedBAnyType();
                }
                case 11: {
                    return BAnydataType.newNilLiftedBAnydataType((BAnydataType)type);
                }
                case 38: {
                    if (liftError) {
                        return this.symTable.anyAndReadonly;
                    }
                    return BReadonlyType.newNilLiftedBReadonlyType();
                }
            }
        }
        if (type.tag != 21) {
            return bType;
        }
        BUnionType unionType = (BUnionType)type;
        LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>(unionType.getMemberTypes());
        BUnionType errorLiftedType = BUnionType.create(this.typeEnv(), null, memTypes);
        if (liftNil) {
            errorLiftedType.remove(this.symTable.nilType);
        }
        if (liftError) {
            LinkedHashSet<BType> bTypes = new LinkedHashSet<BType>();
            for (BType t : errorLiftedType.getMemberTypes()) {
                if (Types.getImpliedType((BType)t).tag == 29) continue;
                bTypes.add(t);
            }
            memTypes = bTypes;
            errorLiftedType = BUnionType.create(this.typeEnv(), null, memTypes);
        }
        if (((HashSet)errorLiftedType.getMemberTypes()).size() == 1) {
            return ((HashSet)errorLiftedType.getMemberTypes()).toArray(new BType[0])[0];
        }
        if (((HashSet)errorLiftedType.getMemberTypes()).isEmpty()) {
            return this.symTable.semanticError;
        }
        return errorLiftedType;
    }

    public List<BType> getAllTypes(BType type, boolean getReferenced) {
        if (type.tag != 21) {
            if (getReferenced && type.tag == 14) {
                return this.getAllTypes(((BTypeReferenceType)type).referredType, true);
            }
            if (getReferenced && type.tag == 22) {
                return this.getAllTypes(((BIntersectionType)type).effectiveType, true);
            }
            return Lists.of(type);
        }
        LinkedList<BType> memberTypes = new LinkedList<BType>();
        ((BUnionType)type).getMemberTypes().forEach(memberType -> memberTypes.addAll(this.getAllTypes((BType)memberType, true)));
        return memberTypes;
    }

    public boolean isAllowedConstantType(BType type) {
        type = Types.getImpliedType(type);
        return switch (type.tag) {
            case 1, 2, 3, 4, 5, 6, 10, 11, 18, 21, 39, 40, 41, 42, 43, 44 -> true;
            case 16 -> this.isAllowedConstantType(((BMapType)type).constraint);
            case 12 -> {
                for (BField field : ((BRecordType)type).fields.values()) {
                    if (!field.symbol.isDefaultable && this.isAllowedConstantType(field.type)) continue;
                    yield false;
                }
                yield true;
            }
            case 20 -> this.isAllowedConstantType(((BArrayType)type).eType);
            case 31 -> {
                for (BType memberType : ((BTupleType)type).getTupleTypes()) {
                    if (this.isAllowedConstantType(memberType)) continue;
                    yield false;
                }
                yield true;
            }
            case 33 -> this.isAllowedConstantType(SemTypeHelper.broadTypes(type.semType(), this.symTable).iterator().next());
            default -> false;
        };
    }

    public boolean isValidLiteral(BLangLiteral literal, BType targetType) {
        BType literalType = literal.getBType();
        if (literalType.tag == targetType.tag) {
            return true;
        }
        return switch (targetType.tag) {
            case 2 -> {
                if (literalType.tag == 1 && this.isByteLiteralValue((Long)literal.value)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (literalType.tag == 3 || literalType.tag == 1) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (literalType.tag == 1) {
                    yield true;
                }
                yield false;
            }
            case 39 -> {
                if (literalType.tag == 1 && this.isSigned32LiteralValue((Long)literal.value)) {
                    yield true;
                }
                yield false;
            }
            case 40 -> {
                if (literalType.tag == 1 && this.isSigned16LiteralValue((Long)literal.value)) {
                    yield true;
                }
                yield false;
            }
            case 41 -> {
                if (literalType.tag == 1 && this.isSigned8LiteralValue((Long)literal.value)) {
                    yield true;
                }
                yield false;
            }
            case 42 -> {
                if (literalType.tag == 1 && this.isUnsigned32LiteralValue((Long)literal.value)) {
                    yield true;
                }
                yield false;
            }
            case 43 -> {
                if (literalType.tag == 1 && this.isUnsigned16LiteralValue((Long)literal.value)) {
                    yield true;
                }
                yield false;
            }
            case 44 -> {
                if (literalType.tag == 1 && this.isUnsigned8LiteralValue((Long)literal.value)) {
                    yield true;
                }
                yield false;
            }
            case 45 -> {
                if (literalType.tag == 5 && this.isCharLiteralValue((String)literal.value)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void validateErrorOrNilReturn(BLangFunction function, DiagnosticCode diagnosticCode) {
        BType returnType = Types.getImpliedType(function.returnTypeNode.getBType());
        if (returnType.tag == 10 || returnType.tag == 21 && this.isSubTypeOfErrorOrNilContainingNil((BUnionType)returnType)) {
            return;
        }
        this.dlog.error(function.returnTypeNode.pos, diagnosticCode, function.returnTypeNode.getBType().toString());
    }

    public boolean isSubTypeOfErrorOrNilContainingNil(BUnionType type) {
        if (!type.isNullable()) {
            return false;
        }
        BasicTypeBitSet nilOrError = (BasicTypeBitSet)Core.union((SemType)PredefinedType.NIL, (SemType)PredefinedType.ERROR);
        return SemTypeHelper.isSubtypeSimpleNotNever(type, nilOrError);
    }

    public boolean hasFillerValue(BType type) {
        type = Types.getImpliedType(type);
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 49: {
                return true;
            }
            case 20: {
                return this.checkFillerValue((BArrayType)type);
            }
            case 33: {
                return this.hasFiller(type.semType());
            }
            case 21: {
                return this.checkFillerValue((BUnionType)type);
            }
            case 34: {
                return this.checkFillerValue((BObjectType)type);
            }
            case 12: {
                return this.checkFillerValue((BRecordType)type);
            }
            case 31: {
                BTupleType tupleType = (BTupleType)type;
                if (tupleType.isCyclic) {
                    return false;
                }
                return tupleType.getTupleTypes().stream().allMatch(eleType -> this.hasFillerValue((BType)eleType));
            }
        }
        return TypeTags.isIntegerTypeTag(type.tag);
    }

    private boolean checkFillerValue(BObjectType type) {
        if ((type.tsymbol.flags & 0x10000000L) != 0x10000000L) {
            return false;
        }
        BAttachedFunction initFunction = ((BObjectTypeSymbol)type.tsymbol).initializerFunc;
        if (initFunction == null) {
            return true;
        }
        if (initFunction.symbol.getReturnType().getKind() != TypeKind.NIL) {
            return false;
        }
        for (BVarSymbol bVarSymbol : initFunction.symbol.getParameters()) {
            if (bVarSymbol.isDefaultable) continue;
            return false;
        }
        return true;
    }

    private boolean hasFiller(SemType t) {
        if (Core.containsNil((SemType)t)) {
            return true;
        }
        return this.hasImplicitDefaultValue(t) || Core.singleShape((SemType)t).isPresent();
    }

    private boolean hasImplicitDefaultValue(SemType t) {
        BasicTypeBitSet bitSet = Core.widenToBasicTypes((SemType)t);
        Object value = null;
        if (bitSet.equals((Object)PredefinedType.BOOLEAN)) {
            value = false;
        } else if (bitSet.equals((Object)PredefinedType.INT)) {
            value = 0L;
        } else if (bitSet.equals((Object)PredefinedType.DECIMAL)) {
            value = BigDecimal.valueOf(0L);
        } else if (bitSet.equals((Object)PredefinedType.FLOAT)) {
            value = 0.0;
        } else if (bitSet.equals((Object)PredefinedType.STRING)) {
            value = "";
        }
        return value != null && (t instanceof BasicTypeBitSet || Core.containsConst((SemType)t, (Object)value));
    }

    private boolean checkFillerValue(BUnionType type) {
        if (type.isNullable()) {
            return true;
        }
        if (type.isCyclic) {
            return false;
        }
        HashSet<BType> memberTypes = new HashSet<BType>();
        boolean hasFillerValue = false;
        for (BType member : this.getAllTypes(type, true)) {
            if (member.tag == 33) {
                Set<BType> broadTypes = SemTypeHelper.broadTypes((BFiniteType)member, this.symTable);
                memberTypes.addAll(broadTypes);
                if (hasFillerValue || !this.hasImplicitDefaultValue(member.semType())) continue;
                hasFillerValue = true;
                continue;
            }
            memberTypes.add(member);
            if (hasFillerValue || !this.hasFillerValue(member)) continue;
            hasFillerValue = true;
        }
        if (!hasFillerValue) {
            return false;
        }
        Iterator iterator = memberTypes.iterator();
        BType firstMember = (BType)iterator.next();
        while (iterator.hasNext()) {
            if (this.isSameBasicType(firstMember, (BType)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSameBasicType(BType source, BType target) {
        if (this.isSameType(source, target)) {
            return true;
        }
        int sourceTag = Types.getImpliedType((BType)source).tag;
        int targetTag = Types.getImpliedType((BType)target).tag;
        if (TypeTags.isStringTypeTag(sourceTag) && TypeTags.isStringTypeTag(targetTag)) {
            return true;
        }
        if (TypeTags.isXMLTypeTag(sourceTag) && TypeTags.isXMLTypeTag(targetTag)) {
            return true;
        }
        return this.isIntegerSubTypeTag(sourceTag) && this.isIntegerSubTypeTag(targetTag);
    }

    private boolean isIntegerSubTypeTag(int typeTag) {
        return TypeTags.isIntegerTypeTag(typeTag) || typeTag == 2;
    }

    private boolean checkFillerValue(BRecordType type) {
        for (BField field : type.fields.values()) {
            if (Symbols.isFlagOn(field.symbol.flags, 4096L) || !Symbols.isFlagOn(field.symbol.flags, 256L)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFillerValue(BArrayType type) {
        if (type.getSize() == -1) {
            return true;
        }
        return this.hasFillerValue(type.eType);
    }

    public boolean isOrderedType(BType type) {
        return this.isOrderedType(type.semType());
    }

    public boolean isOrderedType(SemType t) {
        assert (!Core.isNever((SemType)t));
        SemType tButNil = Core.diff((SemType)t, (SemType)PredefinedType.NIL);
        BasicTypeBitSet basicTypeBitSet = Core.widenToBasicTypes((SemType)tButNil);
        if (SemTypes.isSubtypeSimple((SemType)basicTypeBitSet, (BasicTypeBitSet)PredefinedType.SIMPLE_OR_STRING)) {
            int bitCount = SemTypeHelper.bitCount(basicTypeBitSet.bitset);
            return bitCount <= 1;
        }
        if (SemTypes.isSubtypeSimple((SemType)tButNil, (BasicTypeBitSet)PredefinedType.LIST)) {
            ListMemberTypes lmTypes = Core.listAllMemberTypesInner((Context)this.typeCtx(), (SemType)t);
            for (SemType lmType : lmTypes.semTypes()) {
                if (this.isOrderedType(lmType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean comparable(BType t1, BType t2) {
        return this.comparable(t1.semType(), t2.semType());
    }

    boolean comparable(SemType t1, SemType t2) {
        assert (!Core.isNever((SemType)t1) && !Core.isNever((SemType)t2));
        if (PredefinedType.NIL.equals((Object)t1)) {
            return this.isOrderedType(t2);
        }
        if (PredefinedType.NIL.equals((Object)t2)) {
            return this.isOrderedType(t1);
        }
        SemType tButNil = Core.diff((SemType)Core.union((SemType)t1, (SemType)t2), (SemType)PredefinedType.NIL);
        BasicTypeBitSet basicTypeBitSet = Core.widenToBasicTypes((SemType)tButNil);
        if (SemTypes.isSubtypeSimple((SemType)basicTypeBitSet, (BasicTypeBitSet)PredefinedType.SIMPLE_OR_STRING)) {
            int bitCount = SemTypeHelper.bitCount(basicTypeBitSet.bitset);
            return bitCount <= 1;
        }
        if (SemTypes.isSubtypeSimple((SemType)tButNil, (BasicTypeBitSet)PredefinedType.LIST)) {
            return this.comparableNillableList(this.typeCtx(), t1, t2);
        }
        return false;
    }

    private boolean comparableNillableList(Context cx, SemType t1, SemType t2) {
        SemTypePair semPair = SemTypePair.from((SemType)t1, (SemType)t2);
        Boolean b = (Boolean)cx.comparableMemo.get(semPair);
        if (b != null) {
            return b;
        }
        ListMemberTypes lmTypes1 = Core.listAllMemberTypesInner((Context)cx, (SemType)t1);
        ListMemberTypes lmTypes2 = Core.listAllMemberTypesInner((Context)cx, (SemType)t2);
        CombinedRange[] combinedRanges = Core.combineRanges((Range[])((Range[])lmTypes1.ranges().toArray(Range[]::new)), (Range[])((Range[])lmTypes2.ranges().toArray(Range[]::new)));
        BasicTypeBitSet accum = PredefinedType.NIL;
        for (CombinedRange combinedRange : combinedRanges) {
            SemType lmType;
            Long i1 = combinedRange.i1();
            Long i2 = combinedRange.i2();
            if (i1 == null) {
                lmType = (SemType)lmTypes2.semTypes().get(Math.toIntExact(i2));
                if (!this.comparable((SemType)accum, lmType)) {
                    return false;
                }
                accum = Core.union((SemType)accum, (SemType)lmType);
                continue;
            }
            if (i2 == null) {
                lmType = (SemType)lmTypes1.semTypes().get(Math.toIntExact(i1));
                if (!this.comparable((SemType)accum, lmType)) {
                    return false;
                }
                accum = Core.union((SemType)accum, (SemType)lmType);
                continue;
            }
            if (this.comparable((SemType)lmTypes1.semTypes().get(Math.toIntExact(i1)), (SemType)lmTypes2.semTypes().get(Math.toIntExact(i2)))) continue;
            cx.comparableMemo.put(semPair, false);
            return false;
        }
        cx.comparableMemo.put(semPair, true);
        return true;
    }

    public boolean isSubTypeOfSimpleBasicTypeOrString(BType bType) {
        return this.isAssignable(Types.getImpliedType(bType), BUnionType.create(this.typeEnv(), null, this.symTable.nilType, this.symTable.booleanType, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType));
    }

    public BType findCompatibleType(BType type) {
        type = Types.getImpliedType(type);
        return switch (type.tag) {
            case 3, 4, 8, 46, 47, 48, 49 -> type;
            case 1, 2, 39, 40, 41, 42, 43, 44 -> this.symTable.intType;
            case 5, 45 -> this.symTable.stringType;
            case 21 -> {
                Set memberTypes = ((BUnionType)type).getMemberTypes();
                yield this.findCompatibleType((BType)((HashSet)memberTypes).iterator().next());
            }
            default -> {
                Set<BType> broadTypes = SemTypeHelper.broadTypes(type.semType(), this.symTable);
                if (!$assertionsDisabled && broadTypes.size() != 1) {
                    throw new AssertionError();
                }
                yield broadTypes.iterator().next();
            }
        };
    }

    public boolean isNonNilSimpleBasicTypeOrString(BType bType) {
        return SemTypeHelper.isSubtypeSimpleNotNever(bType, (BasicTypeBitSet)Core.diff((SemType)PredefinedType.SIMPLE_OR_STRING, (SemType)PredefinedType.NIL));
    }

    public boolean isSubTypeOfReadOnlyOrIsolatedObjectUnion(BType bType) {
        return SemTypes.isSubtype((Context)this.semTypeCtx, (SemType)bType.semType(), (SemType)SemTypes.union((SemType)PredefinedType.VAL_READONLY, (SemType)Core.createIsolatedObject((Context)this.semTypeCtx)));
    }

    private boolean isImmutable(BType type) {
        return Symbols.isFlagOn(type.getFlags(), 32L);
    }

    BType getTypeWithoutNil(BType type) {
        BType constraint = Types.getImpliedType(type);
        if (constraint.tag != 21) {
            return constraint;
        }
        BUnionType unionType = (BUnionType)constraint;
        if (!unionType.isNullable()) {
            return unionType;
        }
        ArrayList<BType> nonNilTypes = new ArrayList<BType>();
        for (BType memberType : unionType.getMemberTypes()) {
            if (this.isAssignable(memberType, this.symTable.nilType)) continue;
            nonNilTypes.add(memberType);
        }
        if (nonNilTypes.size() == 1) {
            return (BType)nonNilTypes.get(0);
        }
        return BUnionType.create(this.typeEnv(), null, new LinkedHashSet<BType>(nonNilTypes));
    }

    public boolean isFixedLengthTuple(BTupleType bTupleType) {
        return this.isFixedLengthList(bTupleType);
    }

    public boolean isFixedLengthList(BType type) {
        SemType rest = Core.listMemberTypeInnerVal((Context)this.semTypeCtx, (SemType)type.semType(), (SemType)IntSubtype.intConst((long)Long.MAX_VALUE));
        return Core.isNever((SemType)rest);
    }

    public boolean isNeverTypeOrStructureTypeWithARequiredNeverMember(BType type) {
        if (type == null) {
            return false;
        }
        HashSet<BType> visitedTypeSet = new HashSet<BType>();
        visitedTypeSet.add(type);
        return this.isNeverTypeOrStructureTypeWithARequiredNeverMember(type, visitedTypeSet);
    }

    boolean isNeverTypeOrStructureTypeWithARequiredNeverMember(BType type, Set<BType> visitedTypeSet) {
        switch (type.tag) {
            case 50: {
                return true;
            }
            case 12: {
                for (BField field : ((BRecordType)type).fields.values()) {
                    if (!SymbolFlags.isFlagOn((long)field.symbol.flags, (long)256L) && SymbolFlags.isFlagOn((long)field.symbol.flags, (long)4096L) || !visitedTypeSet.add(field.type) || !this.isNeverTypeOrStructureTypeWithARequiredNeverMember(field.type, visitedTypeSet)) continue;
                    return true;
                }
                return false;
            }
            case 31: {
                BTupleType tupleType = (BTupleType)type;
                List<BType> tupleTypes = tupleType.getTupleTypes();
                for (BType memType : tupleTypes) {
                    if (!visitedTypeSet.add(memType) || !this.isNeverTypeOrStructureTypeWithARequiredNeverMember(memType, visitedTypeSet)) continue;
                    return true;
                }
                return false;
            }
            case 20: {
                BArrayType arrayType = (BArrayType)type;
                visitedTypeSet.add(arrayType.eType);
                return arrayType.state != BArrayState.OPEN && this.isNeverTypeOrStructureTypeWithARequiredNeverMember(arrayType.eType, visitedTypeSet);
            }
            case 14: {
                visitedTypeSet.add(type);
                return this.isNeverTypeOrStructureTypeWithARequiredNeverMember(Types.getImpliedType(type), visitedTypeSet);
            }
            case 21: {
                BUnionType unionType = (BUnionType)type;
                for (BType memType : unionType.getMemberTypes()) {
                    if (this.isNeverTypeOrStructureTypeWithARequiredNeverMember(memType, visitedTypeSet)) continue;
                    return false;
                }
                return true;
            }
            case 22: {
                visitedTypeSet.add(type);
                return this.isNeverTypeOrStructureTypeWithARequiredNeverMember(((BIntersectionType)type).effectiveType, visitedTypeSet);
            }
        }
        return false;
    }

    public boolean isNeverType(BType type) {
        return Core.isNever((SemType)type.semType());
    }

    boolean isSingletonType(BType bType) {
        BType type = Types.getImpliedType(bType);
        return type.tag == 33 && Core.singleShape((SemType)type.semType()).isPresent();
    }

    boolean isSameSingletonType(BFiniteType type1, BFiniteType type2) {
        SemType t1 = type1.semType();
        SemType t2 = type2.semType();
        return SemTypes.isSameType((Context)this.semTypeCtx, (SemType)t1, (SemType)t2);
    }

    public static void addImmutableType(SymbolTable symTable, PackageID packageId, SelectivelyImmutableReferenceType type, BIntersectionType immutableType) {
        Map<String, Map<SelectivelyImmutableReferenceType, BIntersectionType>> immutableTypeMaps = symTable.immutableTypeMaps;
        String packageIdString = Types.getPackageIdString(packageId);
        Map<SelectivelyImmutableReferenceType, BIntersectionType> moduleImmutableTypeMap = immutableTypeMaps.get(packageIdString);
        if (moduleImmutableTypeMap == null) {
            moduleImmutableTypeMap = new HashMap<SelectivelyImmutableReferenceType, BIntersectionType>();
            immutableTypeMaps.put(packageIdString, moduleImmutableTypeMap);
        }
        moduleImmutableTypeMap.put(type, immutableType);
    }

    public static Optional<BIntersectionType> getImmutableType(SymbolTable symTable, PackageID packageId, SelectivelyImmutableReferenceType type) {
        Map<String, Map<SelectivelyImmutableReferenceType, BIntersectionType>> immutableTypeMaps = symTable.immutableTypeMaps;
        String packageIdString = Types.getPackageIdString(packageId);
        Map<SelectivelyImmutableReferenceType, BIntersectionType> moduleImmutableTypeMap = immutableTypeMaps.get(packageIdString);
        if (moduleImmutableTypeMap == null) {
            return Optional.empty();
        }
        if (moduleImmutableTypeMap.containsKey(type)) {
            return Optional.of(moduleImmutableTypeMap.get(type));
        }
        return Optional.empty();
    }

    public static Name getImmutableTypeName(String origName) {
        if (origName.isEmpty()) {
            return Names.EMPTY;
        }
        return Names.fromString("(".concat(origName).concat(AND_READONLY_SUFFIX).concat(")"));
    }

    public static String getPackageIdString(PackageID packageID) {
        return packageID.isTestPkg ? packageID.toString() + "_testable" : packageID.toString();
    }

    private void populateBasicTypes(BType type, Set<BasicTypes> basicTypes) {
        type = Types.getImpliedType(type);
        switch (type.tag) {
            case 1: 
            case 2: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                basicTypes.add(BasicTypes.INT);
                return;
            }
            case 3: {
                basicTypes.add(BasicTypes.FLOAT);
                return;
            }
            case 4: {
                basicTypes.add(BasicTypes.DECIMAL);
                return;
            }
            case 5: 
            case 45: {
                basicTypes.add(BasicTypes.STRING);
                return;
            }
            case 6: {
                basicTypes.add(BasicTypes.BOOLEAN);
                return;
            }
            case 8: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                basicTypes.add(BasicTypes.XML);
                return;
            }
            case 9: {
                basicTypes.add(BasicTypes.TABLE);
                return;
            }
            case 10: {
                basicTypes.add(BasicTypes.NIL);
                return;
            }
            case 12: 
            case 16: {
                basicTypes.add(BasicTypes.MAPPING);
                return;
            }
            case 13: {
                basicTypes.add(BasicTypes.TYPEDESC);
                return;
            }
            case 15: {
                basicTypes.add(BasicTypes.STREAM);
                return;
            }
            case 17: 
            case 36: {
                basicTypes.add(BasicTypes.FUNCTION);
                return;
            }
            case 20: 
            case 31: 
            case 35: {
                basicTypes.add(BasicTypes.LIST);
                return;
            }
            case 7: 
            case 11: 
            case 21: {
                for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                    this.populateBasicTypes(memberType, basicTypes);
                }
                return;
            }
            case 18: {
                basicTypes.add(BasicTypes.ANY);
                return;
            }
            case 29: {
                basicTypes.add(BasicTypes.ERROR);
                return;
            }
            case 30: 
            case 32: {
                basicTypes.add(BasicTypes.FUTURE);
                return;
            }
            case 34: {
                basicTypes.add(BasicTypes.OBJECT);
                return;
            }
            case 33: {
                SemType semType = type.semType();
                this.populateBasicTypes(semType, basicTypes);
                return;
            }
            case 37: {
                basicTypes.add(BasicTypes.HANDLE);
                return;
            }
            case 38: {
                basicTypes.add(BasicTypes.READONLY);
                return;
            }
            case 50: {
                basicTypes.add(BasicTypes.NEVER);
            }
        }
    }

    private void populateBasicTypes(SemType t, Set<BasicTypes> basicTypes) {
        int bitset;
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            bitset = b.bitset;
        } else {
            ComplexSemType cst = (ComplexSemType)t;
            bitset = cst.all() | cst.some();
        }
        if ((bitset & PredefinedType.NIL.bitset) != 0) {
            basicTypes.add(BasicTypes.NIL);
        }
        if ((bitset & PredefinedType.BOOLEAN.bitset) != 0) {
            basicTypes.add(BasicTypes.BOOLEAN);
        }
        if ((bitset & PredefinedType.INT.bitset) != 0) {
            basicTypes.add(BasicTypes.INT);
        }
        if ((bitset & PredefinedType.FLOAT.bitset) != 0) {
            basicTypes.add(BasicTypes.FLOAT);
        }
        if ((bitset & PredefinedType.DECIMAL.bitset) != 0) {
            basicTypes.add(BasicTypes.DECIMAL);
        }
        if ((bitset & PredefinedType.STRING.bitset) != 0) {
            basicTypes.add(BasicTypes.STRING);
        }
    }

    QueryConstructType getQueryConstructType(BLangQueryExpr queryExpr) {
        if (queryExpr.isMap) {
            return QueryConstructType.MAP;
        }
        if (queryExpr.isTable) {
            return QueryConstructType.TABLE;
        }
        if (queryExpr.isStream) {
            return QueryConstructType.STREAM;
        }
        return QueryConstructType.DEFAULT;
    }

    public byte[] convertToByteArray(String literalExpr) {
        String[] elements = Types.getLiteralTextValue(literalExpr);
        if (elements[0].contains(BASE_16)) {
            return this.hexStringToByteArray(elements[1]);
        }
        return Base64.getDecoder().decode(elements[1].getBytes(StandardCharsets.UTF_8));
    }

    private byte[] hexStringToByteArray(String base16String) {
        int arrayLength = base16String.length();
        byte[] byteArray = new byte[arrayLength / 2];
        for (int i = 0; i < arrayLength; i += 2) {
            byteArray[i / 2] = (byte)((Character.digit(base16String.charAt(i), 16) << 4) + Character.digit(base16String.charAt(i + 1), 16));
        }
        return byteArray;
    }

    private static String[] getLiteralTextValue(String literalExpr) {
        String nodeText = literalExpr.replace("\t", "").replace("\n", "").replace("\r", "").replace(" ", "");
        String[] result = new String[]{nodeText.substring(0, nodeText.indexOf(96)), nodeText.substring(nodeText.indexOf(96) + 1, nodeText.lastIndexOf(96))};
        return result;
    }

    public boolean isFunctionVarRef(BLangExpression expr) {
        return expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)expr).symbol != null && (((BLangSimpleVarRef)expr).symbol.tag & 0x334L) == 820L;
    }

    public boolean isCloneableType(BUnionType type) {
        Set cloneableMemberTypes = this.symTable.cloneableType.getMemberTypes();
        Iterator memItr = ((HashSet)type.getMemberTypes()).iterator();
        for (BType memberType : cloneableMemberTypes) {
            if (memItr.hasNext() && memberType.tag == ((BType)memItr.next()).tag) continue;
            return false;
        }
        return true;
    }

    public boolean isContainSubtypeOfInt(BType type) {
        return switch (type.tag) {
            case 2, 39, 40, 41, 42, 43, 44 -> true;
            case 21 -> {
                for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                    if (!this.isContainSubtypeOfInt(memberType)) continue;
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean isMappingConstructorCompatibleType(BType type) {
        int tag = Types.getImpliedType((BType)type).tag;
        return tag == 12 || tag == 16;
    }

    public Env typeEnv() {
        return this.semTypeCtx.env;
    }

    public Context typeCtx() {
        return this.semTypeCtx;
    }

    public static class IntersectionContext {
        Location lhsPos;
        Location rhsPos;
        Location pos;
        BLangDiagnosticLog dlog;
        ContextOption contextOption;
        boolean ignoreDefaultValues;
        boolean createTypeDefs;
        boolean preferNonGenerativeIntersection;

        private IntersectionContext(BLangDiagnosticLog diaglog, Location left, Location right) {
            this.dlog = diaglog;
            this.lhsPos = left;
            this.rhsPos = right;
            this.contextOption = ContextOption.NON;
            this.ignoreDefaultValues = false;
            this.createTypeDefs = true;
            this.preferNonGenerativeIntersection = false;
        }

        private IntersectionContext(BLangDiagnosticLog diaglog, Location left, Location right, Location pos) {
            this(diaglog, left, right);
            this.pos = pos;
        }

        public static IntersectionContext from(BLangDiagnosticLog diaglog, Location left, Location right) {
            return new IntersectionContext(diaglog, left, right);
        }

        public static IntersectionContext compilerInternalIntersectionTestContext() {
            IntersectionContext intersectionContext = new IntersectionContext(null, null, null);
            intersectionContext.ignoreDefaultValues = true;
            intersectionContext.createTypeDefs = false;
            return intersectionContext;
        }

        public static IntersectionContext compilerInternalIntersectionContext() {
            IntersectionContext diagnosticContext = new IntersectionContext(null, null, null);
            return diagnosticContext;
        }

        public static IntersectionContext compilerInternalIntersectionContext(Location intersectionPos) {
            return new IntersectionContext(null, null, null, intersectionPos);
        }

        public static IntersectionContext typeTestIntersectionExistenceContext(Location intersectionPos) {
            IntersectionContext intersectionContext = new IntersectionContext(null, null, null, intersectionPos);
            intersectionContext.ignoreDefaultValues = true;
            intersectionContext.preferNonGenerativeIntersection = true;
            intersectionContext.createTypeDefs = false;
            return intersectionContext;
        }

        public static IntersectionContext typeTestIntersectionCalculationContext() {
            IntersectionContext intersectionContext = new IntersectionContext(null, null, null);
            intersectionContext.ignoreDefaultValues = true;
            intersectionContext.preferNonGenerativeIntersection = true;
            intersectionContext.createTypeDefs = true;
            return intersectionContext;
        }

        public static IntersectionContext typeTestIntersectionCalculationContext(Location intersectionPos) {
            IntersectionContext intersectionContext = IntersectionContext.typeTestIntersectionCalculationContext();
            intersectionContext.pos = intersectionPos;
            return intersectionContext;
        }

        public static IntersectionContext matchClauseIntersectionContextForMapping() {
            IntersectionContext intersectionContext = new IntersectionContext(null, null, null);
            intersectionContext.ignoreDefaultValues = true;
            return intersectionContext;
        }

        public IntersectionContext switchLeft() {
            this.contextOption = ContextOption.LEFT;
            return this;
        }

        public IntersectionContext switchRight() {
            this.contextOption = ContextOption.RIGHT;
            return this;
        }

        private boolean logError(DiagnosticErrorCode diagnosticCode, Object ... args) {
            Location pos = null;
            if (this.contextOption == ContextOption.LEFT && this.lhsPos != null) {
                pos = this.lhsPos;
            } else if (this.contextOption == ContextOption.RIGHT && this.rhsPos != null) {
                pos = this.rhsPos;
            }
            if (pos != null) {
                this.dlog.error(pos, diagnosticCode, args);
                return true;
            }
            return false;
        }
    }

    static enum TypeTestResult {
        NOT_FOUND,
        TRUE,
        FALSE;

    }

    private class ListenerValidationModel {
        private final Types types;
        private final SymbolTable symtable;
        private final BType serviceNameType;
        boolean attachFound;
        boolean detachFound;
        boolean startFound;
        boolean gracefulStopFound;
        boolean immediateStopFound;

        public ListenerValidationModel(Types types2, SymbolTable symTable) {
            this.types = types2;
            this.symtable = symTable;
            this.serviceNameType = BUnionType.create(symTable.typeEnv(), null, this.symtable.stringType, this.symtable.arrayStringType, this.symtable.nilType);
        }

        boolean isValidListener() {
            return this.attachFound && this.detachFound && this.startFound && this.gracefulStopFound && this.immediateStopFound;
        }

        private boolean checkMethods(List<BAttachedFunction> rhsFuncs) {
            for (BAttachedFunction func : rhsFuncs) {
                switch (func.funcName.value) {
                    case "attach": {
                        if (this.checkAttachMethod(func)) break;
                        return false;
                    }
                    case "detach": {
                        if (this.checkDetachMethod(func)) break;
                        return false;
                    }
                    case "start": {
                        if (this.checkStartMethod(func)) break;
                        return true;
                    }
                    case "gracefulStop": {
                        if (this.checkGracefulStop(func)) break;
                        return false;
                    }
                    case "immediateStop": {
                        if (this.checkImmediateStop(func)) break;
                        return false;
                    }
                }
            }
            return this.isValidListener();
        }

        private boolean emptyParamList(BAttachedFunction func) {
            return func.type.paramTypes.isEmpty() && func.type.restType != this.symtable.noType;
        }

        private boolean publicAndReturnsErrorOrNil(BAttachedFunction func) {
            if (!Symbols.isPublic(func.symbol)) {
                return false;
            }
            return this.types.isAssignable(func.type.retType, this.symtable.errorOrNilType);
        }

        private boolean isPublicNoParamReturnsErrorOrNil(BAttachedFunction func) {
            if (!this.publicAndReturnsErrorOrNil(func)) {
                return false;
            }
            return this.emptyParamList(func);
        }

        private boolean checkImmediateStop(BAttachedFunction func) {
            this.immediateStopFound = this.isPublicNoParamReturnsErrorOrNil(func);
            return this.immediateStopFound;
        }

        private boolean checkGracefulStop(BAttachedFunction func) {
            this.gracefulStopFound = this.isPublicNoParamReturnsErrorOrNil(func);
            return this.gracefulStopFound;
        }

        private boolean checkStartMethod(BAttachedFunction func) {
            this.startFound = this.publicAndReturnsErrorOrNil(func);
            return this.startFound;
        }

        private boolean checkDetachMethod(BAttachedFunction func) {
            if (!this.publicAndReturnsErrorOrNil(func)) {
                return false;
            }
            if (func.type.paramTypes.size() != 1) {
                return false;
            }
            this.detachFound = this.isServiceObject(func.type.paramTypes.get(0));
            return this.detachFound;
        }

        private boolean checkAttachMethod(BAttachedFunction func) {
            boolean sameType;
            if (!this.publicAndReturnsErrorOrNil(func)) {
                return false;
            }
            if (func.type.paramTypes.size() != 2) {
                return false;
            }
            BType firstParamType = func.type.paramTypes.get(0);
            if (!this.isServiceObject(firstParamType)) {
                return false;
            }
            BType secondParamType = func.type.paramTypes.get(1);
            this.attachFound = sameType = this.types.isAssignable(secondParamType, this.serviceNameType);
            return this.attachFound;
        }

        private boolean isServiceObject(BType bType) {
            return this.types.isSubtype(bType, Core.createServiceObject((Context)Types.this.semTypeCtx));
        }
    }

    private static enum BasicTypes {
        NIL,
        BOOLEAN,
        INT,
        FLOAT,
        DECIMAL,
        STRING,
        XML,
        LIST,
        MAPPING,
        TABLE,
        ERROR,
        FUNCTION,
        FUTURE,
        OBJECT,
        TYPEDESC,
        HANDLE,
        STREAM,
        READONLY,
        ANY,
        NEVER,
        ANYDATA,
        JSON;

    }

    static enum QueryConstructType {
        DEFAULT,
        STREAM,
        MAP,
        TABLE,
        ACTION;

    }

    public static class CommonAnalyzerData {
        Deque<SymbolEnv> queryEnvs = new ArrayDeque<SymbolEnv>();
        Deque<BLangNode> queryFinalClauses = new ArrayDeque<BLangNode>();
        HashSet<BType> checkedErrorList = new HashSet();
        boolean breakToParallelQueryEnv = false;
        int letCount = 0;
        boolean nonErrorLoggingCheck = false;
        Deque<LinkedHashSet<BType>> errorTypes = new ArrayDeque<LinkedHashSet<BType>>();
    }

    private static enum ContextOption {
        LEFT,
        RIGHT,
        NON;

    }
}

