/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.ballerinalang.model.symbols.InvokableSymbol;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;

public class BInvokableSymbol
extends BVarSymbol
implements InvokableSymbol {
    public List<BVarSymbol> params;
    public BVarSymbol restParam;
    public BType retType;
    public Map<String, BType> paramDefaultValTypes;
    public BVarSymbol receiverSymbol;
    public boolean bodyExist;
    protected List<BAnnotationAttachmentSymbol> annotationAttachmentsOnExternal;
    public String enclForkName;
    public String source;
    public String strandName = null;
    public SchedulerPolicy schedulerPolicy = SchedulerPolicy.PARENT;
    public Set<BVarSymbol> dependentGlobalVars;

    public BInvokableSymbol(long tag, long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        this(tag, flags, name, name, pkgID, type, owner, pos, origin);
    }

    public BInvokableSymbol(long tag, long flags, Name name, Name originalName, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        super(flags, name, originalName, pkgID, type, owner, pos, origin);
        this.tag = tag;
        this.params = new ArrayList<BVarSymbol>();
        this.annotationAttachments = new ArrayList();
        this.dependentGlobalVars = new HashSet<BVarSymbol>();
        this.paramDefaultValTypes = new HashMap<String, BType>();
        this.kind = SymbolKind.FUNCTION;
    }

    public List<BVarSymbol> getParameters() {
        return this.params;
    }

    @Override
    public BInvokableType getType() {
        BType bType = this.type;
        if (bType instanceof BInvokableType) {
            BInvokableType bInvokableType = (BInvokableType)bType;
            return bInvokableType;
        }
        throw new BLangCompilerException("Invokable symbol with non invokable type : " + String.valueOf(this.type));
    }

    @Override
    public BType getReturnType() {
        return this.retType;
    }

    public void setAnnotationAttachments(List<BAnnotationAttachmentSymbol> annotationAttachments) {
        this.annotationAttachments = annotationAttachments;
    }

    public void setAnnotationAttachmentsOnExternal(List<BAnnotationAttachmentSymbol> annotationAttachments) {
        this.annotationAttachmentsOnExternal = annotationAttachments;
    }

    public List<? extends AnnotationAttachmentSymbol> getAnnotationAttachmentsOnExternal() {
        return this.annotationAttachmentsOnExternal;
    }
}

