/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.ballerinalang.model.types.ErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BErrorType
extends BType
implements ErrorType {
    public BType detailType;
    public BTypeIdSet typeIdSet;
    private static final String DOLLAR = "$";
    private static final String ERROR = "error<";
    private static final String CLOSE_ERROR = ">";
    private final Env env;
    public int distinctId = -1;
    private final DistinctIdSupplier distinctIdSupplier;

    public BErrorType(Env env, BTypeSymbol tSymbol, BType detailType) {
        super(29, tSymbol, 32L);
        this.detailType = detailType;
        this.typeIdSet = BTypeIdSet.emptySet();
        this.env = env;
        this.distinctIdSupplier = new DistinctIdSupplier(env);
    }

    public BErrorType(Env env, BTypeSymbol tSymbol) {
        super(29, tSymbol, 32L);
        this.typeIdSet = BTypeIdSet.emptySet();
        this.env = env;
        this.distinctIdSupplier = new DistinctIdSupplier(env);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public BType getDetailType() {
        return this.detailType;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.tsymbol != null && this.tsymbol.name != null && !this.tsymbol.name.value.startsWith(DOLLAR) && !this.tsymbol.name.value.isEmpty()) {
            return String.valueOf(this.tsymbol);
        }
        return ERROR + String.valueOf(this.detailType) + CLOSE_ERROR;
    }

    public void setDistinctId() {
        if (Symbols.isFlagOn(this.getFlags(), 0x8000000L)) {
            this.distinctId = this.env.distinctAtomCountGetAndIncrement();
        }
    }

    @Override
    public SemType semType() {
        return this.distinctIdWrapper(this.semTypeInner());
    }

    SemType distinctIdWrapper(SemType semTypeInner) {
        return this.distinctIdSupplier.get().stream().map(SemTypes::errorDistinct).reduce(semTypeInner, Core::intersect);
    }

    private SemType semTypeInner() {
        if (this.semType != null) {
            return this.semType;
        }
        if (this.detailType == null || this.detailType.semType() == null) {
            this.semType = PredefinedType.ERROR;
        } else {
            SemType detail = this.detailType.semType();
            this.semType = SemTypes.errorDetail((SemType)detail);
        }
        return this.semType;
    }

    private final class DistinctIdSupplier
    implements Supplier<List<Integer>> {
        private List<Integer> ids = null;
        private static final Map<Env, Map<BTypeIdSet.BTypeId, Integer>> allocatedIds = Collections.synchronizedMap(new WeakHashMap());
        private final Env env;

        private DistinctIdSupplier(Env env) {
            this.env = env;
            allocatedIds.putIfAbsent(env, new ConcurrentHashMap());
        }

        @Override
        public synchronized List<Integer> get() {
            if (this.ids != null) {
                return this.ids;
            }
            Map<BTypeIdSet.BTypeId, Integer> envAllocatedIds = allocatedIds.get(this.env);
            this.ids = BErrorType.this.typeIdSet.getAll().stream().map(each -> envAllocatedIds.computeIfAbsent((BTypeIdSet.BTypeId)each, key -> this.env.distinctAtomCountGetAndIncrement())).toList();
            return this.ids;
        }
    }
}

