/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import java.util.LinkedHashSet;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class BJSONType
extends BUnionType {
    private boolean nullable = true;
    private static final int INITIAL_CAPACITY = 8;
    private final Context typeCtx;

    public BJSONType(Context typeCtx, BUnionType type) {
        super(type.env, type.tsymbol, new LinkedHashSet<BType>(8), Symbols.isFlagOn(type.getFlags(), 32L));
        this.mergeUnionType(type);
        this.tag = 7;
        this.isCyclic = true;
        this.typeCtx = typeCtx;
    }

    private BJSONType(Context typeCtx, BTypeSymbol typeSymbol, boolean nullable, long flags) {
        super(typeCtx.env, typeSymbol, new LinkedHashSet<BType>(8), Symbols.isFlagOn(flags, 32L));
        this.setFlags(flags);
        this.tag = 7;
        this.isCyclic = true;
        this.nullable = nullable;
        this.typeCtx = typeCtx;
    }

    public static BJSONType newNilLiftedBJSONType(BJSONType type) {
        BJSONType result = new BJSONType(type.typeCtx, type);
        result.nullable = false;
        return result;
    }

    public static BJSONType newImmutableBJSONType(BJSONType type, BTypeSymbol typeSymbol, boolean nullable) {
        return new BJSONType(type.typeCtx, typeSymbol, nullable, type.getFlags() | 0x20L);
    }

    @Override
    public String toString() {
        return !Symbols.isFlagOn(this.getFlags(), 32L) ? this.getKind().typeName() : this.getKind().typeName().concat(" & readonly");
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.JSON;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public SemType semType() {
        SemType json = Core.createJson((Context)this.typeCtx);
        if (Symbols.isFlagOn(this.getFlags(), 32L)) {
            json = Core.intersect((SemType)json, (SemType)PredefinedType.VAL_READONLY);
        }
        return json;
    }
}

