/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Core;
import io.ballerina.types.SemType;
import org.ballerinalang.model.Name;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.types.ValueType;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.Names;

public class BType
implements ValueType {
    public int tag;
    public BTypeSymbol tsymbol;
    public Name name;
    private long flags;
    protected SemType semType;

    public BType(int tag, BTypeSymbol tsymbol) {
        this(tag, tsymbol, Names.EMPTY, 0L, null);
    }

    public BType(int tag, BTypeSymbol tsymbol, SemType semType) {
        this(tag, tsymbol, Names.EMPTY, 0L, semType);
    }

    public BType(int tag, BTypeSymbol tsymbol, long flags) {
        this(tag, tsymbol, Names.EMPTY, flags, null);
    }

    public BType(int tag, BTypeSymbol tsymbol, Name name, long flags) {
        this(tag, tsymbol, name, flags, null);
    }

    public BType(int tag, BTypeSymbol tsymbol, long flags, SemType semType) {
        this(tag, tsymbol, Names.EMPTY, flags, semType);
    }

    public BType(int tag, BTypeSymbol tsymbol, Name name, long flags, SemType semType) {
        this.tag = tag;
        this.tsymbol = tsymbol;
        this.name = name;
        this.flags = flags;
        this.semType = semType;
    }

    public static BType createNilType() {
        return new BNilType();
    }

    public static BType createNeverType() {
        return new BNeverType();
    }

    public SemType semType() {
        return this.semType;
    }

    public void semType(SemType semtype) {
        this.semType = semtype;
    }

    public BType getReturnType() {
        return null;
    }

    public boolean isNullable() {
        return Core.containsNil((SemType)this.semType());
    }

    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        return switch (this.tag) {
            case 1 -> TypeKind.INT;
            case 2 -> TypeKind.BYTE;
            case 3 -> TypeKind.FLOAT;
            case 4 -> TypeKind.DECIMAL;
            case 5 -> TypeKind.STRING;
            case 6 -> TypeKind.BOOLEAN;
            case 13 -> TypeKind.TYPEDESC;
            case 10 -> TypeKind.NIL;
            case 50 -> TypeKind.NEVER;
            case 29 -> TypeKind.ERROR;
            case 38 -> TypeKind.READONLY;
            case 52 -> TypeKind.PARAMETERIZED;
            default -> TypeKind.OTHER;
        };
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getKind().typeName();
    }

    public String getQualifiedTypeName() {
        return this.tsymbol.pkgID.toString() + ":" + String.valueOf(this.tsymbol.name);
    }

    public final long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public void addFlags(long flags) {
        this.flags |= flags;
        this.resetSemType();
    }

    public void resetSemType() {
    }

    public static class NarrowedTypes {
        public BType trueType;
        public BType falseType;

        public NarrowedTypes(BType trueType, BType falseType) {
            this.trueType = trueType;
            this.falseType = falseType;
        }

        public String toString() {
            return "(" + String.valueOf(this.trueType) + ", " + String.valueOf(this.falseType) + ")";
        }
    }
}

