/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;

public class BTypeIdSet {
    private final List<Set<BTypeId>> primary = new ArrayList<Set<BTypeId>>();
    private final List<Set<BTypeId>> secondary = new ArrayList<Set<BTypeId>>();
    private Set<BTypeId> primaryAll = null;
    private Set<BTypeId> secondaryAll = null;
    private Set<BTypeId> all = null;

    public BTypeIdSet(Set<BTypeId> primary, Set<BTypeId> secondary) {
        this();
        this.primary.add(primary);
        this.secondary.add(secondary);
    }

    public BTypeIdSet() {
    }

    public static BTypeIdSet from(PackageID packageID, String typeId, boolean publicId) {
        HashSet<BTypeId> set = new HashSet<BTypeId>();
        set.add(new BTypeId(packageID, typeId, publicId));
        BTypeIdSet typeIdSet = new BTypeIdSet();
        typeIdSet.addPrimarySet(set);
        return typeIdSet;
    }

    public static BTypeIdSet from(PackageID packageID, String typeId, boolean publicId, BTypeIdSet secondary) {
        BTypeIdSet newSet = BTypeIdSet.from(packageID, typeId, publicId);
        newSet.secondary.addAll(secondary.primary);
        newSet.secondary.addAll(secondary.secondary);
        return newSet;
    }

    public BTypeIdSet addPrimarySet(Set<BTypeId> set) {
        this.primary.add(set);
        this.invalidateCache();
        return this;
    }

    public BTypeIdSet addSecondarySet(Set<BTypeId> set) {
        this.secondary.add(set);
        this.invalidateCache();
        return this;
    }

    public BTypeIdSet add(BTypeIdSet that) {
        this.primary.addAll(that.primary);
        this.secondary.addAll(that.secondary);
        this.invalidateCache();
        return this;
    }

    public static BTypeIdSet emptySet() {
        return new BTypeIdSet();
    }

    public Set<BTypeId> getPrimary() {
        if (this.primaryAll == null) {
            HashSet<BTypeId> set = new HashSet<BTypeId>();
            for (Set<BTypeId> bTypeIds : this.primary) {
                set.addAll(bTypeIds);
            }
            this.primaryAll = Collections.unmodifiableSet(set);
        }
        return this.primaryAll;
    }

    public Set<BTypeId> getSecondary() {
        if (this.secondaryAll == null) {
            HashSet<BTypeId> set = new HashSet<BTypeId>();
            for (Set<BTypeId> bTypeIds : this.secondary) {
                set.addAll(bTypeIds);
            }
            this.secondaryAll = Collections.unmodifiableSet(set);
        }
        return this.secondaryAll;
    }

    public Set<BTypeId> getAll() {
        if (this.all == null) {
            HashSet<BTypeId> all = new HashSet<BTypeId>();
            all.addAll(this.getPrimary());
            all.addAll(this.getSecondary());
            this.all = all;
        }
        return this.all;
    }

    private void invalidateCache() {
        this.all = null;
        this.primaryAll = null;
        this.secondaryAll = null;
    }

    public static BTypeIdSet getIntersection(BTypeIdSet lhsTypeIds, BTypeIdSet rhsTypeIds) {
        if (lhsTypeIds.isEmpty() && rhsTypeIds.isEmpty()) {
            return BTypeIdSet.emptySet();
        }
        BTypeIdSet typeIdSet = new BTypeIdSet();
        typeIdSet.primary.addAll(lhsTypeIds.primary);
        typeIdSet.primary.addAll(rhsTypeIds.primary);
        typeIdSet.secondary.addAll(lhsTypeIds.secondary);
        typeIdSet.secondary.addAll(rhsTypeIds.secondary);
        return typeIdSet;
    }

    public boolean isAssignableFrom(BTypeIdSet sourceTypeIdSet) {
        if (sourceTypeIdSet == null) {
            return false;
        }
        if (sourceTypeIdSet == this) {
            return true;
        }
        return sourceTypeIdSet.getAll().containsAll(this.getAll());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BTypeIdSet)) {
            return false;
        }
        BTypeIdSet that = (BTypeIdSet)obj;
        return this.primary.equals(that.primary) && this.secondary.equals(that.secondary);
    }

    public int hashCode() {
        int hashCode = 1;
        for (BTypeId bTypeId : this.getPrimary()) {
            hashCode = hashCode * 31 + bTypeId.hashCode();
        }
        for (BTypeId bTypeId : this.getSecondary()) {
            hashCode = hashCode * 31 + bTypeId.hashCode();
        }
        return hashCode;
    }

    public boolean isEmpty() {
        return this.getAll().isEmpty();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (BTypeId id : this.getAll()) {
            joiner.add(id.toString());
        }
        return joiner.toString();
    }

    public static class BTypeId {
        public final PackageID packageID;
        public final String name;
        public final boolean publicId;

        public BTypeId(PackageID packageID, String name, boolean publicId) {
            this.packageID = packageID;
            this.name = name;
            this.publicId = publicId;
        }

        public int hashCode() {
            return CompilerUtils.getPackageIDStringWithMajorVersion(this.packageID).hashCode() * 31 + this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BTypeId) {
                BTypeId that = (BTypeId)obj;
                return this.name.equals(that.name) && CompilerUtils.getPackageIDStringWithMajorVersion(this.packageID).equals(CompilerUtils.getPackageIDStringWithMajorVersion(that.packageID));
            }
            return false;
        }

        public String toString() {
            return "BTypeId { " + this.packageID.toString() + "/" + this.name + "}";
        }
    }
}

