/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.ImportPackageNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;

public class BLangImportPackage
extends BLangNode
implements ImportPackageNode {
    public BLangIdentifier orgName;
    public List<BLangIdentifier> pkgNameComps;
    public BLangIdentifier alias;
    public BLangIdentifier compUnit;
    public BLangIdentifier version;
    public BPackageSymbol symbol;

    public List<BLangIdentifier> getPackageName() {
        return this.pkgNameComps;
    }

    @Override
    public void setPackageName(List<? extends IdentifierNode> nameParts) {
        this.pkgNameComps = new ArrayList<BLangIdentifier>();
        this.pkgNameComps.add((BLangIdentifier)((Object)nameParts));
    }

    @Override
    public IdentifierNode getPackageVersion() {
        return this.version;
    }

    @Override
    public void setPackageVersion(IdentifierNode version) {
        this.version = (BLangIdentifier)version;
    }

    @Override
    public BLangIdentifier getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(IdentifierNode alias) {
        this.alias = (BLangIdentifier)alias;
    }

    @Override
    public IdentifierNode getOrgName() {
        return this.orgName;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.IMPORT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BLangImportPackage that = (BLangImportPackage)o;
        if (this.pkgNameComps != null ? !this.pkgNameComps.equals(that.pkgNameComps) : that.pkgNameComps != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return this.alias.equals(that.alias);
    }

    public int hashCode() {
        int result = this.pkgNameComps != null ? this.pkgNameComps.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "import " + this.getQualifiedPackageName();
    }

    public String getQualifiedPackageName() {
        Object versionStr;
        String orgName = this.orgName.toString();
        String pkgName = String.join((CharSequence)".", this.pkgNameComps.stream().map(id -> id.value).toList());
        Object object = versionStr = this.version.value != null ? this.version.value : "";
        if (!((String)versionStr).isEmpty()) {
            versionStr = " version " + (String)versionStr;
        }
        String aliasStr = this.alias.value != null && !this.alias.value.equals(pkgName) ? " as " + this.alias.value : "";
        return (String)(orgName.isEmpty() ? "" : orgName + "/") + pkgName + (String)versionStr + aliasStr;
    }
}

