/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.ArrayTypeNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class BLangArrayType
extends BLangType
implements ArrayTypeNode {
    public BLangType elemtype;
    public List<BLangExpression> sizes = new ArrayList<BLangExpression>();
    public int dimensions;

    @Override
    public BLangType getElementType() {
        return this.elemtype;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public BLangExpression[] getSizes() {
        return this.sizes.toArray(new BLangExpression[0]);
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    public String toString() {
        StringBuilder[] sb = new StringBuilder[]{new StringBuilder(this.getTypeName())};
        if (this.sizes.isEmpty()) {
            this.sizes.forEach(size -> {
                if (size.getKind() == NodeKind.NUMERIC_LITERAL) {
                    Integer sizeIndicator = (Integer)((BLangLiteral)size).getValue();
                    if (sizeIndicator == -1) {
                        sb[0].append("[]");
                    } else {
                        sb[0].append("[").append(sizeIndicator).append("]");
                    }
                } else {
                    sb[0].append("[").append(((BLangSimpleVarRef)size).variableName).append("]");
                }
            });
        } else {
            sb[0].append(String.join((CharSequence)"", Collections.nCopies(this.dimensions, "[]")));
        }
        return sb[0].toString();
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ARRAY_TYPE;
    }

    private String getTypeName() {
        return this.elemtype instanceof BLangUserDefinedType ? ((BLangUserDefinedType)this.elemtype).typeName.value : this.elemtype.toString();
    }
}

