/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.types.StructureTypeNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;

public abstract class BLangStructureTypeNode
extends BLangType
implements StructureTypeNode {
    public List<BLangSimpleVariable> fields;
    public List<BLangType> typeRefs;
    public boolean isAnonymous;
    public boolean isLocal;
    public boolean referencedFieldsDefined;
    public BSymbol symbol;
    public List<BLangSimpleVariable> includedFields;
    public SymbolEnv typeDefEnv;

    public BLangStructureTypeNode() {
        this.fields = new ArrayList<BLangSimpleVariable>();
        this.typeRefs = new ArrayList<BLangType>();
        this.includedFields = new ArrayList<BLangSimpleVariable>();
    }

    public BLangStructureTypeNode(int includedFieldCount) {
        this.includedFields = new ArrayList<BLangSimpleVariable>(includedFieldCount);
    }

    @Override
    public List<? extends SimpleVariableNode> getFields() {
        return this.fields;
    }

    @Override
    public void addField(SimpleVariableNode field) {
        this.fields.add((BLangSimpleVariable)field);
    }

    @Override
    public List<? extends TypeNode> getTypeReferences() {
        return Collections.unmodifiableList(this.typeRefs);
    }

    @Override
    public void addTypeReference(TypeNode type) {
        this.typeRefs.add((BLangType)type);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.RECORD_TYPE;
    }

    @Override
    public boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    @Override
    public boolean getIsLocal() {
        return this.isLocal;
    }

    public String toString() {
        return "record { " + String.valueOf(this.fields) + " }";
    }
}

