/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class Names {
    public static final CompilerContext.Key<Names> NAMES_KEY = new CompilerContext.Key();
    public static final String STRING_SIGNED32 = "Signed32";
    public static final String STRING_SIGNED16 = "Signed16";
    public static final String STRING_SIGNED8 = "Signed8";
    public static final String STRING_UNSIGNED32 = "Unsigned32";
    public static final String STRING_UNSIGNED16 = "Unsigned16";
    public static final String STRING_UNSIGNED8 = "Unsigned8";
    public static final String STRING_CHAR = "Char";
    public static final String STRING_XML_ELEMENT = "Element";
    public static final String STRING_XML_PI = "ProcessingInstruction";
    public static final String STRING_XML_COMMENT = "Comment";
    public static final String STRING_XML_TEXT = "Text";
    public static final String STRING_REGEXP = "RegExp";
    public static final Name EMPTY = new Name("");
    public static final Name DOT;
    public static final Name DEFAULT_PACKAGE;
    public static final Name TEST_PACKAGE;
    public static final Name BALLERINA_ORG;
    public static final Name BALLERINA_INTERNAL_ORG;
    public static final Name LANG;
    public static final Name INTERNAL;
    public static final Name ANNOTATIONS;
    public static final Name JAVA;
    public static final Name ARRAY;
    public static final Name DECIMAL;
    public static final Name ERROR;
    public static final Name FLOAT;
    public static final Name FUNCTION;
    public static final Name FUTURE;
    public static final Name INT;
    public static final Name BOOLEAN;
    public static final Name MAP;
    public static final Name NATURAL;
    public static final Name OBJECT;
    public static final Name STREAM;
    public static final Name QUERY;
    public static final Name RUNTIME;
    public static final Name TRANSACTION;
    public static final Name NATURAL_PROGRAMMING;
    public static final Name OBSERVE;
    public static final Name CLOUD;
    public static final Name TABLE;
    public static final Name TEST;
    public static final Name TYPEDESC;
    public static final Name STRING;
    public static final Name VALUE;
    public static final Name XML;
    public static final Name JSON;
    public static final Name ANYDATA;
    public static final Name REGEXP;
    public static final Name UTILS_PACKAGE;
    public static final Name BUILTIN_ORG;
    public static final Name RUNTIME_PACKAGE;
    public static final Name IGNORE;
    public static final Name INVALID;
    public static final Name GEN_VAR_PREFIX;
    public static final Name SERVICE;
    public static final Name LISTENER;
    public static final Name INIT_FUNCTION_SUFFIX;
    public static final Name START_FUNCTION_SUFFIX;
    public static final Name STOP_FUNCTION_SUFFIX;
    public static final Name SELF;
    public static final Name USER_DEFINED_INIT_SUFFIX;
    public static final Name GENERATED_INIT_SUFFIX;
    public static final Name ANON_ORG;
    public static final Name NIL_VALUE;
    public static final Name QUESTION_MARK;
    public static final Name ORG_NAME_SEPARATOR;
    public static final Name VERSION_SEPARATOR;
    public static final Name ALIAS_SEPARATOR;
    public static final Name ANNOTATION_TYPE_PARAM;
    public static final Name ANNOTATION_BUILTIN_SUBTYPE;
    public static final Name ANNOTATION_ISOLATED_PARAM;
    public static final Name BIR_BASIC_BLOCK_PREFIX;
    public static final Name BIR_LOCAL_VAR_PREFIX;
    public static final Name BIR_GLOBAL_VAR_PREFIX;
    public static final Name DETAIL_MESSAGE;
    public static final Name DETAIL_CAUSE;
    public static final Name NEVER;
    public static final Name RAW_TEMPLATE;
    public static final Name CLONEABLE;
    public static final Name CLONEABLE_INTERNAL;
    public static final Name OBJECT_ITERABLE;
    public static final Name NATURAL_GENERATOR;
    public static final Name SIGNED32;
    public static final Name SIGNED16;
    public static final Name SIGNED8;
    public static final Name UNSIGNED32;
    public static final Name UNSIGNED16;
    public static final Name UNSIGNED8;
    public static final Name CHAR;
    public static final Name XML_ELEMENT;
    public static final Name XML_PI;
    public static final Name XML_COMMENT;
    public static final Name XML_TEXT;
    public static final Name REGEXP_TYPE;
    public static final Name TRUE;
    public static final Name FALSE;
    public static final Name TRANSACTION_PACKAGE;
    public static final Name TRANSACTION_INFO_RECORD;
    public static final Name TRANSACTION_ORG;
    public static final Name CREATE_INT_RANGE;
    public static final Name START_TRANSACTION;
    public static final Name CURRENT_TRANSACTION_INFO;
    public static final Name IS_TRANSACTIONAL;
    public static final Name ROLLBACK_TRANSACTION;
    public static final Name END_TRANSACTION;
    public static final Name GET_AND_CLEAR_FAILURE_TRANSACTION;
    public static final Name CLEAN_UP_TRANSACTION;
    public static final Name BEGIN_REMOTE_PARTICIPANT;
    public static final Name START_TRANSACTION_COORDINATOR;
    public static final Name CONSTRUCT_STREAM;
    public static final Name ABSTRACT_STREAM_ITERATOR;
    public static final Name ABSTRACT_STREAM_CLOSEABLE_ITERATOR;
    public static final Name DEFAULT_VERSION;
    public static final Name DEFAULT_MAJOR_VERSION;
    public CompilerContext context;

    public static Names getInstance(CompilerContext context) {
        Names names = context.get(NAMES_KEY);
        if (names == null) {
            names = new Names(context);
            context.put(NAMES_KEY, names);
        }
        return names;
    }

    private Names(CompilerContext context) {
        this.context = context;
        this.context.put(NAMES_KEY, this);
    }

    public Name fromIdNode(BLangIdentifier identifier) {
        return Names.fromString(identifier.value);
    }

    public Name originalNameFromIdNode(BLangIdentifier identifier) {
        if (identifier.originalValue == null || identifier.value.equals(identifier.originalValue)) {
            return Names.fromString(identifier.value);
        }
        return Names.fromString(identifier.originalValue);
    }

    public static Name fromString(String value) {
        if (value.isEmpty()) {
            return EMPTY;
        }
        if (value.equals("_")) {
            return IGNORE;
        }
        return new Name(value);
    }

    public Name fromTypeKind(TypeKind typeKind) {
        return Names.fromString(typeKind.typeName());
    }

    public Name merge(Name ... names) {
        StringBuilder builder = new StringBuilder();
        for (Name name : names) {
            builder.append(name.value);
        }
        return new Name(builder.toString());
    }

    static {
        DEFAULT_PACKAGE = DOT = new Name(".");
        TEST_PACKAGE = new Name("$test");
        BALLERINA_ORG = new Name("ballerina");
        BALLERINA_INTERNAL_ORG = new Name("ballerinai");
        LANG = new Name("lang");
        INTERNAL = new Name("__internal");
        ANNOTATIONS = new Name("annotations");
        JAVA = new Name("jballerina.java");
        ARRAY = new Name("array");
        DECIMAL = new Name("decimal");
        ERROR = new Name("error");
        FLOAT = new Name("float");
        FUNCTION = new Name("function");
        FUTURE = new Name("future");
        INT = new Name("int");
        BOOLEAN = new Name("boolean");
        MAP = new Name("map");
        NATURAL = new Name("natural");
        OBJECT = new Name("object");
        STREAM = new Name("stream");
        QUERY = new Name("query");
        RUNTIME = new Name("runtime");
        TRANSACTION = new Name("transaction");
        NATURAL_PROGRAMMING = new Name("ai.np");
        OBSERVE = new Name("observe");
        CLOUD = new Name("cloud");
        TABLE = new Name("table");
        TEST = new Name("test");
        TYPEDESC = new Name("typedesc");
        STRING = new Name("string");
        VALUE = new Name("value");
        XML = new Name("xml");
        JSON = new Name("json");
        ANYDATA = new Name("anydata");
        REGEXP = new Name("regexp");
        UTILS_PACKAGE = new Name("utils");
        BUILTIN_ORG = new Name("ballerina");
        RUNTIME_PACKAGE = new Name("runtime");
        IGNORE = new Name("_");
        INVALID = new Name("><");
        GEN_VAR_PREFIX = new Name("_$$_");
        SERVICE = new Name("service");
        LISTENER = new Name("Listener");
        INIT_FUNCTION_SUFFIX = new Name(".<init>");
        START_FUNCTION_SUFFIX = new Name(".<start>");
        STOP_FUNCTION_SUFFIX = new Name(".<stop>");
        SELF = new Name("self");
        USER_DEFINED_INIT_SUFFIX = new Name("init");
        GENERATED_INIT_SUFFIX = new Name("$init$");
        ANON_ORG = new Name("$anon");
        NIL_VALUE = new Name("()");
        QUESTION_MARK = new Name("?");
        ORG_NAME_SEPARATOR = new Name("/");
        ALIAS_SEPARATOR = VERSION_SEPARATOR = new Name(":");
        ANNOTATION_TYPE_PARAM = new Name("typeParam");
        ANNOTATION_BUILTIN_SUBTYPE = new Name("builtinSubtype");
        ANNOTATION_ISOLATED_PARAM = new Name("isolatedParam");
        BIR_BASIC_BLOCK_PREFIX = new Name("bb");
        BIR_LOCAL_VAR_PREFIX = new Name("%");
        BIR_GLOBAL_VAR_PREFIX = new Name("#");
        DETAIL_MESSAGE = new Name("message");
        DETAIL_CAUSE = new Name("cause");
        NEVER = new Name("never");
        RAW_TEMPLATE = new Name("RawTemplate");
        CLONEABLE = new Name("Cloneable");
        CLONEABLE_INTERNAL = new Name("__Cloneable");
        OBJECT_ITERABLE = new Name("Iterable");
        NATURAL_GENERATOR = new Name("Generator");
        SIGNED32 = new Name(STRING_SIGNED32);
        SIGNED16 = new Name(STRING_SIGNED16);
        SIGNED8 = new Name(STRING_SIGNED8);
        UNSIGNED32 = new Name(STRING_UNSIGNED32);
        UNSIGNED16 = new Name(STRING_UNSIGNED16);
        UNSIGNED8 = new Name(STRING_UNSIGNED8);
        CHAR = new Name(STRING_CHAR);
        XML_ELEMENT = new Name(STRING_XML_ELEMENT);
        XML_PI = new Name(STRING_XML_PI);
        XML_COMMENT = new Name(STRING_XML_COMMENT);
        XML_TEXT = new Name(STRING_XML_TEXT);
        REGEXP_TYPE = new Name(STRING_REGEXP);
        TRUE = new Name("true");
        FALSE = new Name("false");
        TRANSACTION_PACKAGE = new Name("transactions");
        TRANSACTION_INFO_RECORD = new Name("Info");
        TRANSACTION_ORG = new Name("ballerina");
        CREATE_INT_RANGE = new Name("createIntRange");
        START_TRANSACTION = new Name("startTransaction");
        CURRENT_TRANSACTION_INFO = new Name("info");
        IS_TRANSACTIONAL = new Name("isTransactional");
        ROLLBACK_TRANSACTION = new Name("rollbackTransaction");
        END_TRANSACTION = new Name("endTransaction");
        GET_AND_CLEAR_FAILURE_TRANSACTION = new Name("getAndClearFailure");
        CLEAN_UP_TRANSACTION = new Name("cleanupTransactionContext");
        BEGIN_REMOTE_PARTICIPANT = new Name("beginRemoteParticipant");
        START_TRANSACTION_COORDINATOR = new Name("startTransactionCoordinator");
        CONSTRUCT_STREAM = new Name("construct");
        ABSTRACT_STREAM_ITERATOR = new Name("_StreamImplementor");
        ABSTRACT_STREAM_CLOSEABLE_ITERATOR = new Name("_CloseableStreamImplementor");
        DEFAULT_VERSION = new Name("0.0.0");
        DEFAULT_MAJOR_VERSION = new Name("0");
    }
}

