/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.stream.Stream;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.Names;

public final class ProjectDirs {
    private static final PathMatcher SOURCE_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*.bal");
    private static final PathMatcher TEST_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:../src/*/tests/**.bal");
    private static final PathMatcher TEST_RESOURCE_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:../src/*/tests/resources/**.bal");

    private ProjectDirs() {
    }

    public static boolean isSourceFile(Path path) {
        return !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && SOURCE_FILE_MATCHER.matches(path);
    }

    public static Path getLastComp(Path path) {
        return path.getName(path.getNameCount() - 1);
    }

    public static BLangCompilerException getPackageNotFoundError(PackageID packageID) {
        if (packageID.isUnnamed) {
            return new BLangCompilerException("cannot find file '" + String.valueOf(packageID) + "'");
        }
        return new BLangCompilerException("cannot find module '" + String.valueOf(packageID) + "'");
    }

    public static BLangCompilerException getPackageNotFoundError(String sourcePackage) {
        if (sourcePackage.endsWith(".bal")) {
            return new BLangCompilerException("cannot find file '" + sourcePackage + "'");
        }
        return new BLangCompilerException("cannot find module '" + sourcePackage + "'");
    }

    public static boolean containsSourceFiles(Path pkgPath) throws BLangCompilerException {
        boolean bl;
        block10: {
            Stream<Path> paths = Files.find(pkgPath, Integer.MAX_VALUE, (path, attrs) -> path.toString().endsWith(".bal"), new FileVisitOption[0]);
            try {
                bl = paths.findAny().isPresent();
                if (paths == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return false;
                }
                catch (UncheckedIOException e) {
                    if (e.getCause() instanceof AccessDeniedException) {
                        throw new BLangCompilerException("permission denied for path " + pkgPath.toString() + ", cause: " + e.getMessage());
                    }
                    throw e;
                }
            }
            paths.close();
        }
        return bl;
    }

    public static boolean isTestSource(Path sourcePath, Path sourceRoot, String pkg) {
        if (Names.DOT.value.equals(pkg)) {
            return false;
        }
        if (!ProjectDirs.isModuleExist(sourceRoot, pkg)) {
            return false;
        }
        Path pkgPath = sourceRoot.resolve(pkg);
        Path relativizePath = pkgPath.relativize(sourcePath);
        return TEST_FILE_MATCHER.matches(relativizePath) && !TEST_RESOURCE_FILE_MATCHER.matches(relativizePath);
    }

    public static boolean isProject(Path path) {
        return Files.exists(path.resolve("Ballerina.toml"), new LinkOption[0]);
    }

    public static Path findProjectRoot(Path projectDir) {
        Path path = projectDir.resolve("Ballerina.toml");
        if (Files.exists(path, new LinkOption[0])) {
            return projectDir;
        }
        Path parentsParent = projectDir.getParent();
        if (null != parentsParent) {
            return ProjectDirs.findProjectRoot(parentsParent);
        }
        return null;
    }

    public static boolean isModuleExist(Path projectPath, String moduleName) {
        Path modulePath = projectPath.resolve("src").resolve(moduleName);
        return Files.exists(modulePath, new LinkOption[0]);
    }
}

