/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.programfile;

import io.ballerina.projects.ModuleContext;
import java.util.Arrays;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;

public abstract class BIRPackageFile
extends CompiledBinaryFile {
    public static final byte[] BIR_MAGIC = new byte[]{-70, 16, -64, -34};
    public static final int BIR_VERSION = 75;

    public abstract byte[] getPkgBirBinaryContent();

    public abstract void setPkgBirBinaryContent(byte[] var1);

    public static class LazyBirPackageFile
    extends BIRPackageFile {
        private final ModuleContext moduleContext;
        private EagerBirPackageFile delegate = null;

        public LazyBirPackageFile(ModuleContext moduleContext) {
            this.moduleContext = moduleContext;
        }

        @Override
        public byte[] getPkgBirBinaryContent() {
            if (this.delegate != null) {
                return this.delegate.getPkgBirBinaryContent();
            }
            byte[] bytes = this.moduleContext.getBirBytes();
            return Arrays.copyOfRange(bytes, 8, bytes.length);
        }

        @Override
        public void setPkgBirBinaryContent(byte[] pkgBirBinaryContent) {
            this.delegate = new EagerBirPackageFile(pkgBirBinaryContent);
        }
    }

    public static class EagerBirPackageFile
    extends BIRPackageFile {
        private byte[] pkgBirBinaryContent;

        public EagerBirPackageFile(byte[] pkgBirBinaryContent) {
            this.pkgBirBinaryContent = pkgBirBinaryContent;
        }

        @Override
        public byte[] getPkgBirBinaryContent() {
            return this.pkgBirBinaryContent;
        }

        @Override
        public void setPkgBirBinaryContent(byte[] pkgBirBinaryContent) {
            this.pkgBirBinaryContent = pkgBirBinaryContent;
        }
    }
}

