/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer;

import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.FunctionContext;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules.AvoidFastHashAlgorithmsRule;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules.AvoidReusingCounterModeVectorsRule;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules.AvoidWeakCipherAlgorithmsRule;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules.CryptoFunctionRule;
import java.util.ArrayList;
import java.util.List;

public class CryptoFunctionRulesEngine {
    private final List<CryptoFunctionRule> rules = new ArrayList<CryptoFunctionRule>();

    public CryptoFunctionRulesEngine() {
        this.initializeDefaultRules();
    }

    public void executeRules(FunctionContext context) {
        for (CryptoFunctionRule rule : this.rules) {
            if (!rule.isApplicable(context)) continue;
            rule.analyze(context);
        }
    }

    public void addRule(CryptoFunctionRule rule) {
        if (rule != null && !this.rules.contains(rule)) {
            this.rules.add(rule);
        }
    }

    private void initializeDefaultRules() {
        this.addRule(new AvoidWeakCipherAlgorithmsRule());
        this.addRule(new AvoidFastHashAlgorithmsRule());
        this.addRule(new AvoidReusingCounterModeVectorsRule());
    }
}

