/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.projects.Document;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoAnalyzerUtils;
import io.ballerina.tools.diagnostics.Location;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FunctionContext {
    private final SemanticModel semanticModel;
    private final Reporter reporter;
    private final Document document;
    private final String functionName;
    private final Location functionLocation;
    private Map<String, ExpressionNode> paramExpressions = Map.of();
    private Map<String, ExpressionNode> varExpressions = Map.of();

    public static FunctionContext getInstance(SemanticModel semanticModel, Reporter reporter, Document document, FunctionCallExpressionNode functionCall, FunctionSymbol functionSymbol) {
        Optional<Node> functionBodyOpt;
        NodeLocation location = functionCall.location();
        SeparatedNodeList arguments = functionCall.arguments();
        Optional functionNameOpt = functionSymbol.getName();
        if (functionNameOpt.isEmpty()) {
            throw new IllegalStateException("Function name is not available for the function symbol");
        }
        String functionName = (String)functionNameOpt.get();
        Optional params = functionSymbol.typeDescriptor().params();
        FunctionContext defaultFunctionContext = new FunctionContext(semanticModel, reporter, document, functionName, (Location)location);
        if (params.isEmpty() || arguments.isEmpty()) {
            return defaultFunctionContext;
        }
        Map<String, ExpressionNode> paramExpressions = CryptoAnalyzerUtils.getParamExpressions((List)params.get(), (SeparatedNodeList<FunctionArgumentNode>)arguments);
        Optional<StatementNode> statementNode = CryptoAnalyzerUtils.getStatementNode(functionCall);
        if (statementNode.isEmpty()) {
            return defaultFunctionContext;
        }
        HashMap<String, ExpressionNode> varExpressions = new HashMap();
        Optional<ModulePartNode> modulePartNode = CryptoAnalyzerUtils.getModulePartNode((Node)statementNode.get());
        if (modulePartNode.isPresent()) {
            varExpressions = CryptoAnalyzerUtils.getModuleLevelVarExpressions(modulePartNode.get());
        }
        if ((functionBodyOpt = CryptoAnalyzerUtils.getParentBlockNode((Node)statementNode.get())).isEmpty()) {
            return defaultFunctionContext;
        }
        CryptoAnalyzerUtils.collectVariableExpressionsUntilStatement(functionBodyOpt.get(), statementNode.get(), varExpressions);
        return new FunctionContext(semanticModel, reporter, document, functionName, (Location)location, paramExpressions, varExpressions);
    }

    private FunctionContext(SemanticModel semanticModel, Reporter reporter, Document document, String functionName, Location functionLocation) {
        this.semanticModel = semanticModel;
        this.reporter = reporter;
        this.document = document;
        this.functionName = functionName;
        this.functionLocation = functionLocation;
    }

    private FunctionContext(SemanticModel semanticModel, Reporter reporter, Document document, String functionName, Location functionLocation, Map<String, ExpressionNode> paramExpressions, Map<String, ExpressionNode> varExpressions) {
        this(semanticModel, reporter, document, functionName, functionLocation);
        this.paramExpressions = paramExpressions;
        this.varExpressions = varExpressions;
    }

    public SemanticModel semanticModel() {
        return this.semanticModel;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public Document document() {
        return this.document;
    }

    public String functionName() {
        return this.functionName;
    }

    public Location functionLocation() {
        return this.functionLocation;
    }

    public Optional<ExpressionNode> getParamExpression(String paramName) {
        if (!this.paramExpressions.containsKey(paramName = CryptoAnalyzerUtils.unescapeIdentifier(paramName))) {
            return Optional.empty();
        }
        ExpressionNode paramExpr = this.paramExpressions.get(paramName);
        if (paramExpr instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode simpleNameRef = (SimpleNameReferenceNode)paramExpr;
            String varName = simpleNameRef.name().text();
            Optional<ExpressionNode> varExprOpt = this.getVarExpression(varName);
            return varExprOpt.isPresent() ? varExprOpt : Optional.of(paramExpr);
        }
        return Optional.of(paramExpr);
    }

    public Optional<ExpressionNode> getVarExpression(String varName) {
        if (!this.varExpressions.containsKey(varName = CryptoAnalyzerUtils.unescapeIdentifier(varName))) {
            return Optional.empty();
        }
        ExpressionNode varExpr = this.varExpressions.get(varName);
        if (varExpr instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode simpleNameRef = (SimpleNameReferenceNode)varExpr;
            String innerVarName = simpleNameRef.name().text();
            return this.getVarExpression(innerVarName);
        }
        return Optional.of(varExpr);
    }
}

