/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoRule;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.FunctionContext;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules.CryptoFunctionRule;
import java.util.Optional;

public class AvoidFastHashAlgorithmsRule
implements CryptoFunctionRule {
    public static final String HASH_BCRYPT = "hashBcrypt";
    public static final String HASH_ARGON2 = "hashArgon2";
    public static final String WORK_FACTOR = "workFactor";
    public static final String ITERATIONS = "iterations";
    public static final String MEMORY = "memory";
    public static final int BCRYPT_RECOMMENDED_WORK_FACTOR = 10;
    public static final int ARGON2_RECOMMENDED_ITERATIONS = 2;
    public static final int ARGON2_RECOMMENDED_MEMORY = 19456;

    @Override
    public void analyze(FunctionContext context) {
        if (this.isBCryptWithLowWorkFactor(context) || this.isArgon2WithWeakParams(context)) {
            context.reporter().reportIssue(context.document(), context.functionLocation(), this.getRuleId());
        }
    }

    @Override
    public int getRuleId() {
        return CryptoRule.AVOID_FAST_HASH_ALGORITHMS.getId();
    }

    @Override
    public boolean isApplicable(FunctionContext context) {
        String functionName = context.functionName();
        return functionName.equals(HASH_BCRYPT) || functionName.equals(HASH_ARGON2);
    }

    private boolean isBCryptWithLowWorkFactor(FunctionContext context) {
        if (!context.functionName().equals(HASH_BCRYPT)) {
            return false;
        }
        SemanticModel semanticModel = context.semanticModel();
        Optional<ExpressionNode> workFactorOpt = context.getParamExpression(WORK_FACTOR);
        return workFactorOpt.filter(expr -> AvoidFastHashAlgorithmsRule.hasLowerIntegerValue(expr, 10, semanticModel)).isPresent();
    }

    private boolean isArgon2WithWeakParams(FunctionContext context) {
        if (!context.functionName().equals(HASH_ARGON2)) {
            return false;
        }
        SemanticModel semanticModel = context.semanticModel();
        return this.isArgon2ParamBelowThreshold(context, ITERATIONS, 2, semanticModel) || this.isArgon2ParamBelowThreshold(context, MEMORY, 19456, semanticModel);
    }

    private boolean isArgon2ParamBelowThreshold(FunctionContext context, String paramName, int recommendedValue, SemanticModel semanticModel) {
        Optional<ExpressionNode> paramOpt = context.getParamExpression(paramName);
        return paramOpt.filter(expr -> AvoidFastHashAlgorithmsRule.hasLowerIntegerValue(expr, recommendedValue, semanticModel)).isPresent();
    }

    private static boolean hasLowerIntegerValue(ExpressionNode valueExpr, Integer targetValue, SemanticModel semanticModel) {
        ConstantValue constantValue;
        ConstantSymbol constantRef;
        Object object;
        NameReferenceNode refNode;
        Optional refSymbol;
        if (valueExpr.kind().equals((Object)SyntaxKind.NUMERIC_LITERAL)) {
            String iterationsValue = ((BasicLiteralNode)valueExpr).literalToken().text();
            try {
                int iterationsInt = Integer.parseInt(iterationsValue);
                return iterationsInt < targetValue;
            }
            catch (NumberFormatException iterationsInt) {}
        } else if (valueExpr instanceof NameReferenceNode && (refSymbol = semanticModel.symbol((Node)(refNode = (NameReferenceNode)valueExpr))).isPresent() && (object = refSymbol.get()) instanceof ConstantSymbol && (object = (constantRef = (ConstantSymbol)object).constValue()) instanceof ConstantValue && (object = (constantValue = (ConstantValue)object).value()) instanceof Long) {
            Long longValue = (Long)object;
            return longValue < (long)targetValue.intValue();
        }
        return false;
    }
}

