/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules;

import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoAnalyzerUtils;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoRule;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.FunctionContext;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules.CryptoFunctionRule;
import java.util.Optional;

public class AvoidWeakCipherAlgorithmsRule
implements CryptoFunctionRule {
    public static final String ENCRYPT_AES_ECB = "encryptAesEcb";
    public static final String ENCRYPT_AES_CBC = "encryptAesCbc";
    public static final String ENCRYPT_RSA_ECB = "encryptRsaEcb";
    public static final String PADDING_PARAM = "padding";
    public static final String PKCS1_PADDING = "PKCS1";

    @Override
    public void analyze(FunctionContext context) {
        String functionName = context.functionName();
        if (functionName.equals(ENCRYPT_AES_CBC) || functionName.equals(ENCRYPT_AES_ECB) || functionName.equals(ENCRYPT_RSA_ECB) && this.isRsbEcbWithPKCS1Padding(context)) {
            context.reporter().reportIssue(context.document(), context.functionLocation(), this.getRuleId());
        }
    }

    @Override
    public int getRuleId() {
        return CryptoRule.AVOID_WEAK_CIPHER_ALGORITHMS.getId();
    }

    @Override
    public boolean isApplicable(FunctionContext context) {
        String functionName = context.functionName();
        return functionName.equals(ENCRYPT_AES_CBC) || functionName.equals(ENCRYPT_AES_ECB) || functionName.equals(ENCRYPT_RSA_ECB);
    }

    private boolean isRsbEcbWithPKCS1Padding(FunctionContext context) {
        Optional<String> paddingExprOpt = CryptoAnalyzerUtils.getStringValue(PADDING_PARAM, context);
        return paddingExprOpt.map(s -> s.equals(PKCS1_PADDING)).orElse(true);
    }
}

