/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.graphql.components;

import graphql.language.AstPrinter;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLSchema;
import io.ballerina.graphql.generator.client.generator.graphql.Utils;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedFieldDefinition;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedVariableDefinition;
import io.ballerina.graphql.generator.client.generator.model.FieldType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendedOperationDefinition {
    private final OperationDefinition definition;
    private final Document queryFileAst;

    public ExtendedOperationDefinition(Document queryFileAst, OperationDefinition definition) {
        this.definition = definition;
        this.queryFileAst = queryFileAst;
    }

    public String getOperationType() {
        return this.definition.getOperation().name();
    }

    public String getName() {
        return this.definition.getName();
    }

    public List<ExtendedVariableDefinition> getVariableDefinitions() {
        ArrayList<ExtendedVariableDefinition> variableDefinitions = new ArrayList<ExtendedVariableDefinition>();
        for (VariableDefinition variableDefinition : this.definition.getVariableDefinitions()) {
            variableDefinitions.add(new ExtendedVariableDefinition(variableDefinition));
        }
        return variableDefinitions;
    }

    public Map<String, FieldType> getVariableDefinitionsMap(GraphQLSchema graphQLSchema) {
        HashMap<String, FieldType> variableDefinitionsMap = new HashMap<String, FieldType>();
        for (VariableDefinition variableDefinition : this.definition.getVariableDefinitions()) {
            variableDefinitionsMap.put(variableDefinition.getName(), Utils.getFieldType(graphQLSchema, variableDefinition.getType()));
        }
        return variableDefinitionsMap;
    }

    public List<ExtendedFieldDefinition> getExtendedFieldDefinitions() {
        ArrayList<ExtendedFieldDefinition> fieldDefinitionList = new ArrayList<ExtendedFieldDefinition>();
        for (Selection selection : this.definition.getSelectionSet().getSelections()) {
            Field field = (Field)selection;
            ExtendedFieldDefinition extendedFieldDefinition = new ExtendedFieldDefinition(field);
            fieldDefinitionList.add(extendedFieldDefinition);
        }
        return fieldDefinitionList;
    }

    public String getQueryString() {
        List fragmentDefinitions = this.queryFileAst.getDefinitionsOfType(FragmentDefinition.class);
        ArrayList definitionArrayList = new ArrayList(fragmentDefinitions);
        Document document = Document.newDocument().definitions(definitionArrayList).definition((Definition)this.definition).build();
        return AstPrinter.printAstCompact((Node)document);
    }
}

