/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.csv;

import io.ballerina.lib.data.csvdata.FromString;
import io.ballerina.lib.data.csvdata.csv.CsvParser;
import io.ballerina.lib.data.csvdata.utils.CsvConfig;
import io.ballerina.lib.data.csvdata.utils.CsvUtils;
import io.ballerina.lib.data.csvdata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.Map;
import org.ballerinalang.langlib.value.CloneReadOnly;

public final class CsvCreator {
    private CsvCreator() {
    }

    static Object initRowValue(Type expectedType) {
        expectedType = TypeUtils.getReferredType((Type)expectedType);
        return switch (expectedType.getTag()) {
            case 24 -> ValueCreator.createRecordValue((Module)expectedType.getPackage(), (String)expectedType.getName());
            case 27 -> ValueCreator.createMapValue((MapType)((MapType)expectedType));
            case 44 -> ValueCreator.createTupleValue((TupleType)((TupleType)expectedType));
            case 32 -> ValueCreator.createArrayValue((ArrayType)((ArrayType)expectedType));
            default -> throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expectedType);
        };
    }

    static void convertAndUpdateCurrentCsvNode(CsvParser.StateMachine sm, String value, Type type, CsvConfig config, Type exptype, Field currentField) {
        Object currentCsv = sm.currentCsvNode;
        Object nilValue = config.nilValue;
        if (sm.config.nilAsOptionalField && !type.isNilable() && CsvUtils.isNullValue(nilValue, value) && currentField != null && SymbolFlags.isFlagOn((long)currentField.getFlags(), (long)4096L)) {
            return;
        }
        Object convertedValue = CsvCreator.convertToExpectedType(StringUtils.fromString((String)value), type, config);
        sm.isCurrentCsvNodeEmpty = false;
        if (convertedValue instanceof BError || convertedValue instanceof CsvUtils.UnMappedValue) {
            if (CsvCreator.ignoreIncompatibilityErrorsForMaps(sm, exptype)) {
                return;
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_CAST, value, type);
        }
        Type currentCsvNodeType = TypeUtils.getType((Object)currentCsv);
        switch (currentCsvNodeType.getTag()) {
            case 24: 
            case 27: {
                ((BMap)currentCsv).put((Object)StringUtils.fromString((String)CsvCreator.getHeaderValueForColumnIndex(sm)), convertedValue);
                ++sm.currentCsvNodeLength;
                break;
            }
            case 32: {
                ArrayType arrayType = (ArrayType)currentCsvNodeType;
                if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() - 1 < sm.columnIndex) {
                    sm.isColumnMaxSizeReached = true;
                }
                ((BArray)currentCsv).add((long)sm.columnIndex, convertedValue);
                ++sm.currentCsvNodeLength;
                break;
            }
            case 44: {
                ((BArray)currentCsv).add((long)sm.columnIndex, convertedValue);
                ++sm.currentCsvNodeLength;
            }
        }
    }

    public static String getHeaderValueForColumnIndex(CsvParser.StateMachine sm) {
        if (sm.config.customHeadersIfHeadersAbsent == null && sm.config.header == null) {
            String header = String.valueOf(sm.columnIndex + 1);
            Map<String, Field> fieldHierarchy = sm.fieldHierarchy;
            fieldHierarchy.remove(header);
            return header;
        }
        if (sm.columnIndex >= sm.headers.size()) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_CUSTOM_HEADER_LENGTH, new Object[0]);
        }
        String header = sm.headers.get(sm.columnIndex);
        return CsvUtils.getUpdatedHeaders(sm.updatedRecordFieldNames, header, sm.fields.contains(header));
    }

    public static void addCustomHeadersIfNotNull(CsvParser.StateMachine sm, Object customHeader) {
        BArray customHeaders = (BArray)customHeader;
        for (int i = 0; i < customHeaders.size(); ++i) {
            String header = StringUtils.getStringValue((Object)customHeaders.get((long)i));
            Map<String, Field> fieldHierarchy = sm.fieldHierarchy;
            sm.headers.add(header);
            if (!fieldHierarchy.containsKey(header)) continue;
            Field field = fieldHierarchy.get(header);
            sm.fieldNames.put(header, field);
            fieldHierarchy.remove(header);
        }
    }

    private static boolean ignoreIncompatibilityErrorsForMaps(CsvParser.StateMachine sm, Type exptype) {
        if (exptype.getTag() == 24) {
            Map<String, Field> fields = sm.fieldNames;
            String header = CsvCreator.getHeaderValueForColumnIndex(sm);
            return !fields.containsKey(header);
        }
        return exptype.getTag() == 27;
    }

    public static Object convertToExpectedType(BString value, Type type, CsvConfig config) {
        if (type.getTag() == 23) {
            return FromString.fromStringWithType(value, (Type)PredefinedTypes.TYPE_JSON, config);
        }
        return FromString.fromStringWithType(value, type, config);
    }

    public static Object constructReadOnlyValue(Object value) {
        return CloneReadOnly.cloneReadOnly((Object)value);
    }
}

