/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.csv;

import io.ballerina.lib.data.csvdata.csv.CsvParser;
import io.ballerina.lib.data.csvdata.csv.CsvTraversal;
import io.ballerina.lib.data.csvdata.io.DataReaderTask;
import io.ballerina.lib.data.csvdata.utils.Constants;
import io.ballerina.lib.data.csvdata.utils.CsvConfig;
import io.ballerina.lib.data.csvdata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public final class Native {
    private Native() {
    }

    public static Object parseString(BString csv, BMap<BString, Object> options, BTypedesc type) {
        try {
            return CsvParser.parse(new StringReader(csv.getValue()), type, CsvConfig.createParseOptions(options));
        }
        catch (BError e) {
            return e;
        }
        catch (Exception e) {
            return DiagnosticLog.error(DiagnosticErrorCode.INVALID_CAST, csv, type);
        }
    }

    public static Object parseBytes(BArray csv, BMap<BString, Object> options, BTypedesc type) {
        try {
            byte[] bytes = csv.getBytes();
            return CsvParser.parse(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charset.forName(options.getStringValue(Constants.ConfigConstants.ENCODING).toString())), type, CsvConfig.createParseOptions(options));
        }
        catch (BError e) {
            return e;
        }
        catch (Exception e) {
            return DiagnosticLog.error(DiagnosticErrorCode.INVALID_CAST, csv, type);
        }
    }

    public static Object parseStream(Environment env, BStream csv, BMap<BString, Object> options, BTypedesc type) {
        try {
            BObject iteratorObj = csv.getIteratorObj();
            return env.yieldAndRun(() -> {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                DataReaderTask task = new DataReaderTask(env, iteratorObj, future, type, CsvConfig.createParseOptions(options), options.getStringValue(Constants.ConfigConstants.ENCODING));
                Thread.startVirtualThread(task);
                try {
                    return future.get();
                }
                catch (BError | InterruptedException | ExecutionException bError) {
                    return ErrorCreator.createError((Throwable)bError);
                }
            });
        }
        catch (BError e) {
            return e;
        }
        catch (Exception e) {
            return DiagnosticLog.error(DiagnosticErrorCode.INVALID_CAST, csv, type);
        }
    }

    public static Object transform(BArray csv, BMap<BString, Object> options, BTypedesc type) {
        try {
            return CsvTraversal.traverse(csv, CsvConfig.createTransformOptions(options), type);
        }
        catch (Exception e) {
            return DiagnosticLog.getCsvError(e.getMessage());
        }
    }

    public static Object parseList(BArray csv, BMap<BString, Object> options, BTypedesc type) {
        try {
            CsvConfig config = CsvConfig.createParseListOptions(options);
            config.stringConversion = true;
            return CsvTraversal.traverse(csv, config, type);
        }
        catch (Exception e) {
            return DiagnosticLog.getCsvError(e.getMessage());
        }
    }
}

