/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.log;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BXml;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class MaskedStringBuilder
implements AutoCloseable {
    private static final BString STRATEGY_KEY = StringUtils.fromString((String)"strategy");
    private static final BString REPLACEMENT_KEY = StringUtils.fromString((String)"replacement");
    private static final BString EXCLUDE_VALUE = StringUtils.fromString((String)"EXCLUDE");
    private static final String FIELD_PREFIX = "$field$.";
    private static final String LOG_ANNOTATION_PREFIX = "ballerina/log";
    private static final String SENSITIVE_SUFFIX = ":Sensitive";
    private static final BString CYCLIC_REFERENCE_ERROR = StringUtils.fromString((String)"Cyclic value reference detected in the record");
    public static final BString MASKED_STRING_BUILDER_HAS_BEEN_CLOSED = StringUtils.fromString((String)"MaskedStringBuilder has been closed");
    private static final LRUCache<RecordType, Map<String, BMap<?, ?>>> ANNOTATION_CACHE = new LRUCache(1000);
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final char[] QUOTE_ESCAPE = new char[]{'\\', '\"'};
    private static final char[] BACKSLASH_ESCAPE = new char[]{'\\', '\\'};
    private static final char[] NEWLINE_ESCAPE = new char[]{'\\', 'n'};
    private static final char[] TAB_ESCAPE = new char[]{'\\', 't'};
    private static final char[] CARRIAGE_RETURN_ESCAPE = new char[]{'\\', 'r'};
    private static final char[] BACKSPACE_ESCAPE = new char[]{'\\', 'b'};
    private static final char[] FORM_FEED_ESCAPE = new char[]{'\\', 'f'};
    private static final int ASCII_CONTROL_CHAR_LIMIT = 32;
    private static final int ASCII_DEL_CHAR = 127;
    private final Runtime runtime;
    private final IdentityHashMap<Object, Boolean> visitedValues;
    private StringBuilder stringBuilder;
    private StringBuilder escapeBuffer;
    private boolean closed = false;
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private static final int MAX_REUSABLE_CAPACITY = 8192;
    private static final int ESCAPE_BUFFER_SIZE = 64;

    public MaskedStringBuilder(Runtime runtime) {
        this(runtime, 256);
    }

    public MaskedStringBuilder(Runtime runtime, int initialCapacity) {
        this.runtime = runtime;
        this.visitedValues = new IdentityHashMap();
        this.stringBuilder = new StringBuilder(initialCapacity < 0 ? 256 : initialCapacity);
        this.escapeBuffer = new StringBuilder(64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build(Object value) {
        if (this.closed) {
            throw ErrorCreator.createError((BString)MASKED_STRING_BUILDER_HAS_BEEN_CLOSED);
        }
        try {
            this.visitedValues.clear();
            this.stringBuilder.setLength(0);
            String result = this.buildInternal(value);
            if (this.stringBuilder.capacity() > 8192) {
                this.stringBuilder = new StringBuilder(256);
            }
            if (this.escapeBuffer.capacity() > 256) {
                this.escapeBuffer = new StringBuilder(64);
            }
            String string = result;
            return string;
        }
        finally {
            this.visitedValues.clear();
        }
    }

    private String buildInternal(Object value) {
        if (value == null) {
            return "null";
        }
        if (MaskedStringBuilder.isBasicType(value)) {
            return StringUtils.getStringValue((Object)value);
        }
        if (this.visitedValues.put(value, Boolean.TRUE) != null) {
            throw ErrorCreator.createError((BString)CYCLIC_REFERENCE_ERROR);
        }
        try {
            String string = this.processValue(value);
            return string;
        }
        finally {
            this.visitedValues.remove(value);
        }
    }

    private String processValue(Object value) {
        Type type = this.getEffectiveType(TypeUtils.getType((Object)value));
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BMap.class, BTable.class, BArray.class}, (Object)object2, n)) {
            case 0 -> {
                BMap mapValue = (BMap)object2;
                yield this.processMapValue(mapValue, type);
            }
            case 1 -> {
                BTable tableValue = (BTable)object2;
                yield this.processTableValue(tableValue);
            }
            case 2 -> {
                BArray listValue = (BArray)object2;
                yield this.processArrayValue(listValue);
            }
            default -> StringUtils.getStringValue((Object)value);
        };
    }

    private Type getEffectiveType(Type type) {
        Optional intersectionType;
        List constituentTypes;
        if (type.getTag() == 34 && (constituentTypes = ((IntersectionType)type).getConstituentTypes()).size() == 2) {
            type = ((Type)constituentTypes.get(0)).getTag() == 51 ? (Type)constituentTypes.get(1) : (Type)constituentTypes.get(0);
            return this.getEffectiveType(type);
        }
        if (type.getTag() == 24 && (intersectionType = ((RecordType)type).getIntersectionType()).isPresent()) {
            return this.getEffectiveType((Type)intersectionType.get());
        }
        if (type.getTag() == 53) {
            type = ((ReferenceType)type).getReferredType();
            return this.getEffectiveType(type);
        }
        return type;
    }

    private String processMapValue(BMap<?, ?> mapValue, Type valueType) {
        Map fields = Map.of();
        Map<String, BMap<?, ?>> fieldAnnotations = Map.of();
        if (valueType.getTag() == 24) {
            RecordType recType = (RecordType)valueType;
            fields = recType.getFields();
            fieldAnnotations = this.getCachedFieldAnnotations(recType);
        }
        return this.processRecordValue(mapValue, fieldAnnotations, fields);
    }

    private String processRecordValue(BMap<?, ?> mapValue, Map<String, BMap<?, ?>> fieldAnnotations, Map<String, Field> fields) {
        int startPos = this.stringBuilder.length();
        this.stringBuilder.append('{');
        this.addRecordFields(mapValue, fields, fieldAnnotations);
        this.stringBuilder.append('}');
        String result = this.stringBuilder.substring(startPos);
        this.stringBuilder.setLength(startPos);
        return result;
    }

    private void addRecordFields(BMap<?, ?> mapValue, Map<String, Field> fields, Map<String, BMap<?, ?>> fieldAnnotations) {
        boolean first = true;
        for (Object key : mapValue.getKeys()) {
            if (!(key instanceof BString)) continue;
            BString keyStr = (BString)key;
            Object fieldValue = mapValue.get(key);
            String fieldName = keyStr.getValue();
            first = fields.containsKey(fieldName) ? this.addDefinedFieldValue(fieldAnnotations, fieldName, fieldValue, first) : this.addDynamicFieldValue(fieldValue, first, fieldName);
        }
    }

    private boolean addDynamicFieldValue(Object fieldValue, boolean first, String fieldName) {
        String fieldStringValue = this.buildInternal(fieldValue);
        if (!first) {
            this.stringBuilder.append(',');
        }
        this.appendFieldToJson(fieldName, fieldStringValue, false, fieldValue);
        return false;
    }

    private boolean addDefinedFieldValue(Map<String, BMap<?, ?>> fieldAnnotations, String fieldName, Object fieldValue, boolean first) {
        Optional<BMap<?, ?>> annotation = MaskedStringBuilder.getLogSensitiveDataAnnotation(fieldAnnotations, fieldName);
        Optional fieldStringValue = annotation.map(fieldAnnotation -> MaskedStringBuilder.getStringValue(fieldAnnotation, fieldValue, this.runtime)).orElseGet(() -> Optional.of(this.buildInternal(fieldValue)));
        if (fieldStringValue.isPresent()) {
            if (!first) {
                this.stringBuilder.append(',');
            }
            this.appendFieldToJson(fieldName, (String)fieldStringValue.get(), annotation.isPresent(), fieldValue);
            first = false;
        }
        return first;
    }

    private void appendFieldToJson(String fieldName, String value, boolean hasAnnotation, Object fieldValue) {
        this.stringBuilder.append('\"');
        this.appendEscapedString(fieldName);
        this.stringBuilder.append("\":");
        if (hasAnnotation || fieldValue instanceof BString || fieldValue instanceof BXml) {
            this.stringBuilder.append('\"');
            this.appendEscapedString(value);
            this.stringBuilder.append('\"');
        } else {
            this.stringBuilder.append(value);
        }
    }

    private void appendEscapedString(String input) {
        if (input == null) {
            this.stringBuilder.append("null");
            return;
        }
        if (!MaskedStringBuilder.needsEscaping(input)) {
            this.stringBuilder.append(input);
            return;
        }
        block9: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\"': {
                    this.stringBuilder.append(QUOTE_ESCAPE);
                    continue block9;
                }
                case '\\': {
                    this.stringBuilder.append(BACKSLASH_ESCAPE);
                    continue block9;
                }
                case '\b': {
                    this.stringBuilder.append(BACKSPACE_ESCAPE);
                    continue block9;
                }
                case '\f': {
                    this.stringBuilder.append(FORM_FEED_ESCAPE);
                    continue block9;
                }
                case '\n': {
                    this.stringBuilder.append(NEWLINE_ESCAPE);
                    continue block9;
                }
                case '\r': {
                    this.stringBuilder.append(CARRIAGE_RETURN_ESCAPE);
                    continue block9;
                }
                case '\t': {
                    this.stringBuilder.append(TAB_ESCAPE);
                    continue block9;
                }
                default: {
                    if (c < ' ' || c == '\u007f') {
                        this.stringBuilder.append("\\u00");
                        this.stringBuilder.append(HEX_CHARS[c >>> 4 & 0xF]);
                        this.stringBuilder.append(HEX_CHARS[c & 0xF]);
                        continue block9;
                    }
                    this.stringBuilder.append(c);
                }
            }
        }
    }

    private Map<String, BMap<?, ?>> getCachedFieldAnnotations(RecordType recordType) {
        Map<String, BMap<?, ?>> cached = ANNOTATION_CACHE.get(recordType);
        if (cached != null) {
            return cached;
        }
        Map<String, BMap<?, ?>> annotations = MaskedStringBuilder.extractFieldAnnotations(recordType);
        ANNOTATION_CACHE.put(recordType, annotations);
        return annotations;
    }

    private String processTableValue(BTable<?, ?> tableValue) {
        Collection values = tableValue.values();
        if (values.isEmpty()) {
            return "[]";
        }
        int startPos = this.stringBuilder.length();
        this.stringBuilder.append('[');
        boolean first = true;
        for (Object row : values) {
            if (!first) {
                this.stringBuilder.append(',');
            }
            String elementString = this.buildInternal(row);
            this.appendValueToArray(elementString, row);
            first = false;
        }
        this.stringBuilder.append(']');
        String result = this.stringBuilder.substring(startPos);
        this.stringBuilder.setLength(startPos);
        return result;
    }

    private String processArrayValue(BArray listValue) {
        long length = listValue.getLength();
        if (listValue.isEmpty()) {
            return "[]";
        }
        int startPos = this.stringBuilder.length();
        this.stringBuilder.append('[');
        for (long i = 0L; i < length; ++i) {
            if (i > 0L) {
                this.stringBuilder.append(',');
            }
            Object element = listValue.get(i);
            String elementString = this.buildInternal(element);
            this.appendValueToArray(elementString, element);
        }
        this.stringBuilder.append(']');
        String result = this.stringBuilder.substring(startPos);
        this.stringBuilder.setLength(startPos);
        return result;
    }

    private void appendValueToArray(String value, Object originalValue) {
        if (originalValue instanceof BString) {
            this.stringBuilder.append('\"');
            this.appendEscapedString(value);
            this.stringBuilder.append('\"');
        } else {
            this.stringBuilder.append(value);
        }
    }

    private static boolean isBasicType(Object value) {
        return value == null || TypeUtils.getType((Object)value).getTag() < 14;
    }

    private static boolean needsEscaping(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '\"' && c != '\\' && (c & 0xFFE0) != 0 && c != '\u007f') continue;
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return this.stringBuilder.capacity();
    }

    public void reset() {
        if (this.closed) {
            throw ErrorCreator.createError((BString)MASKED_STRING_BUILDER_HAS_BEEN_CLOSED);
        }
        this.visitedValues.clear();
        this.stringBuilder.setLength(0);
        this.escapeBuffer.setLength(0);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.visitedValues.clear();
            this.stringBuilder = null;
            this.escapeBuffer = null;
            this.closed = true;
        }
    }

    public static void clearAnnotationCache() {
        ANNOTATION_CACHE.clear();
    }

    public static int getAnnotationCacheSize() {
        return ANNOTATION_CACHE.size();
    }

    public static MaskedStringBuilder create(Runtime runtime) {
        return new MaskedStringBuilder(runtime);
    }

    public static MaskedStringBuilder create(Runtime runtime, int initialCapacity) {
        return new MaskedStringBuilder(runtime, initialCapacity);
    }

    static Optional<BMap<?, ?>> getLogSensitiveDataAnnotation(Map<String, BMap<?, ?>> fieldAnnotations, String fieldName) {
        Object[] keys;
        BMap<?, ?> fieldAnnotationMap = fieldAnnotations.get(IdentifierUtils.escapeSpecialCharacters((String)fieldName));
        if (fieldAnnotationMap == null) {
            return Optional.empty();
        }
        for (Object key : keys = fieldAnnotationMap.getKeys()) {
            BString bStringKey;
            String keyValue;
            if (!(key instanceof BString) || !(keyValue = (bStringKey = (BString)key).getValue()).endsWith(SENSITIVE_SUFFIX) || !keyValue.startsWith(LOG_ANNOTATION_PREFIX)) continue;
            Object annotation = fieldAnnotationMap.get(key);
            if (!(annotation instanceof BMap)) break;
            BMap bMapAnnotation = (BMap)annotation;
            return Optional.of(bMapAnnotation);
        }
        return Optional.empty();
    }

    static Map<String, BMap<?, ?>> extractFieldAnnotations(RecordType recordType) {
        BMap annotations = recordType.getAnnotations();
        if (annotations == null) {
            return Map.of();
        }
        return annotations.entrySet().stream().filter(entry -> {
            String keyValue = ((BString)entry.getKey()).getValue();
            return keyValue.startsWith(FIELD_PREFIX) && entry.getValue() instanceof BMap;
        }).collect(Collectors.toMap(entry -> ((BString)entry.getKey()).getValue().substring(FIELD_PREFIX.length()), entry -> (BMap)entry.getValue(), (existing, replacement) -> existing));
    }

    static Optional<String> getStringValue(BMap<?, ?> annotation, Object realValue, Runtime runtime) {
        Object strategy = annotation.get((Object)STRATEGY_KEY);
        if (strategy instanceof BString) {
            BString strategyStr = (BString)strategy;
            if (EXCLUDE_VALUE.getValue().equals(strategyStr.getValue())) {
                return Optional.empty();
            }
        }
        if (strategy instanceof BMap) {
            BMap replacementMap = (BMap)strategy;
            Object replacement = replacementMap.get((Object)REPLACEMENT_KEY);
            if (replacement instanceof BString) {
                BString replacementStr = (BString)replacement;
                return Optional.of(replacementStr.getValue());
            }
            if (replacement instanceof BFunctionPointer) {
                BFunctionPointer replacer = (BFunctionPointer)replacement;
                Object replacementString = replacer.call(runtime, new Object[]{StringUtils.fromString((String)StringUtils.getStringValue((Object)realValue))});
                if (replacementString instanceof BString) {
                    BString replacementStrVal = (BString)replacementString;
                    return Optional.of(replacementStrVal.getValue());
                }
            }
        }
        return Optional.of(StringUtils.getStringValue((Object)realValue));
    }

    private static class LRUCache<K, V> {
        private final int maxSize;
        private final Map<K, Node<K, V>> cache;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        private final Node<K, V> head;
        private final Node<K, V> tail;

        public LRUCache(int maxSize) {
            this.maxSize = maxSize;
            this.cache = new HashMap<K, Node<K, V>>();
            this.head = new Node();
            this.tail = new Node();
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            this.writeLock.lock();
            try {
                Node<K, V> node = this.cache.get(key);
                if (node == null) {
                    V v = null;
                    return v;
                }
                this.moveToHead(node);
                Object v = node.value;
                return v;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V put(K key, V value) {
            this.writeLock.lock();
            try {
                Node<K, V> existingNode = this.cache.get(key);
                if (existingNode != null) {
                    Object oldValue = existingNode.value;
                    existingNode.value = value;
                    this.moveToHead(existingNode);
                    Object v = oldValue;
                    return v;
                }
                Node<K, V> newNode = new Node<K, V>(key, value);
                if (this.cache.size() >= this.maxSize) {
                    Node lru = this.tail.prev;
                    this.removeNode(lru);
                    this.cache.remove(lru.key);
                }
                this.cache.put(key, newNode);
                this.addToHead(newNode);
                V v = null;
                return v;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public void clear() {
            this.writeLock.lock();
            try {
                this.cache.clear();
                this.head.next = this.tail;
                this.tail.prev = this.head;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public int size() {
            this.readLock.lock();
            try {
                int n = this.cache.size();
                return n;
            }
            finally {
                this.readLock.unlock();
            }
        }

        private void addToHead(Node<K, V> node) {
            node.prev = this.head;
            node.next = this.head.next;
            this.head.next.prev = node;
            this.head.next = node;
        }

        private void removeNode(Node<K, V> node) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }

        private void moveToHead(Node<K, V> node) {
            this.removeNode(node);
            this.addToHead(node);
        }

        private static class Node<K, V> {
            K key;
            V value;
            Node<K, V> prev;
            Node<K, V> next;

            Node() {
            }

            Node(K key, V value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

