/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.log;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.log.MaskedStringBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utils {
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String DOT_REGEX = "\\.";
    public static final String SLASH = "/";
    public static final String EMPTY_STRING = "";
    public static final String OFFSET_VALIDATION_ERROR = "Offset must be greater than or equal to zero";
    public static final String BALLERINA_LOG_CLASS_NAME = "ballerina.log";
    public static final String INVOKED_FUNCTION_NAME = "getInvokedModuleName";

    private Utils() {
    }

    public static BString getInvokedModuleName(long offset) {
        if (offset < 0L) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)OFFSET_VALIDATION_ERROR));
        }
        return StackWalker.getInstance().walk(stackFrameStream -> stackFrameStream.dropWhile(frame -> {
            String className = frame.getClassName();
            String methodName = frame.getMethodName();
            return !className.startsWith(BALLERINA_LOG_CLASS_NAME) || !methodName.equals(INVOKED_FUNCTION_NAME);
        }).skip(offset + 1L).findFirst().map(frame -> {
            String className = frame.getClassName();
            String[] pkgData = className.split(DOT_REGEX);
            if (pkgData.length > 1) {
                String module = IdentifierUtils.decodeIdentifier((String)pkgData[1]);
                return StringUtils.fromString((String)(pkgData[0] + SLASH + module));
            }
            return StringUtils.fromString((String)EMPTY_STRING);
        }).orElse(StringUtils.fromString((String)EMPTY_STRING)));
    }

    public static BString getCurrentTime() {
        return StringUtils.fromString((String)new SimpleDateFormat(SIMPLE_DATE_FORMAT).format(new Date()));
    }

    public static BString toMaskedString(Environment env, Object value) {
        try (MaskedStringBuilder builder = MaskedStringBuilder.create(env.getRuntime());){
            BString bString = StringUtils.fromString((String)builder.build(value));
            return bString;
        }
    }
}

