/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.metrics.Counter;
import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.Gauge;
import io.ballerina.runtime.observability.metrics.Metric;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.PolledGauge;
import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.runtime.observability.metrics.Tags;
import io.ballerina.stdlib.observe.nativeimpl.Utils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LookupMetric {
    public static Object lookupMetric(Environment env, BString metricName, Object tags) {
        Map<String, String> tagMap = Utils.toStringMap((BMap)tags);
        HashSet tagSet = new HashSet();
        Tags.tags(tagSet, tagMap);
        Metric metric = DefaultMetricRegistry.getInstance().lookup(new MetricId(metricName.getValue(), "", tagSet));
        if (metric != null) {
            MetricId metricId = metric.getId();
            if (metric instanceof Counter) {
                BObject counter = ValueCreator.createObjectValue((Module)env.getCurrentModule(), (String)"Counter", (Object[])new Object[]{StringUtils.fromString((String)metricId.getName()), StringUtils.fromString((String)metricId.getDescription()), LookupMetric.getTags(metricId)});
                counter.addNativeData("__metric_native_instance__", (Object)metric);
                return counter;
            }
            if (metric instanceof Gauge) {
                Gauge gauge = (Gauge)metric;
                BArray statisticConfigs = Utils.createBStatisticConfig(env, gauge.getStatisticsConfig());
                BObject bGauge = ValueCreator.createObjectValue((Module)env.getCurrentModule(), (String)"Gauge", (Object[])new Object[]{StringUtils.fromString((String)metricId.getName()), StringUtils.fromString((String)metricId.getDescription()), LookupMetric.getTags(metricId), statisticConfigs});
                bGauge.addNativeData("__metric_native_instance__", (Object)metric);
                return bGauge;
            }
            if (metric instanceof PolledGauge) {
                BArray statisticConfigs = Utils.createBStatisticConfig(env, null);
                BObject bGauge = ValueCreator.createObjectValue((Module)env.getCurrentModule(), (String)"Gauge", (Object[])new Object[]{StringUtils.fromString((String)metricId.getName()), StringUtils.fromString((String)metricId.getDescription()), LookupMetric.getTags(metricId), statisticConfigs});
                bGauge.addNativeData("__metric_native_instance__", (Object)metric);
                return bGauge;
            }
        }
        return null;
    }

    private static BMap<BString, Object> getTags(MetricId metricId) {
        BMap bTags = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING));
        Set tags = metricId.getTags();
        for (Tag tag : tags) {
            bTags.put((Object)StringUtils.fromString((String)tag.getKey()), (Object)StringUtils.fromString((String)tag.getValue()));
        }
        return bTags;
    }
}

