# Object

The `object` is a basic data type in Ballerina. An object value has named methods and fields and these methods and fields share the same symbol space. This means that it is not possible for an object to have both a field and a method with the same name.

A `class` is used to define an object type and provides a way to construct an object. The `new` expression is used to create an object from a `class` definition.

::: code object.bal :::

::: out object.out :::

## Related links
- [Defining classes](/learn/by-example/defining-classes/)
- [Object constructor](/learn/by-example/object-constructor/)
- [Object value from class definition](/learn/by-example/object-value-from-class-definition/)
- [Visibility of object fields and methods](/learn/by-example/visibility-of-object-fields-and-methods/)
- [Object types](/learn/by-example/object-types/)
- [Object closure](/learn/by-example/object-closure/)
