// Copyright (c) 2025 WSO2 LLC (http://www.wso2.com).
//
// WSO2 LLC. licenses this file to you under the Apache License,
// Version 2.0 (the "License"); you may not use this file except
// in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// AUTO-GENERATED FILE.
// This file is auto-generated by the Ballerina OpenAPI tool.

import ballerina/data.jsondata;
import ballerina/http;

public type ErrorPayloadInternalServerError record {|
    *http:InternalServerError;
    ErrorPayload body;
|};

public type ContentFilterIdResult record {
    *ContentFilterResultBase;
    string id;
};

public type ChatCompletionRequestMessage record {
    # The role of the messages author
    ChatCompletionRequestMessageRole role;
};

public type ContentFilterDetectedResult record {
    *ContentFilterResultBase;
    boolean detected;
};

# Information about the content filtering results
public type ContentFilterResultsBase record {
    @jsondata:Name {value: "self_harm"}
    ContentFilterSeverityResult selfHarm?;
    @jsondata:Name {value: "custom_blocklists"}
    ContentFilterIdResult[] customBlocklists?;
    ContentFilterSeverityResult hate?;
    ContentFilterDetectedResult profanity?;
    ErrorBase 'error?;
    ContentFilterSeverityResult sexual?;
    ContentFilterSeverityResult violence?;
};

# The function that the model called
public type ChatCompletionMessageToolCall_function record {
    # The name of the function to call.
    string name;
    # The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
    string arguments;
};

# Controls which (if any) function is called by the model. `none` means the model will not call a function and instead generates a message. `auto` means the model can pick between generating a message or calling a function. Specifying a particular function via `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that function
public type ChatCompletionToolChoiceOption "none"|"auto"|ChatCompletionNamedToolChoice;

# Provides a set of configurations for controlling the behaviours when communicating with a remote HTTP endpoint.
@display {label: "Connection Config"}
public type ConnectionConfig record {|
    # Provides Auth configurations needed when communicating with a remote HTTP endpoint.
    http:BearerTokenConfig|ApiKeysConfig auth;
    # The HTTP version understood by the client
    http:HttpVersion httpVersion = http:HTTP_2_0;
    # Configurations related to HTTP/1.x protocol
    http:ClientHttp1Settings http1Settings = {};
    # Configurations related to HTTP/2 protocol
    http:ClientHttp2Settings http2Settings = {};
    # The maximum time to wait (in seconds) for a response before closing the connection
    decimal timeout = 30;
    # The choice of setting `forwarded`/`x-forwarded` header
    string forwarded = "disable";
    # Configurations associated with Redirection
    http:FollowRedirects followRedirects?;
    # Configurations associated with request pooling
    http:PoolConfiguration poolConfig?;
    # HTTP caching related configurations
    http:CacheConfig cache = {};
    # Specifies the way of handling compression (`accept-encoding`) header
    http:Compression compression = http:COMPRESSION_AUTO;
    # Configurations associated with the behaviour of the Circuit Breaker
    http:CircuitBreakerConfig circuitBreaker?;
    # Configurations associated with retrying
    http:RetryConfig retryConfig?;
    # Configurations associated with cookies
    http:CookieConfig cookieConfig?;
    # Configurations associated with inbound response size limits
    http:ResponseLimitConfigs responseLimits = {};
    # SSL/TLS-related options
    http:ClientSecureSocket secureSocket?;
    # Proxy server related options
    http:ProxyConfig proxy?;
    # Provides settings related to client socket configuration
    http:ClientSocketConfig socketConfig = {};
    # Enables the inbound payload validation functionality which provided by the constraint package. Enabled by default
    boolean validation = true;
    # Enables relaxed data binding on the client side. When enabled, `nil` values are treated as optional, 
    # and absent fields are handled as `nilable` types. Enabled by default.
    boolean laxDataBinding = true;
|};

# Information about the content filtering category (hate, sexual, violence, self_harm), if it has been detected, as well as the severity level (very_low, low, medium, high-scale that determines the intensity and risk level of harmful content) and if it has been filtered or not. Information about third party text and profanity, if it has been detected, and if it has been filtered or not. And information about customer block list, if it has been filtered and its id
public type ContentFilterChoiceResults record {
    *ContentFilterResultsBase;
    @jsondata:Name {value: "protected_material_text"}
    ContentFilterDetectedResult protectedMaterialText?;
    @jsondata:Name {value: "protected_material_code"}
    ContentFilterDetectedWithCitationResult protectedMaterialCode?;
};

# The type of the tool. Currently, only `function` is supported
public type ChatCompletionToolType "function";

# Information about the content filtering category (hate, sexual, violence, self_harm), if it has been detected, as well as the severity level (very_low, low, medium, high-scale that determines the intensity and risk level of harmful content) and if it has been filtered or not. Information about jailbreak content and profanity, if it has been detected, and if it has been filtered or not. And information about customer block list, if it has been filtered and its id
public type ContentFilterPromptResults record {
    *ContentFilterResultsBase;
    ContentFilterDetectedResult jailbreak?;
};

# Setting to `json_object` enables JSON mode. This guarantees that the message the model generates is valid JSON
public type ChatCompletionResponseFormat "text"|"json_object"?;

# Represents the Headers record for the operation: chatCompletions
public type ChatCompletionsHeaders record {
    @http:Header {name: "x-jwt-assertion"}
    string? xJwtAssertion?;
};

public type InputItemsString string;

# The type of the tool call, in this case `function`
public type ToolCallType "function";

public type ChatCompletionTool record {
    ChatCompletionTool_function 'function;
    # The type of the tool. Currently, only `function` is supported
    ChatCompletionToolType 'type;
};

# An object specifying the format that the model must output. Used to enable JSON mode.
public type CreateChatCompletionRequest_response_format record {
    # Setting to `json_object` enables JSON mode. This guarantees that the message the model generates is valid JSON
    ChatCompletionResponseFormat? 'type?;
};

public type ErrorPayload record {
    string reason;
    string path;
    string method;
    string message;
    string timestamp;
    int status;
};

public type EmbeddingResponseOk record {|
    *http:Ok;
    EmbeddingResponse body;
|};

public type ContentFilterSeverityResult record {
    *ContentFilterResultBase;
    "safe"|"low"|"medium"|"high" severity;
};

# Provides API key configurations needed when communicating with a remote HTTP endpoint.
public type ApiKeysConfig record {|
    string apiKey;
|};

public type EmbeddingResponse_usage record {
    @jsondata:Name {value: "prompt_tokens"}
    int promptTokens;
    @jsondata:Name {value: "total_tokens"}
    int totalTokens;
};

# Specifies a tool the model should use. Use to force the model to call a specific function
public type ChatCompletionNamedToolChoice record {
    ChatCompletionNamedToolChoice_function 'function?;
    # The type of the tool. Currently, only `function` is supported
    "function" 'type?;
};

public type ContentFilterResultBase record {
    boolean filtered;
};

public type CreateChatCompletionResponseOk record {|
    *http:Ok;
    CreateChatCompletionResponse body;
|};

# Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model
public type ChatCompletionFunctionCall record {
    # The name of the function to call
    string name;
    # The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function
    string arguments;
};

# The role of the messages author
public type ChatCompletionRequestMessageRole "system"|"user"|"assistant"|"tool"|"function";

public type ChatCompletionChoiceCommon record {
    @jsondata:Name {value: "finish_reason"}
    string finishReason?;
    int index?;
};

public type CreateChatCompletionRequest record {
    *ChatCompletionsRequestCommon;
    # An object specifying the format that the model must output. Used to enable JSON mode.
    CreateChatCompletionRequest_response_format response_format?;
    # If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.
    int? seed = 0;
    # Deprecated in favor of `tools`. A list of functions the model may generate JSON inputs for.
    ChatCompletionFunction[] functions?;
    # Deprecated in favor of `tool_choice`. Controls how the model responds to function calls. "none" means the model does not call a function, and responds to the end-user. "auto" means the model can pick between an end-user or calling a function.  Specifying a particular function via `{"name":\ "my_function"}` forces the model to call that function. "none" is the default when no functions are present. "auto" is the default if functions are present.
    @jsondata:Name {value: "function_call"}
    "none"|"auto"|record {string name;} functionCall?;
    # A list of messages comprising the conversation so far. [Example Python code](https://github.com/openai/openai-cookbook/blob/main/examples/How_to_format_inputs_to_ChatGPT_models.ipynb).
    ChatCompletionRequestMessage[] messages;
    @jsondata:Name {value: "tool_choice"}
    ChatCompletionToolChoiceOption toolChoice?;
    # A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for.
    ChatCompletionTool[] tools?;
    # How many chat completion choices to generate for each input message.
    int? n = 1;
};

public type ChatCompletionsResponseCommon record {
    # The Unix timestamp (in seconds) of when the chat completion was created
    int created;
    # Usage statistics for the completion request
    CompletionUsage usage?;
    # The model used for the chat completion
    string model;
    # A unique identifier for the chat completion
    string id;
    # Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism
    @jsondata:Name {value: "system_fingerprint"}
    string systemFingerprint?;
    # The object type
    ChatCompletionResponseObject 'object;
};

public type ErrorBase record {
    string code?;
    string message?;
};

public type ChatCompletionsRequestCommon record {
    # An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
    # We generally recommend altering this or `temperature` but not both
    @jsondata:Name {value: "top_p"}
    decimal? topP?;
    # Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim
    @jsondata:Name {value: "frequency_penalty"}
    decimal frequencyPenalty?;
    # Modify the likelihood of specified tokens appearing in the completion. Accepts a json object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token
    @jsondata:Name {value: "logit_bias"}
    record {}? logitBias?;
    # Up to 4 sequences where the API will stop generating further tokens
    string|string[]? stop?;
    # If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only server-sent events as they become available, with the stream terminated by a `data: [DONE]` message
    boolean? 'stream?;
    # The maximum number of tokens allowed for the generated answer. By default, the number of tokens the model can return will be (4096 - prompt tokens)
    @jsondata:Name {value: "max_tokens"}
    int maxTokens?;
    # Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics
    @jsondata:Name {value: "presence_penalty"}
    decimal presencePenalty?;
    # What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
    # We generally recommend altering this or `top_p` but not both
    decimal? temperature?;
    # A unique identifier representing your end-user, which can help Azure OpenAI to monitor and detect abuse
    string user?;
};

# The role of the author of the response message
public type ChatCompletionResponseMessageRole "assistant";

# Usage statistics for the completion request
public type CompletionUsage record {
    # Number of tokens in the generated completion
    @jsondata:Name {value: "completion_tokens"}
    int completionTokens;
    # Number of tokens in the prompt
    @jsondata:Name {value: "prompt_tokens"}
    int promptTokens;
    # Total number of tokens used in the request (prompt + completion)
    @jsondata:Name {value: "total_tokens"}
    int totalTokens;
};

# The object type
public type ChatCompletionResponseObject "chat.completion";

# Represents the Headers record for the operation: embeddings_create
public type EmbeddingsCreateHeaders record {
    @http:Header {name: "x-jwt-assertion"}
    string? xJwtAssertion?;
};

public type ChatCompletionNamedToolChoice_function record {
    # The name of the function to call.
    string name;
};

public type EmbeddingResponse_data record {
    int index;
    float[] embedding;
    string 'object;
};

# Content filtering results for a single prompt in the request
public type PromptFilterResult record {
    @jsondata:Name {value: "content_filter_results"}
    ContentFilterPromptResults contentFilterResults?;
    @jsondata:Name {value: "prompt_index"}
    int promptIndex?;
};

# Content filtering results for zero or more prompts in the request. In a streaming request, results for different prompts may arrive at different times or in different orders
public type PromptFilterResults PromptFilterResult[];

public type CreateChatCompletionResponse record {
    *ChatCompletionsResponseCommon;
    @jsondata:Name {value: "prompt_filter_results"}
    PromptFilterResults promptFilterResults?;
    record {*ChatCompletionChoiceCommon; @jsondata:Name {value: "content_filter_results"}
        ContentFilterChoiceResults contentFilterResults?; ChatCompletionResponseMessage message?;}[] choices;
};

public type ChatCompletionMessageToolCall record {
    # The function that the model called
    ChatCompletionMessageToolCall_function 'function;
    # The ID of the tool call
    string id;
    # The type of the tool call, in this case `function`
    ToolCallType 'type;
};

public type EmbeddingRequest record {
    # Input text to get embeddings for, encoded as a string. To get embeddings for multiple inputs in a single request, pass an array of strings. Each input must not exceed 2048 tokens in length.
    # Unless you are embedding code, we suggest replacing newlines (\n) in your input with a single space, as we have observed inferior results when newlines are present.
    string|InputItemsString[]? input;
    # A unique identifier representing your end-user, which can help monitoring and detecting abuse.
    string user?;
    # input type of embedding search to use
    string input_type?;
    # ID of the model to use. You can use the Models_List operation to see all of your available models, or see our Models_Get overview for descriptions of them.
    string model?;
};

public type ContentFilterDetectedWithCitationResult record {
    *ContentFilterDetectedResult;
    boolean filtered;
    ContentFilterDetectedWithCitationResult_citation citation?;
};

# A chat completion message generated by the model
public type ChatCompletionResponseMessage record {
    # The role of the author of the response message
    ChatCompletionResponseMessageRole role?;
    @jsondata:Name {value: "function_call"}
    ChatCompletionFunctionCall functionCall?;
    # The tool calls generated by the model, such as function calls
    @jsondata:Name {value: "tool_calls"}
    ChatCompletionMessageToolCall[] toolCalls?;
    # The contents of the message
    string? content?;
};

public type ErrorPayloadBadRequest record {|
    *http:BadRequest;
    ErrorPayload body;
|};

public type ContentFilterDetectedWithCitationResult_citation record {
    string license?;
    @jsondata:Name {value: "URL"}
    string uRL?;
};

public type EmbeddingResponse record {
    EmbeddingResponse_data[] data;
    EmbeddingResponse_usage usage;
    string model;
    string 'object;
};

public type ChatCompletionTool_function record {
    # A description of what the function does, used by the model to choose when and how to call the function.
    string description?;
    # The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
    string name;
    # The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/gpt/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format
    ChatCompletionFunctionParameters parameters;
};

public type ChatCompletionFunction record {
    # The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64
    string name;
    # The description of what the function does
    string description?;
    # The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/gpt/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format
    ChatCompletionFunctionParameters parameters?;
};

# The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/gpt/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format
public type ChatCompletionFunctionParameters record {
};
