## Overview

This module provides the capabilities to generate cloud artifacts for Ballerina programs.

This module generates the [Kubernetes](https://kubernetes.io/) and [Docker](https://www.docker.com/) artifacts required to deploy a Ballerina program in the cloud. 

Supports following artifact generation:
- Kubernetes deployment 
- Kubernetes service
- Kubernetes liveness probe
- Kubernetes readiness probe
- Kubernetes config map
- Kubernetes horizontal pod autoscaler
- Docker image  
- Dockerfile 

**The base image required for the module is published to [Dockerhub](https://hub.docker.com/r/ballerina/jvm-runtime)**

## Docker artifact generation

Build the Ballerina Program with `--cloud=docker` option to generate Docker artifacts (Dockerfile and Docker image). 

```bash
$> bal build --cloud=docker
Compiling source
	hello/hello:0.0.1

Creating balas
	target/bala/hello-2020r2-any-0.0.1.bala

Running Tests

	hello/hello:0.0.1
	No tests found


Generating executables
	target/bin/hello.jar

Generating artifacts...

	@kubernetes:Docker 			 - complete 2/2

    Execute the below command to run the generated docker image:
    docker run -d -p 9090:9090 anuruddhal/hello-api:sample8

    target/bin/hello-0.0.1.jar
``` 

## Kubernetes artifact generation

Build the Ballerina Program with `--cloud=k8s` option to generate Docker and Kubernetes artifacts. 

```bash
$> bal build --cloud=k8s
Compiling source
	hello/hello:0.0.1

Creating balas
	target/bala/hello-2020r2-any-0.0.1.bala

Running Tests

	hello/hello:0.0.1
	No tests found


Generating executables
	target/bin/hello.jar

Generating artifacts...

	@kubernetes:Service 		- complete 1/1
	@kubernetes:Deployment 	    - complete 1/1
	@kubernetes:HPA 			- complete 1/1
	@kubernetes:Docker 			- complete 2/2

	Execute the below command to deploy the Kubernetes artifacts:
	kubectl apply -f /Users/anuruddha/workspace/ballerinax/module-ballerina-c2c/samples/sample2/target/kubernetes/hello

	Execute the below command to access service via NodePort:
	kubectl expose deployment hello-hello-0-0-deployment --type=NodePort --name=hello-hello-0-0-svc-local
``` 

## Cloud.toml
The configuration file to be used to override the default values generated by code to cloud.
The `Cloud.toml` file is completely optional and only has to specify the values that need to be overridden. 
If the value is not specified for a certain field, the compiler will take the default value.
All the supported properties can be found [here](https://github.com/ballerina-platform/ballerina-spec/blob/master/c2c/code-to-cloud-spec.md#cloudtoml-properties).
